/*
 *	machine.h - interface to Encore Multimax
 */

#ifndef INCLUDE_HOST
#define INCLUDE_HOST

/*	MaxPe is the maximum number of parallel processes the system
 *	will support.  it must be a constant. 
 */
#define MaxPe 25

/*	MyPenum is a unique integer index between 0 and MaxPe-1 associated
 *	with each parallel process.  This is used as an array index to
 *	allow data to be local to a process on machines, such as the max,
 *	which don't otherwise support local data!
 */
#ifdef HOST
#define MyPenum 0
#else
#define MyPenum m_myid
#endif
#define MaxMem 1000000

#define SHARED 1
#define NULLPTR 0L
typedef char  BYTE;		/* this defn is m/c dependent 
				   it must be 8 bits */
typedef short SHORT;		/* this defn is m/c dependent. 
				   It must be 16 bits */
typedef int LONG;	     	/* this defn is m/c dependent. 
				   It must be 32 bits */
typedef unsigned int BOOLEAN;
typedef unsigned int PVECTOR;

/*===  interface to OS spin locks  ===*/
#include <parallel/parallel.h>
#include <parallel/microtask.h>

/*	OsSpinInit, OsSpinLock and OsSpinUnlock
 *	initialize, reserve and release a spin lock, respectively.
 *	the argument to each of these functions is a variable of type
 *	LOCK, which is typedef'd appropriately.  (Spin locks are implemented
 *	variously as pointers or structures.)
 */
typedef slock_t SPINLOCK;
#define OsSpinInit(l) S_INIT_LOCK(&(l))
#define OsSpinLock(l) S_LOCK(&(l))
#define OsSpinUnlock(l) S_UNLOCK(&(l))

/*	OsSharedMalloc is the system's shared memory version of malloc.
 */
#define OsSharedMalloc shmalloc
#define OsSharedMfree shfree

/* OsAllocMsg and OsFreeMsg are just OsAlloc and OsFree on shared memory
 * machines.
 */
#define OsAllocMsg(n) OsAlloc(n)
#define OsFreeMsg(p) OsFree(p)

/*	local and shared are special C declarators which designate variables
 *	residing in local or shared memory.  if the system doesn't have a
 *	way to distinguish these, #define them to null.  currently only
 *	shared is used.
 */
#define private

#define OsMyid m_myid


#endif
