
#include "host.h"
#include "cksys.h"

#include "qs_stack.h"
#include "qs_stack_macros.c"

#define		MAXHEAPSIZE	 20000
#define		MAXRESPHEAPSIZE	 20000
#define		INDEX_1		 8191
#define		INDEX_2		 8191

#define TRACEQS(p)
#define TRACEQM(p)
#define TRACEHT(p)

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int	PrintQueStat = FALSE;
extern  shared	int numPe;
int	ChareStackLength = 0;
int	MaxChareStackLength = 0;
int	RespStackLength[MaxPe];
int	MaxStackLength[MaxPe];

int	MaxChareHeapLength = -1;
int	MaxRespHeapLength[MaxPe];


int 		ChareHeapTop;
HEAPELEMENT	ChareHeap[MAXHEAPSIZE];

HASHELT		*ChareHashTable[INDEX_1];

int 		RespHeapTop[MaxPe];
HEAPELEMENT	RespHeap[MaxPe][MAXRESPHEAPSIZE];

HASHELT		*RespHashTable[MaxPe][INDEX_2];



QSInit()
{
	int i, j, Penum;

	OsSpinInit(chareLock);
	ChareHeapTop = -1;

	for (Penum=0; Penum<MaxPe; Penum++) 
	{
 		OsSpinInit(respLock[Penum]);
		RespHeapTop[Penum] = -1;
		RespStackLength[Penum] = 0;
		MaxStackLength[Penum] = 0;
		MaxRespHeapLength[MaxPe] = -1;
	}

	for (i=0; i < MAXHEAPSIZE; i++)
	{
		ChareHeap[i].hash_ptr = NULLPTR; 
		ChareHeap[i].stack_ptr = NULLPTR;
	}

	for (i=0; i < MaxPe; i++)
	    for ( j=0; j<MAXRESPHEAPSIZE; j++)
	    {
		RespHeap[i][j].hash_ptr = NULLPTR;
		RespHeap[i][j].stack_ptr = NULLPTR;
	    }

	for(j=0; j < INDEX_1; j++)
		ChareHashTable[j] = NULLPTR;

	for(i=0; i < MaxPe; i++)
	    for(j=0; j < INDEX_2; j++)
		RespHashTable[i][j] = NULLPTR;
}



QSEmptyResponses(Penum)
int Penum;
{
	return( RespHeapTop[Penum] < 0 );
}


QSEmptyChares()
{
	return( ChareHeapTop < 0 );
}


QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect CreateChare() call, use CreateChareGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	OsPrintf("Incorrect SendMsg() call, use SendMsgGen() call\n");
	OsKillSys();
	exit(1);
}


QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
int	Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueChareGen: CHARE Priority %d\n", Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_CHAR);

	QsLockChares();
	QmEnQueueChareMsg(mPtr);
	QsUnlockChares();
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
int	Prio;
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueResponseGen:PE %d, RESPONSE Priority %d\n",Penum, Prio));
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, Prio, SYSMSGTYPE_RESP);

	QsLockResponses(Penum);
	QmEnQueueRespMsg(Penum,mPtr);
	QsUnlockResponses(Penum);
}


PickNextMsg(MsgType, CurrentAR,  CurrentMsg,  CurrentEP)
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
 JOBTYPE *MsgType;
{ 
  int	resp_priority;

  QsLockResponses(MyPenum);
  if (QSEmptyResponses(MyPenum))
  {
     QsUnlockResponses(MyPenum);
     QsLockChares();
     if (QSEmptyChares()) {QsUnlockChares(); return(NULL); }
       else 
       { QSDeQueueChareMsg(MsgType, CurrentAR,CurrentMsg,CurrentEP); 
	      QsUnlockChares(); }
  }
  else
  {
     resp_priority = RespHeap[MyPenum][0].stack_ptr->sysMsgPVector;
     QsUnlockResponses(MyPenum);

     QsLockChares();
     if (QSEmptyChares())
	{ 
	   QsUnlockChares();
  	   QsLockResponses(MyPenum);
     	   QSDeQueueResponseMsg(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     	   QsUnlockResponses(MyPenum);
	}
	else
	{
	   if (ChareHeap[0].stack_ptr->sysMsgPVector >= resp_priority)
	   {
		QsUnlockChares();
  		QsLockResponses(MyPenum);
     		QSDeQueueResponseMsg(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     		QsUnlockResponses(MyPenum);
	   }
	   else
	   {
       		QSDeQueueChareMsg(MsgType,CurrentAR,CurrentMsg,CurrentEP); 
		QsUnlockChares();
	   }
	}
    }
	
return(1);
}


QSDeQueueChareMsg(MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueChareMsg();
/*
TRACEQS(OsPrintf("QSDeQueueChareMsg:\n"));
*/
	mPtr = QmDeQueueChareMsg();

	*MsgType    = JOBTYPE_CHARE;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}


QSDeQueueResponseMsg(Penum,MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP, Penum;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueRespMsg();
/*
TRACEQS(OsPrintf("QSDeQueueRespMsg: PE %d\n", Penum));
*/
	mPtr = QmDeQueueRespMsg(Penum);

	*MsgType    = JOBTYPE_RESP;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}


QmEnQueueChareMsg( mPtr )
SYSMSG	*mPtr;
{


	HASHPTR		c_ht_elt, l_ht_elt, ht_element, sent_element;
	int		index_1, vector_size, hash_vec_size;
	int		qs_vector_size();

	if ( PrintQueStat == TRUE )
	{
		ChareStackLength++;
		if ( ChareStackLength > MaxChareStackLength)
			MaxChareStackLength = ChareStackLength;
	}

/*
TRACEQS(OsPrintf("QmEnQueueChareMsg() -------------------------------\n"));
*/

		/* hash table index is the MOD of 8191 */
		index_1 = mPtr->sysMsgPVector % 8191; 

		if( ChareHashTable[ index_1 ] == NULLPTR )
		{
			NEWHASHELEMENT(sent_element,NULLPTR,NULLPTR);
			INSERT_HASHTABLE(index_1,sent_element);
		}


		if(ChareHashTable[ index_1 ]->next_htlist_element == NULLPTR)
		{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,ChareHashTable[index_1]);
			InsertHeapMsg(ht_element);
			INSERT_HASHTABLE(index_1,ht_element);
			INSERT_HEAP_GOAL_STACK(ht_element, mPtr);
		}
		else
		{
			c_ht_elt = ChareHashTable[ index_1 ];

			while( (c_ht_elt->next_htlist_element != NULLPTR) &&
	          (c_ht_elt->priority_vector != mPtr->sysMsgPVector) )
			{
				l_ht_elt = c_ht_elt;
				c_ht_elt = c_ht_elt->next_htlist_element;
			}

			if (c_ht_elt->next_htlist_element == NULLPTR) 
			{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,ChareHashTable[index_1]);
				InsertHeapMsg(ht_element);
				INSERT_HASHTABLE(index_1,ht_element);
				INSERT_HEAP_GOAL_STACK(ht_element, mPtr);
			}
			else
			{
				mPtr->sysMsgNextPtr =
					(c_ht_elt->heap_ptr)->stack_ptr;
				INSERT_HEAP_GOAL_STACK(c_ht_elt, mPtr);
			}
		}
}



/* remove the top of stack from the top element of the heap and return
   a pointer to the stack element removed.
   if the top of stack is the last element then reorganize the heap
   and delete the hash table list element from the chain of the hash
   table */
SYSMSG 	*QmDeQueueChareMsg()
{

	SYSMSG		*mPtr;
	HASHPTR		ht_ptr;

	mPtr = NULLPTR;

    	if ( PrintQueStat == TRUE ) ChareStackLength--;

		mPtr = ChareHeap[0].stack_ptr;
		ChareHeap[0].stack_ptr=(ChareHeap[0].stack_ptr)->sysMsgNextPtr;

/*
	      OsPrintf("DeQueue Task -------------------------------------\n");
	      OsPrintf("Priority = %d\n", mPtr->sysMsgPVector);
*/

	/* if ChareHeap[0] stack becomes empty then reorganize the heap */
	if ( ChareHeap[0].stack_ptr == NULLPTR ) 
		{
		ht_ptr = ChareHeap[0].hash_ptr;
		RestoreChareHeap();
		RemoveHashTableElt(ht_ptr);
		} 

     return(mPtr);
}



/* insert a new hash table list element pointed by p into the heap */
InsertHeapMsg(p)
HASHPTR p;

{

	int parent, child;

/*
		OsPrintf("InsertHeapMsg()-------------------------\n");
	        OsPrintf("Priority = %d\n", p->priority_vector);
*/

	ChareHeapTop++;
	if ( PrintQueStat == TRUE )
	{
	    if ( ChareHeapTop > MaxChareHeapLength)
		MaxChareHeapLength = ChareHeapTop;
	}

	if (ChareHeapTop >= MAXHEAPSIZE)
		{OsPrintf("CHARE HEAP OVERFLOW: Need A Larger Heap Than %d\n", MAXHEAPSIZE);
		 OsKillSys();
		 exit(1);}

	child = ChareHeapTop;
	if (child > 0)
		parent = (ChareHeapTop-1) >> 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent bit vector >= p->bit vector */
	while ( (child > 0) && 
		( (ChareHeap[parent].hash_ptr)->priority_vector >
					p->priority_vector) ) {
		ChareHeap[child].hash_ptr = ChareHeap[parent].hash_ptr;
		ChareHeap[child].stack_ptr = ChareHeap[parent].stack_ptr;
		(ChareHeap[child].hash_ptr)->heap_ptr = &ChareHeap[child];

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	ChareHeap[child].hash_ptr = p;
	ChareHeap[child].stack_ptr = NULLPTR;
	p->heap_ptr = &ChareHeap[child];
}


/* reorganize the heap */
RestoreChareHeap()
{

	SYSMSG		*temp_stack_ptr;
	HASHPTR 	temp_hash_ptr;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = ChareHeapTop;
   	ChareHeapTop--;

	switch (last_item)
	{
	case 0 :
	   	ChareHeap[0].hash_ptr = NULLPTR;
	   	ChareHeap[0].stack_ptr = NULLPTR;
		break;

	case 1 :
		ChareHeap[0].hash_ptr = ChareHeap[1].hash_ptr;
		(ChareHeap[0].hash_ptr)->heap_ptr = &ChareHeap[0];
		ChareHeap[0].stack_ptr = ChareHeap[1].stack_ptr;

	   	ChareHeap[1].hash_ptr = NULLPTR;
	   	ChareHeap[1].stack_ptr = NULLPTR;
		break;

	default :
	   temp_hash_ptr = ChareHeap[last_item].hash_ptr;
	   temp_stack_ptr = ChareHeap[last_item].stack_ptr;
	   ChareHeap[last_item].hash_ptr = NULLPTR;
	   ChareHeap[last_item].stack_ptr = NULLPTR;

	   while ( child1 <= ChareHeapTop && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= ChareHeapTop) && 
			((ChareHeap[child1].hash_ptr)->priority_vector >
			  (ChareHeap[child2].hash_ptr)->priority_vector) )
			min = child2;

		if ( temp_hash_ptr->priority_vector >
			      (ChareHeap[min].hash_ptr)->priority_vector ) 
		{
		   ChareHeap[parent].hash_ptr = ChareHeap[min].hash_ptr;
		   (ChareHeap[parent].hash_ptr)->heap_ptr = &ChareHeap[parent];
		   ChareHeap[parent].stack_ptr = ChareHeap[min].stack_ptr;

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   ChareHeap[parent].hash_ptr = temp_hash_ptr;
	   (ChareHeap[parent].hash_ptr)->heap_ptr = &ChareHeap[parent];
	   ChareHeap[parent].stack_ptr = temp_stack_ptr;

	} /* switch */
}


/* remove the hash table list element pointed by ht_ptr from the chain of hash
   table list elements */
RemoveHashTableElt(ht_ptr)
HASHPTR		ht_ptr;
{

	int 			size;
	HASHPTR			c_ht_elt, n_ht_elt;

	c_ht_elt = ht_ptr;
	n_ht_elt = ht_ptr->next_htlist_element;

	if ( n_ht_elt->next_htlist_element == NULLPTR )
	{
		c_ht_elt->next_htlist_element = NULLPTR;
		c_ht_elt->priority_vector = 0;
		c_ht_elt->heap_ptr = NULLPTR;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
	else
	{
		c_ht_elt->priority_vector = n_ht_elt->priority_vector;
		c_ht_elt->next_htlist_element = n_ht_elt->next_htlist_element;
		c_ht_elt->heap_ptr = n_ht_elt->heap_ptr;
		(c_ht_elt->heap_ptr)->hash_ptr = c_ht_elt;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
}



QmEnQueueRespMsg(Penum,mPtr)
SYSMSG	*mPtr;
int Penum;
{

	HASHPTR		c_ht_elt, l_ht_elt, ht_element, sent_element;
	int		index_1, vector_size, hash_vec_size;
	int		qs_vector_size();
	int 		j;
	int		TotStackLength = 0;

    if ( PrintQueStat == TRUE )
    {
	RespStackLength[Penum]++;
	TotStackLength = ChareStackLength;
	for (j=0; j<numPe; j++) 
 		TotStackLength += RespStackLength[j];

	if( TotStackLength > MaxStackLength[Penum] )
		MaxStackLength[Penum] = TotStackLength;
    }

/*
TRACEQS(OsPrintf("QmEnQueueRespMsg() -------------------------------\n"));
*/

	/* Hash function is the MOD of 8191 of the priority */
		index_1 = mPtr->sysMsgPVector % 8191; 
/*
TRACEQS(OsPrintf("hash table index_1 = %d\n", index_1));
*/
		if( RespHashTable[Penum][ index_1 ] == NULLPTR )
		{
			NEWHASHELEMENT(sent_element,NULLPTR,NULLPTR);
			INSERT_RESPHASHTABLE(Penum,index_1,sent_element);
		}

		if(RespHashTable[Penum][ index_1 ]->next_htlist_element == NULLPTR)
		{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,RespHashTable[Penum][index_1]);
			InsertRespHeapMsg(Penum,ht_element);
			INSERT_RESPHASHTABLE(Penum,index_1,ht_element);
			INSERT_HEAP_RESP_STACK(ht_element, mPtr);
		}
		else
		{
			c_ht_elt = RespHashTable[Penum][ index_1 ];

			while( (c_ht_elt->next_htlist_element != NULLPTR) &&
	          (c_ht_elt->priority_vector != mPtr->sysMsgPVector) )
			{
				l_ht_elt = c_ht_elt;
				c_ht_elt = c_ht_elt->next_htlist_element;
			}

			if (c_ht_elt->next_htlist_element == NULLPTR) 
			{
			NEWHASHELEMENT(ht_element,mPtr->sysMsgPVector,RespHashTable[Penum][index_1]);
			InsertRespHeapMsg(Penum,ht_element);
			INSERT_RESPHASHTABLE(Penum,index_1,ht_element);
			INSERT_HEAP_RESP_STACK(ht_element, mPtr);
			}
			else
			{
				mPtr->sysMsgNextPtr =
					(c_ht_elt->heap_ptr)->stack_ptr;
				INSERT_HEAP_RESP_STACK(c_ht_elt, mPtr);
			}
		}
}



/* remove the top of stack from the top element of the heap and return
   a pointer to the stack element removed.
   if the top of stack is the last element then reorganize the heap
   and delete the hash table list element from the chain of the hash
   table */
SYSMSG	*QmDeQueueRespMsg(Penum)
int	Penum;
{

	SYSMSG		*mPtr;
	HASHPTR		ht_ptr;

	mPtr = NULLPTR;

    	if ( PrintQueStat == TRUE ) RespStackLength[Penum]--;

		mPtr = RespHeap[Penum][0].stack_ptr;
		RespHeap[Penum][0].stack_ptr=(RespHeap[Penum][0].stack_ptr)->sysMsgNextPtr;

/*
	      OsPrintf("DeQueue Task -------------------------------------\n");
	      OsPrintf("Priority = %d\n", mPtr->sysMsgPVector);
*/

	/* if RespHeap[Penum][0] stack becomes empty then reorganize the heap */
	if ( (RespHeap[Penum][0].stack_ptr == NULLPTR) )
		{
		ht_ptr = RespHeap[Penum][0].hash_ptr;
		RestoreRespHeap(Penum);
		RemoveRespHashTableElt(Penum,ht_ptr);
		} 
     return(mPtr);
}


/* insert a new hash table list element pointed by p into the heap */
InsertRespHeapMsg(Penum,p)
int Penum;
HASHPTR p;

{

	int parent, child;

/*
		OsPrintf("InsertRespHeapMsg(Penum)-------------------------\n");
*/

	RespHeapTop[Penum]++;

    if ( PrintQueStat == TRUE )
    {
	if ( RespHeapTop[Penum] > MaxRespHeapLength[Penum])
		MaxRespHeapLength[Penum] = RespHeapTop[Penum];
    }
	if (RespHeapTop[Penum] >= MAXRESPHEAPSIZE)
		{OsPrintf("RESP HEAP OVERFLOW for PE %d: Need A Larger Heap Than %d\n", Penum, MAXRESPHEAPSIZE);
		 OsKillSys();
		 exit(1);}

	child = RespHeapTop[Penum];
	if (child > 0)
		parent = (RespHeapTop[Penum]-1) >> 1; /* array starts at zero */
	else
		parent = 0;

	/* while child >0 & parent bit vector >= p->bit vector */
	while ( (child > 0) && 
		((RespHeap[Penum][parent].hash_ptr)->priority_vector >
					p->priority_vector) ) {

		RespHeap[Penum][child].hash_ptr = RespHeap[Penum][parent].hash_ptr;
		RespHeap[Penum][child].stack_ptr = RespHeap[Penum][parent].stack_ptr;
		(RespHeap[Penum][child].hash_ptr)->heap_ptr = &RespHeap[Penum][child];

		child = parent;
		parent = (parent-1) >> 1; /* array starts at zero */
	}
	RespHeap[Penum][child].hash_ptr = p;
	RespHeap[Penum][child].stack_ptr = NULLPTR;
	p->heap_ptr = &RespHeap[Penum][child];
}


/* reorganize the heap */
RestoreRespHeap(Penum)
int Penum;
{

	SYSMSG		*temp_stack_ptr;
	HASHPTR 	temp_hash_ptr;
	int 		parent=0, child1=1, child2=2, min;
	int		NotDone=1, last_item;

	last_item = RespHeapTop[Penum];
   	RespHeapTop[Penum]--;

	switch (last_item)
	{
	case 0 :
	   	RespHeap[Penum][0].hash_ptr = NULLPTR;
	   	RespHeap[Penum][0].stack_ptr = NULLPTR;
		break;

	case 1 :
		RespHeap[Penum][0].hash_ptr = RespHeap[Penum][1].hash_ptr;
		(RespHeap[Penum][0].hash_ptr)->heap_ptr = &RespHeap[Penum][0];
		RespHeap[Penum][0].stack_ptr = RespHeap[Penum][1].stack_ptr;

	   	RespHeap[Penum][1].hash_ptr = NULLPTR;
	   	RespHeap[Penum][1].stack_ptr = NULLPTR;
		break;

	default :
	   temp_hash_ptr = RespHeap[Penum][last_item].hash_ptr;
	   temp_stack_ptr = RespHeap[Penum][last_item].stack_ptr;
	   RespHeap[Penum][last_item].hash_ptr = NULLPTR;
	   RespHeap[Penum][last_item].stack_ptr = NULLPTR;

	   while ( child1 <= RespHeapTop[Penum] && NotDone==1 )
	   {
		min = child1;
		if ((child2 <= RespHeapTop[Penum]) && 
		    ((RespHeap[Penum][child1].hash_ptr)->priority_vector >
		     (RespHeap[Penum][child2].hash_ptr)->priority_vector) )
			min = child2;

		if ( (temp_hash_ptr->priority_vector >
		      (RespHeap[Penum][min].hash_ptr)->priority_vector) ) 
		{
		   RespHeap[Penum][parent].hash_ptr = RespHeap[Penum][min].hash_ptr;
		   (RespHeap[Penum][parent].hash_ptr)->heap_ptr = &RespHeap[Penum][parent];
		   RespHeap[Penum][parent].stack_ptr = RespHeap[Penum][min].stack_ptr;

		   parent = min;
	   	   child2 = (parent +1) << 1;
	   	   child1 = child2 - 1;
		}
		else  
		   NotDone = 0;
	   } /* while */
	   RespHeap[Penum][parent].hash_ptr = temp_hash_ptr;
	   (RespHeap[Penum][parent].hash_ptr)->heap_ptr = &RespHeap[Penum][parent];
	   RespHeap[Penum][parent].stack_ptr = temp_stack_ptr;

	} /* switch */
}


/* remove the hash table list element pointed by ht_ptr from the chain of hash
   table list elements */
RemoveRespHashTableElt(Penum,ht_ptr)
int Penum;
HASHPTR		ht_ptr;
{

	int 			size;
	HASHPTR			c_ht_elt, n_ht_elt;



	c_ht_elt = ht_ptr;
	n_ht_elt = ht_ptr->next_htlist_element;

	if ( n_ht_elt->next_htlist_element == NULLPTR )
	{
		c_ht_elt->next_htlist_element = NULLPTR;
		c_ht_elt->priority_vector = 0;
		c_ht_elt->heap_ptr = NULLPTR;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
	else
	{
		c_ht_elt->priority_vector = n_ht_elt->priority_vector;
		c_ht_elt->next_htlist_element = n_ht_elt->next_htlist_element;
		c_ht_elt->heap_ptr = n_ht_elt->heap_ptr;
		(c_ht_elt->heap_ptr)->hash_ptr = c_ht_elt;
		Free_HashElt(n_ht_elt, sizeof(HASHELT));
	}
}


QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_stack_length = 0;
	int max_heap_length = -1;

    if ( PrintQueStat == TRUE )
    {
	for ( i=0; i<numPe; i++)
	{
		if ( MaxStackLength[i] > max_stack_length )
			max_stack_length = MaxStackLength[i];
		if ( MaxRespHeapLength[i] > max_heap_length )
			max_heap_length = MaxRespHeapLength[i];
	}

	OsPrintf("Queue Status:\n");
	OsPrintf("MaxStackLength %d, MaxChareStack %d, MaxChareHeapSize %d, MaxRespHeapSize %d\n",
	max_stack_length, MaxChareStackLength, MaxChareHeapLength, max_heap_length);
    }

}


