
#include "host.h"
#include "cksys.h"

#include "qs_stack.h"
#include "qs_stack_macros.c"

#define MaxChares 200000
#define MaxResps  200000

int	PrintQueStat = FALSE;
extern shared int	numPe;
int	ChareQueueLength = 0;
int	MaxChareQueueLength = 0;

int	RespQueueLength[MaxPe];
int	MaxQueueLength[MaxPe];

SPINLOCK chareLock;
SPINLOCK respLock[MaxPe];

int	ChareQueueTop;
SYSMSG	*ChareQueueHead;
SYSMSG	*ChareQueueTail;

int	RespQueueTop[MaxPe];
SYSMSG	*RespQueueHead[MaxPe];
SYSMSG	*RespQueueTail[MaxPe];


QSInit()
{int Penum;

OsSpinInit(chareLock);
ChareQueueHead = NULLPTR;
ChareQueueTail = NULLPTR;
ChareQueueTop = 0;

for (Penum=0; Penum<MaxPe; Penum++) 
{
 OsSpinInit(respLock[Penum]);
 RespQueueHead[Penum] = NULLPTR;
 RespQueueTail[Penum] = NULLPTR;
 RespQueueTop[Penum] = 0;
 RespQueueLength[Penum] = 0;
 MaxQueueLength[Penum] = 0;
 }

}


QSEmptyResponses(Penum)
int Penum;
{
return(RespQueueHead[Penum] == NULLPTR);
}


QSEmptyChares()
{
return(ChareQueueHead == NULLPTR);
}


PickNextMsg(MsgType, CurrentAR,  CurrentMsg,  CurrentEP)
 int *CurrentAR,  *CurrentMsg,  *CurrentEP;
 JOBTYPE *MsgType;
     /* First check if there is any response for local chares
	(note: this assumes anchoring, and so avoid the need to lock chares)
	If empty, check the global pool of CreateChare messages */
{ QsLockResponses(MyPenum);
  if (QSEmptyResponses(MyPenum))
    {QsUnlockResponses(MyPenum);
     QsLockChares();
     if (QSEmptyChares()) {QsUnlockChares(); return(NULL); }
       else { QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP); 
	      QsUnlockChares(); }}
  else
    {QSDeQueueResponse(MyPenum,MsgType,CurrentAR,CurrentMsg,CurrentEP);
     QsUnlockResponses(MyPenum);}
return(1);
}



QSEnQueueChare(EP,Msg,MsgSize,AR)
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueChare:\n");
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, 0, SYSMSGTYPE_CHAR);

	QsLockChares();
	QmEnQueueChareMsg(mPtr);
	QsUnlockChares();
}


QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR)
{
	SYSMSG	*mPtr;
/*
TRACEQS(OsPrintf("QSEnQueueResponse:\n");
*/
	CREATE_SYS_MSG(mPtr, EP, Msg, AR, 0, SYSMSGTYPE_RESP);

	QsLockResponses(Penum);
	QmEnQueueRespMsg(mPtr, Penum);
	QsUnlockResponses(Penum);
}



QSEnQueueChareGen(EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	QSEnQueueChare(EP,Msg,MsgSize,AR);
}


QSEnQueueResponseGen(Penum,EP,Msg,MsgSize,AR,Prio,NeedToPack)
{
	QSEnQueueResponse(Penum,EP,Msg,MsgSize,AR);
}


QmEnQueueChareMsg(mPtr)
SYSMSG	*mPtr;
{
	ChareQueueTop++;

if (ChareQueueTop > MaxChares)
  {printf("Chare Queue Overflow. Need a Larger Queue Than %d\n",MaxChares);
   OsKillSys();
   exit(1);}
	
	if ( PrintQueStat == TRUE )
	{
		ChareQueueLength++;
		if ( ChareQueueLength > MaxChareQueueLength)
			MaxChareQueueLength = ChareQueueLength;
	}

	if ( ChareQueueHead == NULLPTR )
	{
		ChareQueueHead = mPtr;
		ChareQueueTail = mPtr;
	}
	else /* append message at the END of the queue for FIFO */
	{
		ChareQueueTail->sysMsgNextPtr = mPtr;
		ChareQueueTail = mPtr;
	}

/*OsPrintf("Enqueue chare by PE %d at %d\n", MyPenum, ChareQueueTop+1 );*/
}



QSDeQueueChare(MsgType,CurrentAR,CurrentMsg,CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueChareMsg();

	mPtr = QmDeQueueChareMsg();

	*MsgType    = JOBTYPE_CHARE;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}


SYSMSG	*QmDeQueueChareMsg()
{
	SYSMSG	*mPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) ChareQueueLength--;
	ChareQueueTop++;

	if ( ChareQueueHead != NULLPTR )
	{
		mPtr = ChareQueueHead;
		ChareQueueHead = ChareQueueHead->sysMsgNextPtr;
		mPtr->sysMsgNextPtr = NULLPTR;
	}

	if ( ChareQueueHead == NULLPTR )
		ChareQueueTail = NULLPTR;

	return( mPtr );

 /*OsPrintf("Dequeue chare at %d by PE %d\n", ChareQueueTop, MyPenum );*/
}


QmEnQueueRespMsg(mPtr, Penum)
SYSMSG	*mPtr;
int	Penum;
{
int j;
int	TotQueueLength = 0;

	RespQueueTop[Penum]++;

if (RespQueueTop[Penum] > MaxResps)
  {printf("Response Queue Overflow for PE %d, Need a Larger Queue Than %d\n",Penum, MaxResps);
   OsKillSys();
   exit(1);}
	
if ( PrintQueStat == TRUE )
{
RespQueueLength[Penum]++;
for (j=0; j<numPe; j++) 
 TotQueueLength += RespQueueLength[j];

 TotQueueLength += ChareQueueLength;
if( TotQueueLength > MaxQueueLength[Penum] )
	MaxQueueLength[Penum] = TotQueueLength;
}
	if ( RespQueueHead[Penum] == NULLPTR )
	{
		RespQueueHead[Penum] = mPtr;
		RespQueueTail[Penum] = mPtr;
	}
	else /* append message at the END of the queue for FIFO */
	{
		RespQueueTail[Penum]->sysMsgNextPtr = mPtr;
		RespQueueTail[Penum] = mPtr;
	}

/*OsPrintf("enqueue response for %d by %d\n", Penum, MyPenum);*/
}


QSDeQueueResponse(Penum, MsgType, CurrentAR, CurrentMsg, CurrentEP)
int *CurrentAR, *CurrentMsg, *CurrentEP;
int Penum;
JOBTYPE *MsgType;
{
	SYSMSG	*mPtr, *QmDeQueueRespMsg();

	mPtr = QmDeQueueRespMsg(Penum);

	*MsgType    = JOBTYPE_RESP;
 	*CurrentAR  = mPtr->AR;
 	*CurrentMsg = mPtr->Msg;
 	*CurrentEP  = mPtr->EP;

	Free_SysMsg(mPtr, sizeof(SYSMSG));
}

SYSMSG	*QmDeQueueRespMsg(Penum)
int	Penum;
{
	SYSMSG	*mPtr = NULLPTR;

	if ( PrintQueStat == TRUE ) RespQueueLength[Penum]--;
	RespQueueTop[Penum]--;

	if ( RespQueueHead[Penum] != NULLPTR )
	{
		mPtr = RespQueueHead[Penum];
		RespQueueHead[Penum] = RespQueueHead[Penum]->sysMsgNextPtr;
		mPtr->sysMsgNextPtr = NULLPTR;
	}

	if ( RespQueueHead[Penum] == NULLPTR )
		RespQueueTail[Penum] = NULLPTR;

	return( mPtr );

/*OsPrintf("deque response for %d by %d\n", Penum, MyPenum);*/
}


QsLockChares()
{
    OsSpinLock( chareLock );
}


QsUnlockChares()
{
    OsSpinUnlock( chareLock );
}


QsLockResponses(Penum)
int Penum;
{
    OsSpinLock( respLock[Penum] );
}


QsUnlockResponses(Penum)
int Penum;
{
    OsSpinUnlock( respLock[Penum] );
}


QueueStatus()
{
	int i, max_queue_length = 0;

    if ( PrintQueStat == TRUE )
    {
	for ( i=0; i<numPe; i++)
		if ( MaxQueueLength[i] > max_queue_length )
			max_queue_length = MaxQueueLength[i];

	OsPrintf("Queue Status: MaxQueueLength %d\n", max_queue_length);
    }
}
