#include "host.h"
#include "cksys.h"
#define PENUMOF(chareid) (((struct chare_header *)(((char *)chareid)-sizeof(struct chare_header)))->rootpe)
#define CHAREID_TO_HEADER(id) (((struct chare_header *)id)-1)
#define HEADER_TO_CHAREID(id) (((struct chare_header *)id)+1)

/* chare_header is prepended to the chare data area.  it contains 
 * bookkeeping data for internal use by chare kernel routines.
 * sizeof(chare_header) MUST be a multiple of sizeof(int).
 */
struct chare_header {
	int rootpe;    /* pe the chare was created on */
};

shared char *CurrentARTab[MaxPe];
shared int SysDone = 0;
int PrintChareStat = 0;
shared int CharesProcessed[MaxPe];
shared int CharesCreated[MaxPe];
shared int RespsProcessed[MaxPe];
shared int RespsCreated[MaxPe];


/*---------------------------------------------------------------------- loop */

loop(Penum)
int Penum;
{
	/* main chare kernel loop.
	 * read a message and process it, until SysDone.
	 */
	struct chare_header *chare;
	int CurrentAR, CurrentMsg, CurrentEP;
	JOBTYPE t;
	extern shared int numPe;
	extern shared int ElapsedTimes[];
	extern shared int Trash;

 	if (Penum >= numPe) return;   /* Alliant idiosyncracy */
	OsPrintf("PE %d active\n", MyPenum);
	OsTimer(TIMER_INIT);

 	while (!SysDone) {
		do
			if (Trash) GarbageMan();
		while (!PickNextMsg(&t,&CurrentAR,&CurrentMsg,&CurrentEP)&&(!SysDone));
	   if(SysDone)
			break;
		if( t == JOBTYPE_CHARE ) {
			chare = (struct chare_header *)
				OsAlloc( CurrentAR + sizeof(struct chare_header) );
			if (((int)chare) < 10) OsPrintf("ck: chare allocation error\n");
			chare->rootpe = MyPenum;
			CurrentAR = (int)HEADER_TO_CHAREID( chare );
			CharesProcessed[MyPenum]++;
		}
		else /* for a response */
			RespsProcessed[MyPenum]++;

	   CurrentARTab[MyPenum] = (char *)CurrentAR;
/*OsPrintf("from pe %d addr %d\n", PENUMOF(CurrentAR), CurrentAR );*/
	   UsrPrg(CurrentEP,CurrentMsg,CurrentAR);
	   /* ChareID has two fields PENum, and index into "memory" where its
	    * data-area begins. The macro extracts the pointer to this data area
		 */
	 }
	ElapsedTimes[MyPenum] = OsTimer(TIMER_READ);
	/* OsPrintf("out of loop. Penum: %d\n", Penum); */
}

/*-------------------------------------------------------------- CreateChare */

CreateChare(EP,Msg,MsgSize,ChareSize)
int EP; int * Msg; int ChareSize, MsgSize;
{
	/* get memory as an index of less than 24 bits.  this is used in
	 * forming the chare id along with the processor number
	 */
	/*OsPrintf("CreateChare(myPE %d,DataSize %d)\n", MyPenum, ChareSize );*/
	CharesCreated[MyPenum]++;
	QSEnQueueChare( EP, Msg, MsgSize, ChareSize );
}


CreateChareGen(EP,Msg,MsgSize,ChareSize,prio,needtopack)
int EP; int * Msg; int ChareSize, MsgSize, prio, needtopack;
{
	CharesCreated[MyPenum]++;
	QSEnQueueChareGen( EP, Msg, MsgSize, ChareSize, prio, needtopack );
}

/*-------------------------------------------------------------- SendMsg */

SendMsg(EP,Msg,MsgSize,ChareID)
int EP; int * Msg;
int MsgSize;
ChareIDType *ChareID;  /* contains penum and AR of chare */
{
	/* send message to a chare entry point
	 */
 	/*OsPrintf("SendMsg(destPe %d,pointerAR %d)\n",ChareID->rootpe,ChareID->dataarea );*/
	RespsCreated[MyPenum]++;
 	QSEnQueueResponse(ChareID->rootpe,EP,Msg,MsgSize,ChareID->dataarea);
}


SendMsgGen(EP,Msg,MsgSize,ChareID,prio,needtopack)
int EP;
int* Msg;
int MsgSize;
ChareIDType *ChareID;  /* contains penum and AR of chare */
int prio, needtopack;
{
	RespsCreated[MyPenum]++;
	QSEnQueueResponseGen( ChareID->rootpe, EP, Msg, MsgSize, ChareID->dataarea, prio, needtopack );
}

MyChareID(id)
ChareIDType *id;
{
	id->dataarea = CurrentARTab[MyPenum];
	id->rootpe = PENUMOF(id->dataarea);
	/*OsPrintf("GetChareID returning (%d,%d)\n", id->rootpe, id->dataarea);*/
}

OsCopyChareID(ptr1, ptr2)
ChareIDType *ptr1, *ptr2;
{
  *ptr1 = *ptr2;
}

OsKillMyself()
{
	OsFree( ((struct chare_header *)(CurrentARTab[MyPenum])) - 1 );
	/*MemFree( DATAAREA(CurrentARTab[MyPenum]) );*/
}

OsKillSys()
{
	OsPrintf("----- System killed -----\n");
	SysDone = 1;
}


ChareStatInit()
{
	int Penum;

	for (Penum=0; Penum<MaxPe; Penum++) 
	{
		CharesProcessed[Penum] = 0;
		CharesCreated[Penum] = 0;
		RespsProcessed[Penum] = 0;
		RespsCreated[Penum] = 0;
	}
}


ChareStatus()
{
	int i;
	int chares_processed = 0;
	int resps_processed = 0;
	int chares_created = 0;
	int resps_created = 0;

   if ( PrintChareStat == TRUE )
   {
	for ( i=0; i<numPe; i++)
	{
		chares_processed += CharesProcessed[i];
		chares_created += CharesCreated[i];
		resps_processed += RespsProcessed[i];
		resps_created += RespsCreated[i];
	}

	OsPrintf("Chare Statistics:\n");
	OsPrintf("PE[CharesProcessed]: ");
	OsPrintf("Total=%d\t", chares_processed);
	for ( i=0; i<numPe; i++)
		OsPrintf("%d[%d], ", i, CharesProcessed[i]);
	OsPrintf("\n");

	OsPrintf("PE[CharesCreated]: ");
	OsPrintf("Total=%d\t", chares_created);
	for ( i=0; i<numPe; i++)
		OsPrintf("%d[%d], ", i, CharesCreated[i]);
	OsPrintf("\n");

	OsPrintf("Response Statistics:\n");
	OsPrintf("PE[ResponsesProcessed]: ");
	OsPrintf("Total=%d\t", resps_processed);
	for ( i=0; i<numPe; i++)
		OsPrintf("%d[%d], ", i, RespsProcessed[i]);
	OsPrintf("\n");

	OsPrintf("PE[ResponsesCreated]: ");
	OsPrintf("Total=%d\t", resps_created);
	for ( i=0; i<numPe; i++)
		OsPrintf("%d[%d], ", i, RespsCreated[i]);
	OsPrintf("\n");
   }
}
