#include "cksys.h"
#include "machine.h"

#define QUIET
#define HASH

typedef int USRMSG;
typedef int (*FUN)();

/* contract strategy */
#define	CSCONTRACT1	1
#define CSGRANDDIFF	3
#define CSCONTRACTX	2
#define CSCONTRACTN	4
#define STAT_IDLE	0
#define STAT_NEUTRAL	1
#define STAT_ABUNDANT	2

typedef struct str_queue {
    struct sysmsg_str	*head;
    struct sysmsg_str	*tail;
#ifdef SHAREDMEM
    LOCK	*qLock;
#endif
    int		qLen;
    int		maxLen;
} QUEUE;

/* input parameter packet */
typedef struct str_ip {
    int	 dummy;
    int	 CS; /* Contract strategy types: CSCONTRACT1, CSGRANDDIFF CSCONTRACTX */
    int  CSmaxDist,CSminDist,CSredistrKey,CSredistrMark;
    int  CSsaturateKey,CSsaturateHighMark,CSsaturateLowMark;
    int  CSloadMark, CSloadMark2, CSloadMark3;
    int	 CShighMark, CSlowMark; /* high and low watermark for CSGRANDDIFF */
    int	 CSinterval; /* high and low watermark for CSGRANDDIFF */
    int  neighborDist, LDchare, LDcMsg, LDdMsg;
    int  ringLen; /* 0 for sync send, x for asyn send with ring */
    int	 TOPOtype; /* topology types */
    int	 PEnum, BUSnum, PEconnection,MAXm,BUSwidth;
    int	 NetDiameter;
    int	 SamplePeriod;
    int	 startTime, busTime; 	/*ProtocolTime,SizeMsg;*/
    int	 TraceOn,Out1,Out3; 
    int	 QMbufs,QMchareData,QMfifo;
    int	 QMchareQ,QMdataQ;
    int	 COproc;
} INPARAM;

/* output parameter packet */
typedef struct str_op {
    int		hopsTaken[MAXHOPS+1];
    int		chareNum;
    int		dataNum;
    int		respDoneNum;
    int		respClauseNum;
    int		hopsNum;
} OUTPARAM;

typedef struct str_usr1 {
    int		*head;
    int		*tail;
    int		qLen;
    int		maxLen;
} USRQUEUE;

/*
typedef struct str_usr2 {
    int		isLogic;
    int	       	remotePE;
    int		remoteCH;
    USRQUEUE	pendingMsg;
} CHAREID;
*/

#ifdef HASH
#define MAXENTRY 100
typedef struct str_hash {
    int		hashNum;
    int		sharedNext;
    ChareIDType	sharedID[MAXENTRY];
    QUEUE	resultQ;
    } HASHBLK;
#endif
typedef struct chare_str {
    struct chare_str *leftP,*rightP;
    int		chareStat;
    ChareIDType self;
    ChareIDType parent;
/*
    int		parentPe; 	
    int		parentCh; 	
*/
    int		cdataSize; 	
/* special for SIM */
#ifdef ORACLESIM
    int		sysData[MAXHOPS+1];
#endif
#ifdef SHAREDMEM
    LOCK	*chareLock;
    QUEUE	pendingRsp;
#endif
#ifdef HASH
    HASHBLK	*hPtr;
#endif
    int		logicID;
    USRQUEUE	pendingMsg;
    int		*cdataPtr;
} CHAREBLK;

#define CHAREIDPE(p)	p->pe
#define CHAREIDCH(p)	p->ch

#define CHARELPTR(p)	p->leftP
#define CHARERPTR(p)	p->rightP
#define CHARESTAT(p)	p->chareStat
/*
#define CHAREPAPE(p)	p->parentPe
#define CHAREPACH(p)	p->parentCh
*/
#define CHARESID(p)	&p->self
#define CHAREPID(p)	&p->parent
#define CHARERID(p)	&p->parent
#define CHAREPAPE(p)	p->parent.pe
#define CHAREPACH(p)	p->parent.ch
#define CHARECDSIZE(p)	p->cdataSize
#define CHARECDPTR(p)	p->cdataPtr
#define CHARELOGICID(p)	p->logicID
#ifdef ORACLESIM
#define CHARESYSDATA(p,k) p->sysData[k]
#endif
#ifdef SHAREDMEM
#define CHARELOCK(p)	p->chareLock
#endif

#define CHARETYPE_IDLE	0
#define CHARETYPE_KILL	CHARETYPE_IDLE+1
#define CHARETYPE_LOCK	CHARETYPE_KILL+1
#define CHARETYPE_VIR0	CHARETYPE_LOCK+1
#define CHARETYPE_VIR1	CHARETYPE_VIR0+1

#define ISPHYSICAL(p)	(CHARESTAT(p) < CHARETYPE_VIR0)
#define ISVIRTUAL(p)	(CHARESTAT(p) >= CHARETYPE_VIR0)

typedef struct sysmsg_str {
    struct sysmsg_str *sysMsgNextPtr;
    int		sysMsgType;
    int		sysMsgSize;
    int		sysMsgSrcPe;	/* */
    CHAREBLK	*sysMsgSrcCh;	/* */
    int		sysMsgDestPe;	/* */
    CHAREBLK	*sysMsgDestCh;	/* */
    int		sysMsgLastPe;	/* the last pe on the path */
    int		sysMsgNextPe;	/* the last pe on the path */
    int		sysMsgLoad;	/* carry the load information of last pe */
    int		sysMsgIsPacked;	
    int		sysMsgNeedPack;	
    USRMSG*	sysMsgUsrPtr;	
    int		sysMsgUsrCode;	
    int		sysMsgUsrSize;	
    int		sysMsgUsrPrio;	
    int		sysMsgHops;	
    int		sysMsgUsrCDsize;
    CHAREBLK	*sysMsgVirtualBlk;
/* special for SIM */
#ifdef ORACLESIM
    int		sysMsgPath[MAXHOPS+1]; 
#endif
} SYSMSG;

#define SIZEOFSYSMSG	sizeof(MSG)

#define SYSMSGTYPE(p)	p->sysMsgType
#define SYSMSGSIZE(p)	p->sysMsgSize
#define SYSMSGSRCPE(p)	p->sysMsgSrcPe
#define SYSMSGSRCCH(p)	p->sysMsgSrcCh
#define SYSMSGDESTPE(p)	p->sysMsgDestPe
#define SYSMSGDESTCH(p) p->sysMsgDestCh	
#define SYSMSGLASTPE(p)	p->sysMsgLastPe
#define SYSMSGNEXTPE(p)	p->sysMsgNextPe
#define SYSMSGLOAD(p)	p->sysMsgLoad
#define SYSMSGISPACK(p)	p->sysMsgIsPacked
#define SYSMSGNEEDPACK(p)	p->sysMsgNeedPack
#define SYSMSGUPTR(p)	p->sysMsgUsrPtr
#define SYSMSGUCODE(p)	p->sysMsgUsrCode
#define SYSMSGUSIZE(p)	p->sysMsgUsrSize
#define SYSMSGUPRIO(p)	p->sysMsgUsrPrio
#define SYSMSGUCDS(p)	p->sysMsgUsrCDsize
#define SYSMSGVIRTUALBLK(p)	p->sysMsgVirtualBlk
#define SYSMSGHOPS(p)	p->sysMsgHops
#define SYSMSGNEXTPTR(p)   p->sysMsgNextPtr
#ifdef ORACLESIM
#define SYSMSGPATH(p,k) p->sysMsgPath[k]
#endif

#define MSGTYPE_GOAL	SYSMSGTYPE_CHAR
#define MSGTYPE_RESP	SYSMSGTYPE_DATA
#define MSGTYPE_RESPDONE MSGTYPE_OTHER
#define MSGTYPE_RESPRNUM MSGTYPE_OTHER
#define MSGTYPE_RESPCNUM MSGTYPE_OTHER

#define SYSMSGTYPE_NULL	0		   /* dummy type, used when init    */
#define SYSMSGTYPE_CHAR	SYSMSGTYPE_NULL+1  /* chare message		    */
#define SYSMSGTYPE_DATA	SYSMSGTYPE_CHAR+1  /* data message		    */
#define SYSMSGTYPE_ROUT	SYSMSGTYPE_DATA+1  /* routing message		    */
#define SYSMSGTYPE_STAT	SYSMSGTYPE_ROUT+1  /* control message		    */
#define SYSMSGTYPE_INIT	SYSMSGTYPE_STAT+1
#define SYSMSGTYPE_CTRA	SYSMSGTYPE_INIT+1  /* contract message		    */
#define SYSMSGTYPE_KILL	SYSMSGTYPE_CTRA+1  /* contract message		    */
#define SYSMSGTYPE_BEGN	SYSMSGTYPE_KILL+1  /* contract message		    */
#define SYSMSGTYPE_RVAR	SYSMSGTYPE_BEGN+1  /* contract message		    */
#define SYSMSGTYPE_BVAR	SYSMSGTYPE_RVAR+1  /* contract message		    */
#define SYSMSGTYPE_PECH	SYSMSGTYPE_BVAR+1  /* contract message		    */
#define SYSMSGTYPE_TERM	SYSMSGTYPE_PECH+1  /* contract message		    */
#define SYSMSGTYPE_GOUP	SYSMSGTYPE_TERM+1  /* contract message		    */
#define SYSMSGTYPE_UP2T	SYSMSGTYPE_GOUP+1  /* contract message		    */
#define SYSMSGTYPE_REDU	SYSMSGTYPE_UP2T+1  /* contract message		    */
#define SYSMSGTYPE_HASH	SYSMSGTYPE_REDU+1  /* contract message		    */
#define SYSMSGTYPE_OTHER SYSMSGTYPE_HASH+1 /* contract message		    */

typedef struct str_pccell {
    int		cellPE;	/* */
    CHAREBLK	*cellCH;	/* */
} PECHCELL;


#define MAXSENDRINGLEN	30
typedef struct str_pe {
    /* pending outgoing message */
    int		asynSendID[MAXSENDRINGLEN];	/* to keep msg ID sending out */
    SYSMSG	*asynSendBptr[MAXSENDRINGLEN];	/* to keep buff ptr */
    int		asynSendIndx;			/* circular list index  */
    /* current chare and pe */
    int		state;
    int		isHost;
    long 	initClk;
    long 	*pClk;
    CHAREBLK	*myChareBlk;
    BOOLEAN  	suspendFlag;
    QUEUE	inChareQ,inDataQ,inRoutQ,inCntlQ;
    QUEUE	allChareQ, waitQ, spreadQ;
    int	 	procID;
    /* topo information */
    int	 	busONpe[MAXCON];
    int		neighbors[MAXCON];
    int		neighborNum;
    int		lab;	/* topo use */
    /* load balancing */
    int		loadAry[MAXPE];	
    int		statOutAry[MAXPE];	/* to keep inf for pickgyback */
    int		satu;
    int		dist;
    int		diffCount;
    int		diffCount2;
    int		oldLoad;
    int		newLoad;
    int		nextPE;
    /* statistic gathering */
    int		currentChare;
    int		chareNumGenerated;
    int		dataNumGenerated;
    int		chareNumConsumed;
    int		dataNumConsumed;
    int		chareNumRemote;
    int		routNum;
    int		contNum;
    int		loadNum;
    int  	suspendNum;
    float	suspendTime;
    int		upNode;
#ifdef QUIET
    int		downNum;
    int		reductNum;
    SYSMSG	msgTerm;
    int		everBusy;
    int		everUp;
#endif
#ifdef TERMINATION
    int		diffCount3;
    int		downNum;
    int		reductNum;
    SYSMSG	msgTerm;
    int		everBusy;
#endif
#ifdef HASH
    int		hNext;
    HASHBLK	hBlk[MAXENTRY];
#endif
} PEINFORM;

typedef struct b_str {
    int		bNum;
    int		*bPtr[4];
    FUN		bFun[4];
} BTBL;

typedef struct str_bus {
    int	 	procID;
    int	 	peONbus[MAXWID];
    int		residual;
    BOOLEAN 	suspendFlag;
    QUEUE	outQ;
} BUSINFORM;

