#include "chare.h"
#include "machine.h"
#include "extern.h"

#define MSGPASSING

CoMsgWait(peNum,cNum,dNum)
int peNum,cNum,dNum;
{   /* wait untill either chare msg or data msg is ready */
    do {
#ifndef SHAREDMEM
        CoMsgNoWait(peNum);	/* process all pending messages */
	if (PE(peNum).isHost == FALSE) McProcStat(peNum);	
		/* do periodic work for ldb	*/
#endif
        if (PE(cNum).inChareQ.head == NULLPTR
    	      && PE(dNum).inDataQ.head == NULLPTR 
              && PE(peNum).inRoutQ.head == NULLPTR) 
	    McSuspendPe(peNum); 	
	} while (PE(cNum).inChareQ.head == NULLPTR 
		&& PE(dNum).inDataQ.head == NULLPTR);
}

CoMsgNoWait(peNum)
int peNum;
{   /* move pending msg to queue, and process other msg */
    SYSMSG *mPtr,*newPtr,*McGetPendingMsg();
    CHAREBLK   *vPtr;

    while ((mPtr = McGetPendingMsg(peNum)) != NULL)  { 
	if (SYSMSGLOAD(mPtr) >= 0) {
	    McUpdateStat(peNum,SYSMSGLASTPE(mPtr),SYSMSGLOAD(mPtr));
	    }
    	switch (SYSMSGTYPE(mPtr)) {
	  case SYSMSGTYPE_CHAR: 
	  case SYSMSGTYPE_DATA: 
#ifdef HASH
	  case SYSMSGTYPE_HASH: 
#endif
		QmPutLocalMsg(mPtr,peNum);
		break;
  	  case SYSMSGTYPE_CTRA:
    		LdbContractMid(peNum,mPtr);	 
		break;
  	  case SYSMSGTYPE_ROUT:
 		LdbRoutMsg(peNum,mPtr);	 
	 	break;
  	  case SYSMSGTYPE_PECH:
		vPtr = SYSMSGVIRTUALBLK(mPtr);
		CHAREIDPE((CHARERID(vPtr))) = SYSMSGSRCPE(mPtr);
		CHAREIDCH((CHARERID(vPtr))) = (int) SYSMSGSRCCH(mPtr);
		while (vPtr->pendingMsg.head != NULLPTR) {
		    newPtr = (SYSMSG*)QmDeQueue(&vPtr->pendingMsg);
		    SYSMSGDESTPE(newPtr)=SYSMSGNEXTPE(newPtr)=SYSMSGSRCPE(mPtr);
		    SYSMSGDESTCH(newPtr)=SYSMSGSRCCH(mPtr);
		    McSendMsg(newPtr,peNum);
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_BVAR:
		McProcBvar((char*)mPtr+sizeof(SYSMSG),peNum);
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_KILL:
#ifdef TERMINATION
		if (PE(peNum).isHost == TRUE)
  		    PE(peNum).everBusy = DUMMY;
		else
#endif
#ifdef QUIET
		if (PE(peNum).isHost == TRUE)
  		    PE(peNum).everBusy = DUMMY;
		else
#endif
		    McSysFinal(peNum);
		break;
#ifdef QUIET
  	  case SYSMSGTYPE_REDU:
		if (peNum == 0) {
    		    PE(0).reductNum--;
    		    if ( *((int*) ((char*)mPtr + sizeof(SYSMSG))) == TRUE)
    			PE(peNum).everBusy = TRUE; 
    		    if (PE(0).reductNum <= 0) {
			if (PE(0).everBusy != TRUE 
        			&& PE(0).inChareQ.head == NULLPTR
        			&& PE(0).waitQ.head == NULLPTR
    	      			&& PE(0).inDataQ.head == NULLPTR ) {
			    printf("\nSystem Terminated at time %d\n",
					OsGetSysClk(0));
			    OsKillSys();
			    }
			else {
	    		    PE(0).reductNum = PE(0).downNum;
			    PE(0).everUp = SYSMSGTYPE_GOUP;
	    		    }
			}
		    }
  		else {
    		    PE(peNum).reductNum--;
    		    if ( *((int*) ((char*)mPtr + sizeof(SYSMSG))) == TRUE)
    			PE(peNum).everBusy = TRUE; 
    		    if (PE(peNum).reductNum <= 0) {
        		if (PE(peNum).inChareQ.head != NULLPTR
				|| PE(peNum).waitQ.head != NULLPTR
    	      			|| PE(peNum).inDataQ.head != NULLPTR ) 
			    PE(peNum).everBusy = TRUE;
			SYSMSGTYPE((&PE(peNum).msgTerm)) = SYSMSGTYPE_REDU;
			McSysSend(&PE(peNum).msgTerm,peNum);
        		PE(peNum).everUp = FALSE;
    		        PE(peNum).reductNum = PE(peNum).downNum;
			}
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_GOUP:
		if (PE(peNum).downNum == 0) {
    		    PE(peNum).everUp = TRUE;
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_UP2T:
		if (PE(peNum).downNum == 0) {
        	    if (PE(peNum).inChareQ.head != NULLPTR
				|| PE(peNum).waitQ.head != NULLPTR
    	      			|| PE(peNum).inDataQ.head != NULLPTR ) 
			PE(peNum).everBusy = TRUE;
		    SYSMSGTYPE((&PE(peNum).msgTerm)) = SYSMSGTYPE_REDU;
		    McSysSend(&PE(peNum).msgTerm,peNum);
    		    PE(peNum).reductNum = PE(peNum).downNum;
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_TERM:
    		PE(peNum).reductNum--;
    		if (PE(peNum).reductNum <= 0) {
		    if (peNum == 0) {
			PE(0).everUp = SYSMSGTYPE_UP2T;
			}
		    else
    		        PE(peNum).everUp = TRUE;
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
#endif
#ifdef TERMINATION
  	  case SYSMSGTYPE_REDU:
		if (peNum == 0) {
    		    PE(0).reductNum--;
    		    if ( *((int*) ((char*)mPtr + sizeof(SYSMSG))) == TRUE)
    			PE(0).everBusy = TRUE; 
/**printf("PE 0 get one REDU, left %d busy %d msgLen %d at %d\n",
	PE(0).reductNum,PE(0).everBusy,
	SYSMSGSIZE(mPtr),OsGetSysClk());**/
    		    if ( PE(0).reductNum <= 0
			    && PE(0).everBusy != TRUE 
        			&& PE(0).inChareQ.head == NULLPTR
        			&& PE(0).waitQ.head == NULLPTR
    	      			&& PE(0).inDataQ.head == NULLPTR ) {
			printf("\nSystem Terminated at time %d\n",
					OsGetSysClk(0));
			OsKillSys();
			}
		    }
  		else {
    		    PE(peNum).reductNum--;
    		    if ( *((int*) ((char*)mPtr + sizeof(SYSMSG))) == TRUE)
    			PE(peNum).everBusy = TRUE; 
/**printf("PE %d get one REDU, left %d busy %d at %d\n",peNum,
	PE(peNum).reductNum,PE(peNum).everBusy,OsGetSysClk(peNum));**/
    		    if (PE(peNum).reductNum <= 0) {
        		if (PE(peNum).inChareQ.head != NULLPTR
				|| PE(peNum).waitQ.head != NULLPTR
    	      			|| PE(peNum).inDataQ.head != NULLPTR ) 
			    PE(peNum).everBusy = TRUE;
			McSysSend(&PE(peNum).msgTerm,peNum);
        		PE(peNum).everBusy = FALSE;
    		        PE(peNum).reductNum = PE(peNum).downNum;
			}
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
  	  case SYSMSGTYPE_TERM:
		if (PE(peNum).downNum == 0) {
/**printf("PE %d get one TERM, left %d busy %d msgLen %d at %d\n",peNum,
	PE(peNum).reductNum,PE(peNum).everBusy,
	SYSMSGSIZE((&PE(peNum).msgTerm)),OsGetSysClk(peNum));**/
        	    if (PE(peNum).inChareQ.head != NULLPTR
			|| PE(peNum).waitQ.head != NULLPTR
    	      		|| PE(peNum).inDataQ.head != NULLPTR ) 
			PE(peNum).everBusy = TRUE;
    		    McSysSend(&PE(peNum).msgTerm,peNum);
    		    PE(peNum).everBusy = FALSE;
		    }
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
#endif
  	  default:
		PE(peNum).loadNum++;
		OsFree(mPtr,SYSMSGSIZE(mPtr));
		break;
	}
	}
}

CoGranDiff(peNum)
int	peNum;
{
    int t,k;

    k = McGetSysClk()/ip.CSinterval;
    if (k > PE(peNum).diffCount) {
	PE(peNum).diffCount = k;
	LdbDiffProc(peNum);
	}
}

CoReDistr(peNum)
int	peNum;
{
    int t,k;

    t = McGetSysClk(peNum);
    k = t/ip.CSinterval;
    if (k > PE(peNum).diffCount) {
	PE(peNum).diffCount = k;
	LdbReDistr(peNum);
	}
}

