#include "chare.h"
#include "machine.h"
#include "extern.h"

SYSMSG *QmGetUsrMsg(peNum)
int	peNum;
{
    SYSMSG	*mPtr,*QmDeQueue();
    int 	cNum,dNum,k;

    cNum = (ip.QMchareQ) ? peNum : 0;
    dNum = (ip.QMdataQ) ? peNum : 0;
    CoMsgWait(peNum);

    co_time_off(k); /* charge 'RemoveF' time if cope is 0 or 1 */
    /* pick up the message according to the buf contrl strategy */
    switch (ip.QMchareData) {
      case 1: /* chare/data */
        if (PE(cNum).inChareQ.head != NULLPTR)
            mPtr = QmDeQueue(&PE(cNum).inChareQ);
        else 
            mPtr = QmDeQueue(&PE(dNum).inDataQ);
        break;
      case 0: /* data/chare */
        if (PE(dNum).inDataQ.head != NULLPTR)
            mPtr = QmDeQueue(&PE(dNum).inDataQ);
        else 
            mPtr = QmDeQueue(&PE(cNum).inChareQ);
	break;
      case 2: /* mixed */
        mPtr = QmDeQueue(&PE(cNum).inChareQ);
	break;
        }
    co_time_on(k); 
    return(mPtr);
}

SYSMSG *QmGetGoalMsg(peNum) 
int	peNum;
{
   SYSMSG	*mPtr=NULLPTR, *QmDeQueue();
   int	k;

    /* work to the current time */
    WorkPe(peNum,0);

    co_time_off(k);
    /* check each buffer, if no msg, return NULLPTR */
    if (PE(peNum).inChareQ.head != NULLPTR) 
	mPtr = QmDeQueue(&PE(peNum).inChareQ);
    co_time_on(k);
    return(mPtr);
}

/* this one is called when the msg arrive pe from bus, how about clock!!!*/
/* restore time clock in bus process */

QmPutPeMsg(mPtr,busNum,peNum)
SYSMSG	*mPtr;
int	peNum,busNum;
{
    int cNum,dNum,k;


    clock_off();
    time_record(k);
    cNum = (ip.QMchareQ) ? peNum : 0;
    dNum = (ip.QMdataQ) ? peNum : 0;
    switch (SYSMSGTYPE(mPtr)) {
      case SYSMSGTYPE_CHAR: 
	QmEnQueue(mPtr,&PE(cNum).inChareQ);
	break;
      case SYSMSGTYPE_DATA: 
	if (ip.QMchareData == 2) /* mixed mode */
	    QmEnQueue(mPtr,&PE(dNum).inChareQ);
	else 
	    QmEnQueue(mPtr,&PE(dNum).inDataQ);
	break;
      default: 
	QmEnQueue(mPtr,&PE(peNum).inRoutQ);
	break;
	}

    if (PE(peNum).suspendFlag == TRUE) 
	McResumePe(peNum);

    time_restore(k);
    clock_on();
}

QmPutLocalMsg(mPtr,peNum)
SYSMSG	*mPtr;
int	peNum;
{
    clock_off();
    /* work to the current time */
    WorkPe(peNum,0);
    co_time_off(k); /* charge time for 'Insert' if cope is 0 or 1 */
    switch (SYSMSGTYPE(mPtr)) {
      case SYSMSGTYPE_CHAR: 
	QmEnQueue(mPtr,&PE(peNum).inChareQ);
	break;
      case SYSMSGTYPE_DATA: 
	if (ip.QMchareData == 2) /* mixed mode */
	    QmEnQueue(mPtr,&PE(peNum).inChareQ);
	else 
	    QmEnQueue(mPtr,&PE(peNum).inDataQ);
	break;
      default: 
	QmEnQueue(mPtr,&PE(peNum).inRoutQ);
	break;
	}
    clock_on();
    co_time_on(k);
}

QmEnQueue(mPtr,qPtr)
SYSMSG	*mPtr;
QUEUE	*qPtr;
{
#ifdef SHAREDMEM
    McLockQ(qPtr);
#endif
    if(ip.QMfifo) { /* FIFO */
    	if (qPtr->head == NULLPTR) 
	    qPtr->head = qPtr->tail = mPtr;
        else {
	    SYSMSGNEXTPTR(qPtr->tail) = mPtr;
	    qPtr->tail = mPtr;
	    }
	}
    else { /* LIFO */
    	if (qPtr->head == NULLPTR) 
	    qPtr->head = qPtr->tail = mPtr;
        else {
	    SYSMSGNEXTPTR(mPtr) = qPtr->head;
	    qPtr->head = mPtr;
	    }
	}
    qPtr->qLen++;
    if (qPtr->qLen > qPtr->maxLen)
	qPtr->maxLen = qPtr->qLen;
#ifdef SHAREDMEM
    McUnlockQ(qPtr);
#endif
}

SYSMSG *QmDeQueue(qPtr)
QUEUE	*qPtr;
{
    SYSMSG	*ptrM;

#ifdef SHAREDMEM
    McLockQ(qPtr);
#endif
    ptrM = qPtr->head;
    if (qPtr->head != NULLPTR) {
	if (SYSMSGNEXTPTR(qPtr->head) == NULLPTR)
	    qPtr->tail = NULLPTR;
	qPtr->head = SYSMSGNEXTPTR(qPtr->head);
	SYSMSGNEXTPTR(ptrM) = NULLPTR;
	qPtr->qLen--;
	}
#ifdef SHAREDMEM
    McUnlockQ(qPtr);
#endif
    return(ptrM);
}

/* these two routines meust be at the end of file, pay attention to clock */

SYSMSG *RemoveF(q)
QUEUE	*q;
{
    SYSMSG	*ptrM;

    ptrM = q->head;
    if (q->head != NULLPTR) {
	if (SYSMSGNEXTPTR(q->head) == NULLPTR)
	    q->tail = NULLPTR;
	q->head = SYSMSGNEXTPTR(q->head);
	SYSMSGNEXTPTR(ptrM) = NULLPTR;
	q->qLen--;
	}
    return(ptrM);
}


InsertL(q,ptrM)
QUEUE	*q;
SYSMSG	*ptrM;
{
    if (q->head == NULLPTR) 
	q->head = q->tail = ptrM;
    else {
	SYSMSGNEXTPTR(q->tail) = ptrM;
	q->tail = ptrM;
	}
    q->qLen++;
    if (q->qLen > q->maxLen)
	q->maxLen = q->qLen;
}

InsertF(q,ptrM)
QUEUE	*q;
SYSMSG	*ptrM;
{
    if (q->head == NULLPTR) 
	q->head = q->tail = ptrM;
    else {
	SYSMSGNEXTPTR(ptrM) = q->head;
	q->head = ptrM;
	}
    q->qLen++;
}
