#include "chare.h"
#include "machine.h"
#include "extern.h"

/*#define ROUTE */

LdbNewChare(mPtr)
SYSMSG 	*mPtr;
{
    int		peNum = SYSMSGSRCPE(mPtr);

    switch(ip.CS) {
      case CSCONTRACT1:	/* contract at one random distance */ 
	LdbContractRandom(peNum,mPtr); 	
        break;	
      case CSCONTRACTX:	/* contract at X distance */ 
      case CSCONTRACTN:	/* contract at navie distance */ 
	LdbContractX(peNum,mPtr);
        break;
      case CSGRANDDIFF:	/* diffusion gradient */ 
	LdbGrandDiff(peNum,mPtr);
        break;
      default:
	break;
      }
}

LdbGrandDiff(peNum,mPtr)
int	peNum;
SYSMSG	*mPtr;
{
    int		k;

    SYSMSGDESTPE(mPtr) = SYSMSGNEXTPE(mPtr) = peNum;
#ifdef ORACLESIM
    SYSMSGPATH(mPtr,1) = peNum;
#endif
    QmPutLocalMsg(mPtr,peNum);
}

LdbContractRandom(peNum,mPtr) 
int	peNum;
SYSMSG	*mPtr;
{
    int	 i,k,destn;

    /* randomly select one pe */
    destn = McRandomPe(peNum);

    if (ip.TraceOn == 1) {
        printf("contract new goal randomly from pe%d to pe%d \n",
	    peNum,destn); fflush(stdout); }

    if (peNum == destn) {
        SYSMSGDESTPE(mPtr) = SYSMSGNEXTPE(mPtr) = destn;
	QmPutLocalMsg(mPtr,peNum);
	}
    else {
        SYSMSGDESTPE(mPtr) = SYSMSGNEXTPE(mPtr) = destn;
        SYSMSGHOPS(mPtr) = 1;
#ifdef ORACLESIM
	SYSMSGPATH(mPtr,2) = destn;
#endif
    	McSendMsg(mPtr,peNum);
	}
}

LdbContractX(peNum,mPtr)
int	peNum;
SYSMSG	*mPtr;
{
    int		i,k,destn=peNum;
    PEINFORM	*p = &PE(peNum);

    if (PE(peNum).satu == FALSE) {
     if (PE(peNum).dist > 0) 
 	destn = McChoosePe(peNum, peNum,FALSE); 
     else
 	destn = McChoosePe(peNum, DUMMY,FALSE);
     }

    if (ip.TraceOn == 1) {
        printf("contract new goal from pe%d to pe%d \n",
	    peNum,destn); fflush(stdout); }
    if (ip.TraceOn == 3 && (k=abs(PE(destn).oldLoad-p->newLoad)) >= 3)
	printf("load difference = %d pe%d load%d[%d %d] %d[%d %d]\n",k,peNum,
		PE(peNum).newLoad,PE(peNum).inChareQ.qLen,
		PE(peNum).inDataQ.qLen, PE(destn).oldLoad,
		PE(destn).inChareQ.qLen,PE(destn).inDataQ.qLen);

    if (peNum != destn && ip.CSmaxDist > 1 ) 
     	SYSMSGTYPE(mPtr) = SYSMSGTYPE_CTRA;

    if (peNum == destn) {
        SYSMSGDESTPE(mPtr) = SYSMSGNEXTPE(mPtr) = destn;
	QmPutLocalMsg(mPtr,peNum);
	PE(peNum).newLoad++;
	}
    else {
        SYSMSGDESTPE(mPtr) = SYSMSGNEXTPE(mPtr) = destn;
        SYSMSGHOPS(mPtr) = 1;
#ifdef ORACLESIM
	SYSMSGPATH(mPtr,2) = destn;
#endif
    	McSendMsg(mPtr,peNum);
	}
}

LdbContractMid(peNum,mPtr) 
int	peNum;
SYSMSG	*mPtr;
{
    int		k,destn=peNum;

    if (PE(peNum).satu == FALSE) {
    if (PE(peNum).dist > SYSMSGHOPS(mPtr))
	destn = McChoosePe(peNum,peNum,FALSE); 
    else if (ip.CS == CSCONTRACTX)
	destn = McChoosePe(peNum,SYSMSGLASTPE(mPtr),FALSE); 
    else if (ip.CS == CSCONTRACTN)
	destn = McChoosePe(peNum,DUMMY,FALSE); 
    } 
    if (peNum == destn || SYSMSGHOPS(mPtr) >= ip.CSmaxDist-1) 
     	SYSMSGTYPE(mPtr) = SYSMSGTYPE_CHAR;

    if (peNum == destn) {
	QmPutLocalMsg(mPtr,peNum);
	PE(peNum).newLoad++;
	}
    else {
        SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = destn;
        SYSMSGLASTPE(mPtr) = peNum;
	SYSMSGHOPS(mPtr)++;
#ifdef ORACLESIM
    	SYSMSGPATH(mPtr,SYSMSGHOPS(mPtr)+1) = destn;
#endif
    	McSendMsg(mPtr,peNum);
	}
}

LdbRoutMsg(peNum,ptrM) 
int	peNum;
SYSMSG	*ptrM;
{
    int  dummy, nextNum = SYSMSGDESTPE(ptrM);

    clock_off();
    PE(peNum).routNum++;

#ifdef ORACLESIM
#ifdef ROUTE
    find_route(ip.TOPOtype,peNum,SYSMSGDESTPE(ptrM),&nextNum,&dummy);
#else
    nextNum = SYSMSGPATH(ptrM,SYSMSGHOPS(ptrM));
    if (SYSMSGHOPS(ptrM) > 1) SYSMSGHOPS(ptrM)--;
#endif
#endif

    if (nextNum == SYSMSGDESTPE(ptrM))
	SYSMSGTYPE(ptrM) = SYSMSGTYPE_DATA;
    SYSMSGNEXTPE(ptrM) = SYSMSGDESTPE(ptrM) = nextNum;

    McSendMsg(ptrM,peNum);
    clock_on();
}

LdbDiffProc(peNum)
int	peNum;
{
    int 	k,minpe;
    PEINFORM	*p = &PE(peNum);
    SYSMSG 	*mPtr;

    McCurrentLoad(peNum,TRUE);
    minpe = McChoosePe(peNum,peNum,TRUE); 

    co_time_off(k);
    if (p->newLoad > ip.CShighMark)
	p->state = STAT_ABUNDANT;
    else if (p->newLoad < ip.CSlowMark)
	p->state = STAT_IDLE;
    else
	p->state = STAT_NEUTRAL;
    co_time_on(k);

    if (p->state == STAT_IDLE)
	p->newLoad = 0;
    else if (p->state == STAT_NEUTRAL) {
	p->newLoad = 1 + PE(minpe).oldLoad;
	if (p->newLoad > ip.NetDiameter)
	    p->newLoad = ip.NetDiameter;
	}
    else if (PE(minpe).oldLoad > ip.NetDiameter)
	p->newLoad = ip.NetDiameter;
    else if ((mPtr = (SYSMSG *) QmGetGoalMsg(peNum)) != NULLPTR) { 
	co_time_off(k);
	p->newLoad = 1 + PE(minpe).oldLoad;
	if (p->newLoad > ip.NetDiameter)
	    p->newLoad = ip.NetDiameter;
    	PE(peNum).newLoad--;
    	SYSMSGLASTPE(mPtr) = peNum;
    	SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = minpe;
	SYSMSGHOPS(mPtr)++;

#ifdef ORACLESIM
        if (SYSMSGHOPS(mPtr) >= MAXHOPS) {
    	    SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = peNum;
	    co_time_on(k);
	    QmPutLocalMsg(mPtr,peNum);
	    }
	else {
    	    SYSMSGPATH(mPtr,SYSMSGHOPS(mPtr)+1) = minpe;
	    co_time_on(k);
    	    McSendMsg(mPtr,peNum);
 	    }
#else
	    co_time_on(k);
    	    McSendMsg(mPtr,peNum);
#endif

	}
    
    if (p->newLoad != p->oldLoad)
	McBroadcast(peNum);
}

LdbReDistr(peNum)
int	peNum;
{
    int 	k,minpe;
    PEINFORM	*p = &PE(peNum);
    SYSMSG 	*mPtr;

    /* McCurrentLoad(peNum,TRUE); */
    minpe = McChoosePe(peNum,peNum,TRUE); 

    while ((p->newLoad-p->loadAry[minpe])>ip.CSredistrMark) {
  	if ((mPtr = (SYSMSG *) QmGetGoalMsg(peNum)) != NULLPTR) { 
	    co_time_off(k);
    	    PE(peNum).contNum++;
    	    SYSMSGNEXTPE(mPtr) = SYSMSGDESTPE(mPtr) = minpe;
	    SYSMSGHOPS(mPtr) = 1;
	    SYSMSGTYPE(mPtr) = SYSMSGTYPE_CTRA;

#ifdef ORACLESIM
            if (SYSMSGHOPS(mPtr) >= MAXHOPS) {
	        printf("peNum %d minPe%d dist%d\n",peNum,minpe,SYSMSGHOPS(mPtr));
	        fflush(stdout);
	        exit(3);
	        }
    	    SYSMSGPATH(mPtr,SYSMSGHOPS(mPtr)+1) = minpe;
#endif
    	    SYSMSGLASTPE(mPtr) = peNum;

            clock_off();
            if (ip.TraceOn == 5) {
                printf("red %d: peload %d %d %d %d leastpe %d newLoad %d %x\n",
		    peNum,PE(peNum).loadAry[0],PE(peNum).loadAry[1],
	            PE(peNum).loadAry[2],PE(peNum).loadAry[3],minpe,
		    p->newLoad,mPtr);
                    fflush(stdout); }
            clock_on();
	    co_time_on(k);
    	    McSendMsg(mPtr,peNum);
	    p->newLoad--; 
            minpe = McChoosePe(peNum,peNum,TRUE); 
	    }
        else break;
        co_time_on(k); 
 	}
}

