	% handle lazyDet and eagerDet declarations
	%	see other documentation
	%	eg "Parallelizing NU-Prolog" paper (being written)
	%
	% To do:
	% see comments marked with 'BUG'
	% put in code to test for calls to nondet procs
	% insert pcalls
	%
	% Clean up code for simplification of when bodies
	% Dont move input unif when not necessary (no cut)
	% Simplify whens to reduce number of them (not really needed)

	% Delay proc until all clauses are suff. inst. to proceed
	% without constructing input args in head or before a cut.
	% Move output unification to ensure binding determinism.
make_lazyDet(M, CL, W, CL1) :-
	make_det(M, CL, and, W, CL1).

	% Delay proc until one clause is suff. inst. to proceed
	% without constructing input args in head or before a cut.
	% Move output unification to ensure binding determinism.
	% Move input unif and add nonvar/ground to body to ensure
	% no input args would be bound in head or before a cut.
make_eagerDet(M, CL, W, CL1) :-
	make_det(M, CL, or, W, CL1).

make_det(M, CL, AO, W, CL1) :-
	get_guards_l(M, CL, GCL),
	mv_dup_ivars_cl(M, GCL, GCL1),
	check_det(GCL1),
	cl_when_l(M, GCL1, WL),
	simplify_whens(WL, SWL),
	combine_wl(SWL, AO, W),
	(if AO = (or) then
		mv_inp_unif(W, SWL, GCL1, CL1)
		% CL1 = GCL1
	else
		CL1 = GCL1
	).

	% translate list of clauses H :- G, !, B  into list of
	% clauses cl(H1, G, B1), where B contains output unification
get_guards_l(_, [], []).
get_guards_l(M, (H:-B).CL, cl(H1, G, B1).GCL) :-
	get_guard(B, G, B2),
	H =.. F.HA,
	mv_out_args(M, G, 300, HA, H1A, OU),
	H1 =.. F.H1A,
	c_append(OU, B2, B1),
	get_guards_l(M, CL, GCL).

	% move output unification from heads (add to body)
	% only really needed if there is a cut and arg is a nonvar or
	% occurs before cut or occurs in an input arg
	% Currently all args are moved when there is a cut.
mv_out_args([], _, _, [], [], true).
mv_out_args(i.M, G, N, A.L, A.L1, OU) :-
	mv_out_args(M, G, N, L, L1, OU).
mv_out_args(o.M, $nocut, N, A.L, A.L1, OU) :-
	mv_out_args(M, $nocut, N, L, L1, OU).
mv_out_args(o.M, G, N, A.L, $VAR(N).L1, ($VAR(N) = A, OU)) :-
	G ~= $nocut,
	plus(N, 1, N1),
	mv_out_args(M, G, N1, L, L1, OU).

	% separate body into guard and remaining body
	% guard = $nocut if there is no cut
	% (maybe rewrite)
get_guard(GB, G, B) :-
	(if some G1.B1 get_guard1(GB, G1, B1) then
		G = G1,
		B = B1
	else
		G = $nocut,
		B = GB
	).

	% separate body into guard and remaining body
	% fails if there are no cuts
get_guard1(!, true, true).
get_guard1((!, B), G, B1) :-
	if some G2.B2 get_guard1(B, G2, B2) then
		G = (!, G2),
		B1 = B2
	else
		G = true,
		B1 = B.
get_guard1((A, B), (A, G), B1) :-
	A ~= !,
	get_guard1(B, G, B1).

	% convert duplicate head vars into guard unifications
	% for list of clauses
mv_dup_ivars_cl(M, [], []).
mv_dup_ivars_cl(M, GC.GCL, GC1.GCL1) :-
	mv_dup_ivars_c(M, GC, GC1),
	mv_dup_ivars_cl(M, GCL, GCL1).

	% convert duplicate head vars into guard unifications
	% for single clause (only needed with cuts - wrong
	% actually need to remove repeated vars for use in
	% when heads, though not for clause heads)
	% (more efficient to do this at the same time as
	% numbervars)
mv_dup_ivars_c(M, cl(H, G, B), cl(H1, GV, G1, B1)) :-
	(if G = $nocut then
		G1 = $nocut,
		GV = [],
		H =.. HF.HA,
		mv_dup_ivars_m(M, HA, H1A, [], T, 100, _N, EQ),
		H1 =.. HF.H1A,
		c_append(EQ, B, B1)
	else
		B1 = B,
		H =.. HF.HA,
		mv_dup_ivars_m(M, HA, H1A, [], T, 100, _N, EQ),
		H1 =.. HF.H1A,
		c_append(EQ, G, G1),
		eq_vars(EQ, GV2),
		guard_ivars(G1, T, GV1),
		append(GV2, GV1, GV3),
		sort(GV3, GV)
	).

	% cvt duplicate input vars from head and move to
	% guard (output args are moved by mv_out_args)
mv_dup_ivars_m([], [], [], T, T, N, N, true).
mv_dup_ivars_m(o.ML, A.AL, A.AL1, T, T1, N, N1, G) :-
	mv_dup_ivars_m(ML, AL, AL1, T, T1, N, N1, G).
mv_dup_ivars_m(i.ML, A.AL, A1.AL1, T, T1, N, N1, G) :-
	mv_dup_ivars(A, A1, T, T2, N, N2, G2),
	mv_dup_ivars_m(ML, AL, AL1, T2, T1, N2, N1, G1),
	c_append(G2, G1, G).		% should use d-conjunction

	% convert duplicate vars from head
	% (add call to = to body)
mv_dup_ivars(H, H, T, T, N, N, true) :-
	isAtomic(H).
mv_dup_ivars($VAR(V), $VAR(V1), T, T1, N, N1, G) :-
	if member(V, T) then
		V1 = N,
		T1 = T,
		plus(N, 1, N1),
		G = ($VAR(N) = $VAR(V), true)
	else
		V1 = V,
		T1 = V.T,
		N1 = N,
		G = true.
mv_dup_ivars(H, H1, T, T1, N, N1, G) :-
	isTerm(H),
	H ~= $VAR(_),
	H =.. F.A,	% c'mon, we can do better that this
	H1 =.. F.A1,
	mv_dup_ivars_l(A, A1, T, T1, N, N1, G).

mv_dup_ivars_l([], [], T, T, N, N, true).
mv_dup_ivars_l(A.AL, A1.AL1, T, T1, N, N1, G) :-
	mv_dup_ivars(A, A1, T, T2, N, N2, G2),
	mv_dup_ivars_l(AL, AL1, T2, T1, N2, N1, G1),
	c_append(G2, G1, G).		% should use d-conjunction

	% get (input) vars in guard which are in head
guard_ivars(H, _T, []) :-
	isAtomic(H).
guard_ivars($VAR(V), T, G) :-
	if member(V, T) then
		G = [V]
	else
		G = [].
guard_ivars(H, T, G) :-
	isTerm(H),
	H ~= $VAR(_),
	H =.. _F.A,
	guard_ivars_l(A, T, G).

guard_ivars_l([], _T, []).
guard_ivars_l(A.AL, T, G) :-
	guard_ivars(A, T, G2),
	guard_ivars_l(AL, T, G1),
	append(G2, G1, G).		% should use d-list

	% get list of vars on left side of =
eq_vars(true, []).
eq_vars(($VAR(V) = _, C), V.L) :-
	eq_vars(C, L).

	% append for conjunctions (,)
c_append(true, A, A).
c_append((A,B), C, (A,D)) :-
	c_append(B, C, D).

	% append for conjunctions in when bodies (and)
and_append(ever, A, A).
and_append((A and B), C, (A and D)) :-
	and_append(B, C, D).

	% check list of clauses in cl/4 form can be made deterministic:
	% for all clause heads H, all previous clauses PrevCL whose
	% heads HP unify with H must have cuts
	% (nice logical code, compiled efficiently with pure)
?- pure check_det/1.
check_det(CL) :-
	all PrevCL.H.HP.GP
	(	append(PrevCL, cl(H, _, _, _)._, CL),
		member(cl(HP, _, GP, _), PrevCL),
		unify(H, HP)
	)
	=>
		GP ~= $nocut.

	% get list of heads from list of clauses
get_cl_heads([], [], []).
get_cl_heads(cl(H, GV, _, _).CL, H.HL, GV.GVL) :-
	get_cl_heads(CL, HL, GVL).

	% get when dec for each clause in a list
cl_when_l(_M, [], []).
cl_when_l(M, cl(H, GV, _, _).CL, (H1 when WB).WL) :-
	rep_oargs(M, H, H1),
	get_gr_conj(GV, WB),
	cl_when_l(M, CL, WL).

	% replace output args with unique vars
rep_oargs(M, H, H1) :-
	H =.. HF.HA,	% should use arg
	rep_oargs_m(M, HA, H1A, 700),
	H1 =.. HF.H1A.

rep_oargs_m([], [], [], _N).
rep_oargs_m(i.M, A.HA, A.H1A, N) :-
	rep_oargs_m(M, HA, H1A, N).
rep_oargs_m(o.M, _.HA, $VAR(N).H1A, N) :-
	plus(N, 1, N1),
	rep_oargs_m(M, HA, H1A, N1).

	% get body of when given list of vars which
	% must be ground 
get_gr_conj([], ever).
get_gr_conj(V.VL, ground($VAR(V)) and GC) :-
	get_gr_conj(VL, GC).

	% convert a list of vars which must be ground 
	% into a goal which checks that
	% (should just construct term containing all vars?)
get_gr_conjc([], true).
get_gr_conjc(V.VL, (ground($VAR(V)), GC)) :-
	get_gr_conjc(VL, GC).

	% combine list of whens making weaker (or) or stronger (and)
combine_wl([], _C, []).
combine_wl(W.WL, C, WL1) :-
	combine_wl1([W], WL, C, WL1, 500, _).

	% combine two lists of whens making weaker (or) or stronger (and)
	% first list has mutex heads
combine_wl1(MW, [], _C, MW, VN, VN).
combine_wl1(MW, W.WL, C, MW1, VN, VN1) :-
	combine_w(W, MW, C, MW2, VN, VN2),
	combine_wl1(MW2, WL, C, MW1, VN2, VN1).

	% combine a single when into a list of mutex whens
	% could just use combine_2w instead of find_match
combine_w((WH when WB), MW, C, MW2, VN, VN1) :-
	(if some Match.MW1.WPL find_match(WH, MW, Match, WPL, MW1) then
		combine_2w((WH when WB), Match, C, W1, VN, VN2),
		combine_w(W1, MW1, C, MW3, VN2, VN1),
		append(WPL, MW3, MW2)
	else
		MW2 = (WH when WB).MW,
		VN1 = VN
	).

	% combine two single whens with matching heads
	% fails if heads dont match
	% renaming not very efficient
combine_2w(W1, (H2 when B2), C, (H when B), VN, VN1) :-
	rename(W1, (H1 when B1), [], _, VN, VN1),
	general_head(H1, B1, H2, B2, H, EB1, EB2),
	rm_nonhead_vars(H, EB1, B1A),
	rm_nonhead_vars(H, EB2, B2A),
	simplify_body(B1A, B1S),
	simplify_body(B2A, B2S),
	(if C = (or) then
		or_wbody(B2S, B1S, B)
	else
		and_wbody(B2S, B1S, B)
	).

	% get a single more general head plus extra things for
	% bodies where head is made strictly more general
general_head($VAR(V1), B1, $VAR(V2), B2, $VAR(V2), B1s, B2) :-
	subst(B1, V1, V2, B1s).
general_head(T, B1, $VAR(V2), B2, $VAR(V2), B3 and B1, B2) :-
	T ~= $VAR(_),
	list_of_vars(T, TV),		% not very efficient and a bit
	list_of_vars(B1, B1V),		% too conservative using ground
	(if disjoint(TV, B1V) then
		B3 = $VAR(V2)
	else
		B3 = ground($VAR(V2))
	).
general_head($VAR(V1), B1, T, B2, $VAR(V1), B1, B3 and B2) :-
	T ~= $VAR(_),
	list_of_vars(T, TV),		% not very efficient and a bit
	list_of_vars(B2, B2V),		% too conservative using ground
	(if disjoint(TV, B2V) then
		B3 = $VAR(V1)
	else
		B3 = ground($VAR(V1))
	).
general_head(H, B1, H, B2, H, B1, B2) :-
	isAtomic(H).
general_head(H1, B1, H2, B2, H, EB1, EB2) :-
	isTerm(H1),
	isTerm(H2),
	H1 =.. F.HA1,
	H2 =.. F.HA2,
	general_head_l(HA1, B1, HA2, B2, HA, EB1, EB2),
	H =.. F.HA.

	% as above for list of args
general_head_l([], B1, [], B2, [], B1, B2).
general_head_l(A1.HA1, B1, A2.HA2, B2, A.HA, EB1, EB2) :-
	general_head(A1, B1, A2, B2, A, EB1a, EB2a),
	general_head_l(HA1, EB1a, HA2, EB2a, HA, EB1, EB2).

	% two lists are disjoint
	% (could be compiled more efficiently)
?- pure disjoint/2.
disjoint(A, B) :-
	all X member(X, A) => not member(X, B).

	% find when in list which matches with head and return
	% the matching when plus other whens
find_match(H, (WH when WB).WL, MW, WPL, WL1) :-
	if unify(H, WH) then
		MW = (WH when WB),
		WPL = [],
		WL1 = WL
	else
		WPL = (WH when WB).WPL1,
		find_match(H, WL, MW, WPL1, WL1).

	% terms unify - assume no repeated vars
	% not very efficient compared with built in unification
	% with real vars
unify($VAR(V), WH).
unify(T, $VAR(V)) :-
	T ~= $VAR(_).	% not needed
unify(A, A) :-
	isAtomic(A).
unify(H, W) :-
	isTerm(W),
	W ~= $VAR(_),
	H ~= $VAR(_),
	functor(W, F, N),
	functor(H, F, N),
	unify_a(N, H, W).

	% unify args
unify_a(0, _H, _W).
unify_a(N, H, W) :-
	N > 0,
	plus(N1, 1, N),
	arg(N, H, HA),
	arg(N, W, WA),
	unify(HA, WA),
	unify_a(N1, H, W).

	% substitute one var number for another in a term
subst(A, _, _, A) :-
	isAtomic(A).
subst($VAR(A), A, A1, $VAR(A1)).
subst($VAR(A), B, _, $VAR(A)) :-
	B ~= A.
subst(A, V, V1, A1) :-
	A ~= $VAR(_),
	isTerm(A),
	functor(A, F, N),
	functor(A1, F, N),
	subst_a(N, A, V, V1, A1).

	% as above for args
subst_a(0, _A, _V, _V1, _A1).
subst_a(N, A, V, V1, A1) :-
	N > 0,
	N1 is N - 1,
	arg(N, A, AA),
	arg(N, A1, AA1),
	subst(AA, V, V1, AA1),
	subst_a(N1, A, V, V1, A1).

	% rename vars in a term
	% use assoc list for new names plus a number to start new
	% var names at (like numbervars)
rename(A, A, AL, AL, VN, VN) :-
	isAtomic(A).
rename($VAR(A), $VAR(A1), AL, AL1, VN, VN1) :-
	(if some NV member(A-NV, AL) then
		A1 = NV,
		AL1 = AL,
		VN1 = VN
	else
		A1 = VN,
		AL1 = (A-VN).AL,
		VN1 is VN + 1
	).
rename(A, A1, AL, AL1, VN, VN1) :-
	A ~= $VAR(_),
	isTerm(A),
	functor(A, F, N),
	functor(A1, F, N),
	rename_a(N, A, A1, AL, AL1, VN, VN1).

	% as above for args
rename_a(0, _A, _A1, AL, AL, VN, VN).
rename_a(N, A, A1, AL, AL1, VN, VN1) :-
	N > 0,
	N1 is N - 1,
	arg(N, A, AA),
	arg(N, A1, AA1),
	rename(AA, AA1, AL, AL2, VN, VN2),
	rename_a(N1, A, A1, AL2, AL1, VN2, VN1).

	% remove vars in the body of a when which no longer appear
	% in the head
rm_nonhead_vars(H, B, B1) :-
	list_of_vars(H, HV),
	rm_body_vars(HV, B, B1).

	% get list of vars numbers in a term
	% (should use in guard_ivars?)
list_of_vars(T, VL) :-
	list_of_vars(T, [], VL).

	% as above with d-list
list_of_vars(T, VL, VL) :-
	isAtomic(T).
list_of_vars($VAR(N), VL, VL1) :-
	if member(N, VL) then
		VL1 = VL
	else
		VL1 = N.VL.
list_of_vars(T, VL, VL1) :-
	isTerm(T),
	T ~= $VAR(_),
	functor(T, F, N),
	list_of_vars_a(N, T, VL, VL1).

	% as above for each arg
list_of_vars_a(0, _, VL, VL).
list_of_vars_a(N, T, VL, VL1) :-
	N > 0,
	plus(N1, 1, N),
	arg(N, T, A),
	list_of_vars(A, VL, VL2),
	plus(N1, 1, N),
	list_of_vars_a(N1, T, VL2, VL1).

	% remove vars which appear in list from body of a when
?- rm_body_vars(_, A, _) when A.	% expand for clause indexing
rm_body_vars(_HV, ever, ever).
rm_body_vars(HV, (A and B) and C, D) :-	% BUG more clauses like this needed
	rm_body_vars(HV, A and B and C, D).
rm_body_vars(HV, ever and C, D) :-	% BUG more clauses like this needed
	rm_body_vars(HV, C, D).
rm_body_vars(HV, $VAR(N), B) :-
	(if member(N, HV) then
		B = $VAR(N)
	else
		B = ever
	).
rm_body_vars(HV, ground($VAR(N)), B) :-
	(if member(N, HV) then
		B = ground($VAR(N))
	else
		B = ever
	).
rm_body_vars(HV, ($VAR(N) and B0), B) :-
	(if member(N, HV) then
		B = ($VAR(N) and B1)
	else
		B = B1
	),
	rm_body_vars(HV, B0, B1).
rm_body_vars(HV, ($VAR(N) or B0), B) :-
	(if member(N, HV) then
		B = ($VAR(N) or B1)
	else
		B = B1
	),
	rm_body_vars(HV, B0, B1).
rm_body_vars(HV, (ground($VAR(N)) and B0), B) :-
	(if member(N, HV) then
		B = (ground($VAR(N)) and B1)
	else
		B = B1
	),
	rm_body_vars(HV, B0, B1).
rm_body_vars(HV, (ground($VAR(N)) or B0), B) :-
	(if member(N, HV) then
		B = (ground($VAR(N)) or B1)
	else
		B = B1
	),
	rm_body_vars(HV, B0, B1).

