/****************************************************************
Copyright (C) The University of Melbourne 1993
All Rights Reserved

Permission to use, copy, modify, and distribute this software and
its documentation for any purpose and without fee is hereby
granted, provided that the above copyright notice appear in all
copies and that both that the copyright notice and this
permission notice and warranty disclaimer appear in supporting
documentation, and that the name of The University of Melbourne 
or any of its entities not be used in advertising or publicity
pertaining to distribution of the software without specific,
written prior permission.

THE UNIVERSITY OF MELBOURNE DISCLAIMS ALL WARRANTIES WITH REGARD
TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS.  IN NO EVENT SHALL THE UNIVERSITY
OF MELBOURNE OR ANY OF ITS ENTITIES BE LIABLE FOR ANY
SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER
IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
THIS SOFTWARE.

AUTHORS : Jason Lee (jasonl@cs.mu.oz.au)
	  Andrew Davison (ad@cs.mu.oz.au)

COMMENTS : This header file contains all the
	   definitions of macros needed and the types
	   as well. Things may need change later.
****************************************************************/

/* Make sure only include once */
#ifndef CONSH
#define CONSH

/******************************************************
 PLEASE READ AND EDIT THIS SECTION IN RELATION TO THE
 NU-PROLOG COMPILER LOACTION ON YOUR SYSTEM AND THE
 LOCATION OF THE PNP PREPROCESSOR, THANKS

 The following should be changed to reflect your local
 system. That is if nc is not in the users path then
 change the following two lines and if pnp is not
 in the user paths change it accordingly.
*******************************************************/
#define		NC		"nc -c "
#define		LEN_NC		6
#define		PNP		"pnp < "
#define		LEN_PNP		6

/***** NOTHING PASSED THIS POINT NEEDS TO BE CHANGED ******/


/* Include header files both local and standard */
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include <sys/types.h>
#include <time.h>


/* Some common constants */
#define		TRUE		1
#define		FALSE		0
#define		INPUT		1
#define		OUTPUT		0
#define		UNKNOWN		2
#define		NO_ARITY	-1
#define		VISIBLE		1
#define		INVISIBLE	0
#define		EQ		1
#define		IS		0

#ifndef EXIT_SUCCESS
#define		EXIT_SUCCESS	0
#define		EXIT_FAILURE	1
#endif

#ifndef NULL
#define		NULL		0
#endif

#define         BLANK           ' '
#define		EOS		'\0'
#define		EOL		'\n'
#define		TAB		'\t'
#define		DASH		'-'
#define		HASH		'#'
#define		DIR		'/'
#define		SUFFIX		".bp"
#define		LEN_SUFFIX	3
#define		PNP_SUFFIX	".pnp"
#define		LEN_PNP_SUFFIX  4
#define		NL		".nl"
#define		LEN_NL		3
#define		APP		" >> "
#define		LEN_APP		4
#define		CREATEID	"$bb_create_id(BB$_Mesg, Self, Input)"
#define		MESG		"BB$_Mesg"
#define		INPUTSTR	"Input"
#define		ID		"Self"
#define		ANY		"[Any | Input]"
#define		SEND		"$bb_send(BB$_Mesg, "
#define		PREFIXTMP	"/tmp/bebop_tmp"
#define		LEN_PREFTMP	14
#define		VAR_TMP		"Temp$bb_"
#define		LEN_VAR_TMP	8
#define		BECOMES		"becomes"
#define		LEN_BEC		7
#define		IAM		"i_am"
#define		LEN_IAM		4
#define		CALLCLASS	"call_class"
#define		LEN_CCLASS	10
#define		TABWIDTH	8
#define		MAX		80
#define		HASHSIZE	53

/* To access tree */
#define		OP(tree)	(tree->operator)
#define		OP1(tree)	(tree->value.nodes.op1)
#define		OP2(tree)	(tree->value.nodes.op2)
#define		CONSTT(tree)	(tree->value.constant)
#define		VART(tree)	(tree->value.variable)
#define 	PREDT(tree)	(tree->value.predicate)
#define		LIST(tree)	(tree->value.list)

/* To access token_table */
#define         tok_lookup(tok)         (((tok) < TOK_START_TABLE) ? \
					  &token_table[0][tok] : \
					  token_table[(tok) - TOK_START_TABLE])
#define		TOK_2			-1
#define		TOK_CUT			0
#define		TOK_OPAR		1
#define		TOK_CPAR		2
#define		TOK_COMMA		3
#define		TOK_FULLSTOP		4
#define		TOK_COLON		5
#define		TOK_SEMICOLON		6
#define		TOK_OBLK		7
#define		TOK_CBLK		8
#define		TOK_PIPE		9


/* Prototype declaration for copy_string */
char *copy_string(const char *ostr, const int len);

/* If you would prefer to use the functions defined
   in bebop_functions.c instead of the following macros
   then define USE_FUNCTIONS
*/

#ifndef USE_FUNCTIONS

/* Extern declaration of tmp_pointer */
extern void *tmp_pointer;

/* Use macros */
/* Macro for integer to ascii */
#define	 	itoa(str, index, n)	{ int it_n = n; \
					  do \
					  { \
					    str##[##index##++]=it_n % 10 + '0';\
					  }while((it_n /= 10) > 0); \
					  str##[##index##] = EOS; \
					}

/* Macro for new memory */
#define		safe_malloc(size) \
		( \
		 tmp_pointer = malloc(size), \
		 (tmp_pointer == NULL) ? \
			perror("memory allocation failed"), \
			exit(1), \
			(void *)NULL \
		 : tmp_pointer \
		)

#define		safe_realloc(oldptr, size) \
		( \
		 tmp_pointer = realloc(oldptr, size), \
		 (tmp_pointer == NULL) ? \
			perror("memory allocation failed"), \
			exit(1), \
			(void *)NULL \
		 : tmp_pointer \
		)
#else

/* Use functions */
void itoa_funct(char str[], int *index, const int n);
void *safe_malloc_funct(int size);
void *safe_realloc_funct(void *oldptr, int size);

#define		itoa(str, index, n)	itoa_funct(str, &index, n)
#define		safe_malloc(size)	safe_malloc_funct(size)
#define		safe_realloc(oldptr, size)   safe_realloc_funct(oldptr, size)

#endif

/* Normal macros for memory allocation */
#define		NEWN(type, n)	((type *)safe_malloc(n * sizeof(type)))
#define		NEW(type)	NEWN(type, 1)
#define		RSIZE(array, type, num) \
			((type *)safe_realloc(array, ((num)*sizeof(type))))


/* The types needed by bebop */
/* All the pointer types that are possible */
typedef struct var_entry_rec *VARPTR;
typedef struct tree_node *TREEPTR;
typedef struct fa_entry_rec *FAPTR;
typedef struct var_list_rec *VARLISTPTR;
typedef struct tree_list_rec *TLISTPTR;
typedef struct const_rec_entry *CONSTPTR;

/* The type of the variable table to store
   the visible and invisible variables,
   their mode and any initial value etc
*/
typedef struct var_entry_rec
	{
		VARPTR next;	/*Next entry in chain */
		char *varname;	/*Actual variable name */
		TREEPTR value;	/*Initial value if has one */

		char mode;	/*INPUT or OUTPUT or UNKNOWN*/
		char type;	/*VISIBLE or INVISIBLE or UNKNOWN */
		char defined;	/*Has the var been declared*/
		char dbs;	/*Is variable associated with a dbs */
		char sys;	/*Is variable a system one */
		int position;	/*Position of argument, if visible var */
	}VENTRY;

/* The type of the predicate table to store
   the predicate's name and arity
*/
typedef struct fa_entry_rec
	{
		FAPTR next;	/*Next entry in chain */
		char *faname;	/*Functor name i.e predicate */
		int arity;	/*Arity in case 2 functors same name */

		char defined;	/*Is it defined in this class */
		char called;	/*Has pred been called */
		char decl;	/*Has it a decl (when or lazy/eagerDet)*/
		char sys;	/*Is it a system predicate */
	}FAENTRY;


/* The type of the constant table to
   store constants. This is needed
   for later error checking.
*/
typedef struct const_rec_entry
	{
		CONSTPTR next;	/* Next entry in chain */
		char *constant;	/* The actual constant */
		int lineno;	/* Line number of constant */
		char *possible_error_line;	/* Actual line of constant */
		int called;	/* Has be called ?? Then error */
	}CONSTENTRY;

/* The list of trees type */
typedef struct tree_list_rec
	{
		TREEPTR tree;	/* The tree */
		TLISTPTR next;	/* Next link */
	}TLIST;

/* The variable list type */
typedef struct var_list_rec
	{
		VARPTR variable;  /* The variable */
		VARLISTPTR next;  /* The next link */
	}VARLIST;


/* The type of a node in the parse tree.
   Always has an op i.e token value.
   Then it can either have three children
   or just point to a constant or var or
   predicate or a list of trees containing
   a group of predicates etc
*/
typedef struct tree_node
	{
		int operator;		/*Type of op TOK_??? yacc */

		/* What can a node be ?? */
		union
		{
			/* A node can have 2 children */
			struct
			{
				TREEPTR op1, op2;
			}nodes;

			/* Character constant eg int, float etc */
			CONSTPTR constant;

			/* A variable */
			VARPTR variable;

			/* Or an atom (predicate) */
			struct
			{
				FAPTR functor;
				TREEPTR args;
			}predicate;

			/* Or point to a linked list of trees */
			TLISTPTR list;
		}value;
	}NODE;


#endif
