/* $Id: error.c,v 1.11 1993/09/09 10:17:52 bd Exp $
 */

#include <errno.h>

#include "include.h"
#include "term.h"
#include "tree.h"
#include "instructions.h"
#include "predicate.h"
#include "exstate.h"
#include "display.h"
#include "foreign.h"
#include "error.h"
#include "config.h"
#include "storage.h"
#include "names.h"

Functor functor_exception_1;
Functor functor_errno_1;

void error_exit(e)
    int e;
{
#ifdef unix
    break_to_gdb();		/* defined in foreign.c */
#endif
    exit(e);
}

void akl_error(t,arg)
    int	t;
    Term arg;
{
    switch(t) {
    case E_PUT_ARG:
	fprintf(stderr,"{ERROR: illegal arithmetic expression}\n");
	fprintf(stderr,"{ERROR: put(");
	display_term(arg,-1);
	fprintf(stderr,") - illegal argument}\n");
	break;
    case E_OPEN_FILE:
	fprintf(stderr,"{ERROR: %s - cannot open file}\n",AtmPname(Atm(arg)));
	break;
    case E_FILE_SPEC:
	fprintf(stderr,"{ERROR: ");
	display_term(arg,-1);
	fprintf(stderr," - invalid file spec}\n");
	break;
    case E_NR_FILES:
	fprintf(stderr,"{ERROR: cannot open more files}\n");
	break;
    case E_ILLEGAL_GOAL:
	fprintf(stderr,"{ERROR: ");
	display_term(arg,-1);
	fprintf(stderr," - illegal goal}\n");
	break;
    case E_PRED_NOT_DEF:
	{
	  /* [BD] This is a little ugly. The "arg" is a pointer to a
	   * predicate definition, which is not a Term. Maybe it would
	   * be nicer to tag it as a variable or something, and then
	   * untag it here, but for the time being we just kludge it.
	   */
	  predicate *def = (predicate *) Tad(arg);
	  fprintf(stderr,"{Warning: The predicate %s/%d is undefined}\n",
		  AtmPname(def->name), def->arity);
	  break;
	}
    default:
	fprintf(stderr,"Error: akl_error, no such error type\n");
    }
}

Term make_exception_term(err,andb)
     Term err;
     andbox *andb;
{
  Structure sexc;

  MakeStruct(sexc, functor_exception_1, andb);
  StrArgument(sexc,0) = err;

  return TagStr(sexc);
}

Term make_errno_term(andb)
     andbox *andb;
{
  Structure sexc;
  Term no;
  
  MakeStruct(sexc, functor_errno_1, andb);
  MakeIntegerTerm(no, errno);
  StrArgument(sexc,0) = no;

  return TagStr(sexc);
}


void initialize_error() {
  functor_exception_1 = store_functor(store_atom("exception"),1);
  functor_errno_1 = store_functor(store_atom("errno"),1);
}
