/* $Id: bignum.c,v 1.20 1993/10/09 16:24:17 bd Exp $ */

#ifdef BIGNUM

#include "include.h"
#include "term.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "gmp.h"
#include "unify.h"
#include "gc.h"
#include "copy.h"
#include "storage.h"
#include "config.h"
#include "initial.h"
#include "bignum.h"
#include "builtin.h"
#include "error.h"

extern void *bignum_alloc();
extern void *bignum_realloc();
extern void  bignum_dealloc();

Generic	newbnum();
bool 	unifybnum();
int 	printbnum();
Generic	copybnum();
Generic	gcbnum();
int     uncopiedbnum();
envid	*deallocatebnum();
  
method bnummethod =
{
  newbnum,
  unifybnum,
  printbnum,
  copybnum,
  gcbnum,
  uncopiedbnum,
  deallocatebnum,
  NULL,
  NULL
};

typedef struct {
  generic	generic;
  MP_INT	mp_int;
} BigNum;
  
int bignum_initiated = FALSE;

#define INIT_BIGNUM \
  if (!bignum_initiated)\
    {\
      bignum_initiated = TRUE;\
      mp_set_memory_functions(bignum_alloc,bignum_realloc,bignum_dealloc);\
    }

#define Bign(Prt)  ((BigNum *)Prt)

#define IsBignum(Prt) (IsGEN(Prt) && Gen(Prt)->method == &(bnummethod))


/* -------------------------------------------------------------------- */

Generic newbnum(old)
     BigNum *old;
{
  BigNum *new;

  NEW(new, BigNum);

  return (Generic) new;
}

/* -------------------------------------------------------------------- */

Generic copybnum(old,new)
     BigNum *old, *new;
{
  mpz_init_set(&new->mp_int, &old->mp_int);

  return (Generic) new;
}

/* -------------------------------------------------------------------- */

Generic gcbnum(old,new,gcst)
     BigNum *old, *new;
     gcstatep gcst;
{
  mpz_init_set(&new->mp_int, &old->mp_int);

  return (Generic) new;
}

/* -------------------------------------------------------------------- */

envid *deallocatebnum(prt)
     generic *prt;
{
  return NULL;
}

/* -------------------------------------------------------------------- */

int uncopiedbnum(prt)
     generic *prt;
{
  return 0;
}

/* -------------------------------------------------------------------- */

bool unifybnum(xt,yt,andb,exs)
     Term xt, yt;
     andbox *andb;
     exstate *exs;
{
  if (!IsBignum(xt)) {
    FatalError("unifybnum called with non-Bignum argument");
  } else {
    BigNum *x = Bign(Gen(xt));
    if (IsBignum(yt)) {
      BigNum *y = Bign(Gen(yt));
      return mpz_cmp(&x->mp_int,&y->mp_int) == 0;
    }
  }
  return FALSE;
}

/* -------------------------------------------------------------------- */

int printbnum(file,bn,tsiz)
     FILE *file;
     BigNum *bn;
     int tsiz;
{
  extern char *salloc();

  char *buf = salloc(mpz_sizeinbase(&bn->mp_int,10) + 2);

  mpz_get_str(buf, 10, &bn->mp_int);
  fprintf(file,"b'%s", buf);
  free(buf);			/* should use sfree or something */
  return 1;
}

/* -------------------------------------------------------------------- */

bool akl_big(Arg)
    Argdecl;
{
  register Term X0;
    
  Deref(X0, A(0));    
  IfVarSuspend(X0);
  return IsBignum(X0);
}

/* -------------------------------------------------------------------- */

bool akl_big_to_chars(Arg)
     Argdecl;
{
  Term X0, X1, lst;

  Deref(X0, A(0));  

  if(IsBignum(X0))
    {
      extern char *salloc();
      char *buf = salloc(mpz_sizeinbase(&Bign(Gen(X0))->mp_int,10));
      mpz_get_str(buf, 10, &Bign(Gen(X0))->mp_int);
      lst = make_string_list(buf);
      free(buf);		/* should use sfree or something */
      Deref(X1, A(1));        
      return unify(X1,lst,exs->andb,exs);
    }
  IfVarSuspend(X0);
  return FALSE;
}


bool akl_chars_to_big(Arg)
    Argdecl;
{
  register Term X0, X1;
  
  Deref(X0, A(0));
  
  if(IsLST(X0)) 
    {
      char temp[2048];		/* not optimal.... */
      int i = 0;
      BigNum *gen;
      Term gen_t;
      Term next, lst = X0;

      INIT_BIGNUM;		/* could be first one */
      while(IsLST(lst))	/* CHECK IF STARTING WITH b' */
	{
	  GetLstCar(next,Lst(lst));
	  Deref(next,next);
	  if(IsINT(next)) 
	    {  
	      temp[i++] = (char) IntVal(Int(next));
	      if( i > MAXNUMLEN ) {
		FatalError("akl_bignum_chars: buffer exceeded");
	      }
	      GetLstCdr(lst,Lst(lst));
	      Deref(lst,lst);
	    } 
	  else 
	    {
	      IfVarSuspend(next);
	      return FALSE;
	    }
	}
      if(Eq(lst, NIL)) { return FALSE; }
      temp[i] = '\0';
      MakeGenericTerm(gen_t, BigNum, &bnummethod);
      gen = Bign(Gen(gen_t));
      mpz_init_set_str(&gen->mp_int, temp, 10);
      
      Deref(X1, A(1));  
      return unify(X1, gen_t, exs->andb,exs);
    }
  
  IfVarSuspend(X0);
  return FALSE;
}

/* -------------------------------------------------------------------- */

void *bignum_alloc(size)
     size_t size;
{
  char *limbs;

  NEWX(limbs,char,size);

  return limbs;
}


/* Note that shrinking will create holes on the heap */

void *bignum_realloc(limbs,size,newsize)
     char *limbs;
     size_t size, newsize;
{
  if (newsize < size)
    return limbs;		/* return old object */

  NEWX(limbs,char,newsize);
  return limbs;
}

void bignum_dealloc(limbs,size)
     void *limbs;
     size_t size;
{
}


/*************************************************************************/

#define BigArithmetic(Operator)\
{\
  Term X0, X1, X2;\
\
  Deref(X0, A(0));\
  Deref(X1, A(1));\
  \
  if ((IsBignum(X0) && IsBignum(X1))) {\
    BigNum *res;\
    MakeGeneric(res, BigNum, &bnummethod);\
\
    mpz_init(&res->mp_int);\
\
    Operator (&res->mp_int, &Bign(Gen(X0))->mp_int, &Bign(Gen(X1))->mp_int);\
\
    Deref(X2, A(2));\
    return unify(X2, TagGen(res), exs->andb,exs);\
  }\
  IfVarSuspend(X0); \
  IfVarSuspend(X1); \
  return FALSE;\
}

#define BigComparison(Operator)\
{\
  Term X0, X1;\
    \
  Deref(X0, A(0));        \
  Deref(X1, A(1));        \
\
  if ((IsBignum(X0) || IsVar(X0)) &&\
     (IsBignum(X1) || IsVar(X1))) {\
    IfVarSuspend(X0); \
    IfVarSuspend(X1); \
    return\
      (mpz_cmp(&Bign(Gen(X0))->mp_int,&Bign(Gen(X1))->mp_int) Operator 0) ? TRUE:FALSE;\
  }\
  return FALSE;\
}


bool akl_int_to_big(Arg)
     Argdecl;
{
  Term X0, X1;
  BigNum *gen;

  INIT_BIGNUM;
  Deref(X0, A(0));

  if (IsINT(X0))
    {
      MakeGeneric(gen, BigNum, &bnummethod);
      mpz_init_set_si(&gen->mp_int, IntVal(Int(X0)));
      Deref(X1, A(1));
      return unify(X1, TagGen(gen), exs->andb,exs);
    }

  IfVarSuspend(X0);
  return FALSE;
}


bool akl_big_to_int(Arg)
     Argdecl;
{
  Term X0, X1;
  Deref(X0, A(0));

  if (IsBignum(X0))
    {
      int i = mpz_get_si(&Bign(Gen(X0))->mp_int);
      Term j;
      MakeIntegerTerm(j, i);
      Deref(X1, A(1));
      return unify(X1, j, exs->andb, exs);
    }

  IfVarSuspend(X0);
  return FALSE;
}


bool akl_big_add(Arg)
     Argdecl;
{
  BigArithmetic(mpz_add);
}


bool akl_big_sub(Arg)
    Argdecl;
{
  BigArithmetic(mpz_sub);
}


bool akl_big_div(Arg)
    Argdecl;
{
  BigArithmetic(mpz_div);
}


bool akl_big_mul(Arg)
    Argdecl;
{
  BigArithmetic(mpz_mul);
}


bool akl_big_mod(Arg)
    Argdecl;
{
  BigArithmetic(mpz_mod);
}

/* could be done with mpz_mul_2exp......

bool akl_big_shift_up(Arg)
    Argdecl;
{
  BigArithmetic(<<);
}


bool akl_big_shift_down(Arg)
    Argdecl;
{
  BigArithmetic(>>);
}
*/


bool akl_big_equal(Arg)
     Argdecl;
{
  BigComparison(==);
}


bool akl_big_not_equal(Arg)
     Argdecl;
{
  BigComparison(!=);
}


bool akl_big_less(Arg)
     Argdecl;
{
  BigComparison(<);
}


bool akl_big_not_less(Arg)
    Argdecl;
{
  BigComparison(>=);
}


bool akl_big_greater(Arg)
    Argdecl;
{
  BigComparison(>);
}


bool akl_big_not_greater(Arg)
     Argdecl;
{

  BigComparison(<=);
}


void initialize_bignum() {

  define("big_add",akl_big_add,3);
  define("big_sub",akl_big_sub,3);
  define("big_mul",akl_big_mul,3);
  define("big_div",akl_big_div,3);
  define("big_mod",akl_big_mod,3);
  define("big_to_chars",akl_big_to_chars,2);
  define("chars_to_big",akl_chars_to_big,2);
  define("int_to_big",akl_int_to_big,2);
  define("big_to_int",akl_big_to_int,2);

  define("big_equal", akl_big_equal,2);
  define("big_not_equal", akl_big_not_equal,2);
  define("big_less", akl_big_less,2);
  define("big_not_less", akl_big_not_less,2);  
  define("big_greater", akl_big_greater,2);
  define("big_not_greater", akl_big_not_greater,2);  
}

#else

void initialize_bignum() {}

#endif /* BIGNUM */
