/* $Id: aggregate.c,v 1.8 1993/10/15 15:15:12 bd Exp $ */

#include "include.h"
#include "term.h"
#include "tree.h"
#include "predicate.h"
#include "exstate.h"
#include "engine.h"
#include "storage.h"
#include "unify.h"
#include "copy.h"
#include "gc.h"
#include "initial.h"
#include "config.h"
#include "error.h"
#include "aggregate.h"

Gvainfo newcollectobj();
bool 	unifycollectobj();
int 	printcollectobj();
Gvainfo	copycollectobj();
Gvainfo	gccollectobj();
int     uncopiedcollectobj();
envid	*deallocatecollectobj();
int	killcollectobj();
bool	closecollectobj();

gvamethod collectobjmethod = {
  newcollectobj,
  unifycollectobj,
  printcollectobj,
  copycollectobj,
  gccollectobj,
  NULL,		/* collectobjs are not put on the close list, so 'uncopied', */
  NULL,		/* 'deallocate',  */
  NULL,		/* 'kill',  */
  NULL,		/* and 'close' methods are not used */
  NULL,
  NULL,
  NULL
};

Gvainfo newcollectobj(old)
     collectobj *old;
{
  collectobj *new;
  NEW(new,collectobj);
  return (Gvainfo) new;
}

Gvainfo copycollectobj(old,new)
     collectobj *old, *new;
{
  new->value = old->value;
  copy_location(&new->value);
  return (Gvainfo) new;
}

Gvainfo gccollectobj(old,new,gcst)
     collectobj *old, *new;
     gcstatep gcst;
{
  new->value = old->value;
  gc_location(&new->value,gcst);
  return (Gvainfo) new;
}

bool unifycollectobj(cobj,y,andb,exs)
     Term cobj;
     Term y;
     andbox *andb;
     exstate *exs;
{
  if(Eq(cobj, y))
    return TRUE;
  return FALSE;
}

int printcollectobj(file,cobj,tsiz)
     FILE *file;
     collectobj *cobj;
     int tsiz;
{
  fprintf(file,"{COLLECTOR: %#lx}", (long)cobj);
  return 1;
}


/* COLLECTOR/2 CollectObj, List */
bool akl_open_collectobj(Arg)
     Argdecl;
{
  Term X0, X1, res;
  collectobj *cobj;
  
  Deref(X0,A(0));		/* The term unified with the collectobj */
  Deref(X1,A(1));		/* The value associated ith the collectobj */

  MakeGvainfo(cobj,collectobj,&collectobjmethod,exs->andb);
  cobj->value = X1;

  MakeCvaTerm(res, (Gvainfo)cobj);

  return unify(X0,res,exs->andb,exs);
}

void initialize_aggregate() {

  define("COLLECTOR",akl_open_collectobj,2);
}
