/*
 * Copyright (C) 1990, 1993 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * dl.c - XWIP descriptors lists
 *
 * DLCreate
 * DLDestroy
 * DLAdd
 * DLLookup
 * DLSearch
 * DLFind
 * DLRemove
 */

#include <stdio.h>

#include "dl.h"

extern char *malloc();

void 
DLCreate(lp, size, first) 
     DL *lp;			/* list pointer */ 
     int size;			/* size of actual list element */
     int first;		/* first descriptor */
{ 
  lp->list = NULL; 
  lp->size = size;
  lp->first = first;
}

void
DLDestroy(lp)
     DL *lp;			/* list pointer */
{
  DLHeader *t, *hp = lp->list;

  lp->list = NULL;
  while (hp != NULL)  { 
    t = hp;
    hp = hp->next;
    free((char *)t);		/* should check for errors */
  }
}

DLAdd(lp, dp, epp)
     DL *lp;			/* list pointer */
     int *dp;			/* returned descriptor */
     DLHeader **epp;		/* returned element pointer */
{
  int base = lp->first;
  unsigned size = lp->size;
  DLHeader *new, *hp = lp->list, **tpp = &(lp->list);

  while (hp != NULL)  {
    if (hp->des != base) 
      break;
    tpp = &(hp->next);
    hp = hp->next;
    base++;
  }
  if ((new = (DLHeader *)malloc(size)) == NULL)
    return(DL_Error);		/* errno will be set */
  *tpp = new;
  new->next = hp;
  new->des = base;
  *epp = new;
  *dp = base;
  return(DL_Ok);
}
 
DLLookup(ls, d, epp)
     DL ls;			/* list */
     int d;			/* descriptor */
     DLHeader **epp;		/* returned element pointer */
{
  DLHeader *hp = ls.list;

  while (hp != NULL) {
    if (hp->des < d) {
      hp = hp->next;
      continue;
    } if (hp->des == d) {
      *epp = hp;
      return(DL_Ok);
    } else
      break;
  }
  return(DL_BadValue);
}

DLSearch(ls, k, epp)
     DL ls;			/* list */
     int k;			/* key */
     DLHeader **epp;		/* returned element pointer */
{
  DLHeader *hp = ls.list;

  while (hp != NULL) {
    if (hp->data.key != k) {
      hp = hp->next;
      continue;
    } 
    *epp = hp;
    return(DL_Ok);
  }
  return(DL_BadValue);
}

DLFind(ls, p, epp)		/* like DLSearch, but use pointer union value */
     DL ls;			/* list */
     char *p;			/* pointer */
     DLHeader **epp;		/* returned element pointer */
{
  DLHeader *hp = ls.list;

  while (hp != NULL) {
    if (hp->data.ptr != p) {
      hp = hp->next;
      continue;
    } 
    *epp = hp;
    return(DL_Ok);
  }
  return(DL_BadValue);
}

void
DLRemove(lp, d)
     DL *lp;			/* list pointer */
     int d;			/* descriptor */
{
  DLHeader *hp = lp->list, **tpp = &(lp->list);

  while (hp != NULL) {
    if (hp->des < d) {
      tpp = &(hp->next);
      hp = hp->next;
      continue;
    } else if (hp->des == d) {
      *tpp = hp->next;
      free((char *)hp);
      return;
    } else
      break;			/* if not found it's OK */
  }
  return;
}

/*
 * eof
 */
