/*
 * Copyright (C) 1990 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * graphics.c - graphics functions
 *
 * pxClearArea
 * pxCopyArea
 * pxCopyPlane
 *
 * pxDrawPoints
 * pxDrawLines
 * pxDrawSegments
 * pxDrawRectangles
 * pxDrawArcs
 *
 * pxFillRectangles
 * pxFillPolygon
 * pxFillArcs
 */

#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"

/*
 * pxClearArea(+Connection, +Window, +X, +Y, +Width, +Height, +Exposures, 0).
 *	integer: Connection, Window, X, Y, Width, Height, Exposures
 */
FFInteger
pxClearArea(pc, pw, px, py, pwth, ph, pe)
     FFInteger pc, pw, px, py, pwth, ph, pe;
{
  PxConnection *pcp;

  PX_ErrorInit("xClearArea/7");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XClearArea(pcp->xDisplay, pw, px, py, pwth, ph, pe);
  return FF_Ok;
}

/*
 * pxCopyArea(+Connection, +Src, +Dest, +GC, +SrcX, +SrcY, +Width, +Height,
 *	+DestX, +DestY, 0)
 *
 *	integer: Connection, Src, Dest, GC, SrcX, SrcY, Width, Height, DestX,
 *		DestY	
 */
FFInteger
pxCopyArea(pc, ps, pd, pgc, psx, psy, pw, ph, pdx, pdy)
     FFInteger pc, ps, pd, pgc, psx, psy, pw, ph, pdx, pdy;
{
  PxConnection *pcp;
  PxGC *pgcp;

  PX_ErrorInit("xCopyArea/10");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp))
    PX_Error(no_such_gc);

  XCopyArea(pcp->xDisplay, ps, pd, pgcp->xGC, psx, psy, pw, ph, pdx, pdy);
  return FF_Ok;
}

/*
 * pxCopyPlane(+Connection, +Src, +Dest, +GC, +SrcX, +SrcY, +Width, +Height,
 *	+DestX, +DestY, +Plane, 0)
 *
 *	integer: Connection, Src, Dest, GC, SrcX, SrcY, Width, Height, DestX,
 *		DestY, Plane
 */
FFInteger
pxCopyPlane(pc, ps, pd, pgc, psx, psy, pw, ph, pdx, pdy, pp)
     FFInteger pc, ps, pd, pgc, psx, psy, pw, ph, pdx, pdy, pp;
{
  PxConnection *pcp;
  PxGC *pgcp;

  PX_ErrorInit("xCopyPlane/11");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp))
    PX_Error(no_such_gc);

  XCopyPlane(pcp->xDisplay, ps, pd, pgcp->xGC, psx, psy, pw, ph, pdx, pdy, pp);
  return FF_Ok;
}

/*
 * pxDrawPoints(+Connection, +Drawable, +GC, +Relative, 0)
 *	integer: Connection, Drawable, GC, Relative
 */
FFInteger
pxDrawPoints(pc, pd, pgc, pr)
     FFInteger pc, pd, pgc, pr;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int npoints = pxElements >> 1;

  PX_ErrorInit("xDrawPoints/5");

  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (npoints)
    XDrawPoints(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, npoints, pr);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxDrawLines(+Connection, +Drawable, +GC, +Relative, 0)
 *	integer: Connection, Drawable, GC, Relative
 */
FFInteger
pxDrawLines(pc, pd, pgc, pr)
     FFInteger pc, pd, pgc, pr;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int npoints = pxElements >> 1;

  PX_ErrorInit("xDrawLines/5");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (npoints)
    XDrawLines(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, npoints, pr);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxDrawSegments(+Connection, +Drawable, +GC, 0)
 *	integer: Connection, Drawable, GC
 */
FFInteger
pxDrawSegments(pc, pd, pgc)
     FFInteger pc, pd, pgc;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int nsegments = pxElements >> 2;
  
  PX_ErrorInit("xDrawSegments/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }
  
  if (nsegments)
    XDrawSegments(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, nsegments);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxDrawRectangles(+Connection, +Drawable, +GC, 0)
 *	integer: Connection, Drawble, GC
 */
FFInteger
pxDrawRectangles(pc, pd, pgc)
     FFInteger pc, pd, pgc;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int nrectangles = pxElements >> 2;

  PX_ErrorInit("xDrawRectangles/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (nrectangles)
    XDrawRectangles(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, nrectangles);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxDrawArcs(+Connection, +Drawable, +GC, 0)
 *	integer: Connection, Drawable, GC
 */
FFInteger
pxDrawArcs(pc, pd, pgc)
     FFInteger pc, pd, pgc;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int narcs = pxElements / 6;

  PX_ErrorInit("xDrawArcs/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (narcs)
    XDrawArcs(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, narcs);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxFillRectangles(+Connection, +Drawable, +GC, 0)
 *	integer: Connection, Drawable, GC
 */
FFInteger
pxFillRectangles(pc, pd, pgc)
     FFInteger pc, pd, pgc;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int nrectangles = pxElements >> 2;

  PX_ErrorInit("xFillRectangles/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (nrectangles)
    XFillRectangles(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, nrectangles);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxFillPolygon(+Connection, +Drawable, +GC, +Shape, +Relative, 0)
 *	integer: Connection, Drawable, GC, Shape, Relative
 */
FFInteger
pxFillPolygon(pc, pd, pgc, ps, pr)
     FFInteger pc, pd, pgc, ps, pr;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int npoints = pxElements >> 1;

  PX_ErrorInit("xFillPolygon/6");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (npoints)
    XFillPolygon(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, npoints, ps, pr);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxFillArcs(+Connection, +Drawable, +GC, 0)
 *	integer: Connection, Drawable, GC
 */
FFInteger
pxFillArcs(pc, pd, pgc)
     FFInteger pc, pd, pgc;
{
  PxConnection *pcp;
  PxGC *pgcp;
  int narcs = pxElements / 6;

  PX_ErrorInit("xFillArcs/4");
  
  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();
  if (DLLookup(pxGCList, (int)pgc, (DLHeader **)&pgcp)) {
    (void)PXVectorFree();
    PX_Error(no_such_gc);
  }

  if (narcs)
    XFillArcs(pcp->xDisplay, pd, pgcp->xGC, pxMallocBlock, narcs);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * eof
 */
