/*
 * Copyright (C) 1990 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * cursor.c
 *
 * pxCreateFontCursor
 * pxCreateGlyphCursor
 * pxCreatePixmapCursor
 *
 * pxDestroyCursor
 * pxRecolorCursor
 */

#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"

/*
 * pxCreateFontCursor(+Connection, +Shape, -Cursor, 0)
 *	integer: Connection, Shape, Cursor
 */
FFInteger
pxCreateFontCursor(pc, ps, pcur)
     FFInteger pc, ps, *pcur;
{
  PxConnection *pcp;
  
  PX_ErrorInit("xCreateFontCursor/3");
  *pcur = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  *pcur = XCreateFontCursor(pcp->xDisplay, ps);
  return FF_Ok;
}

/*
 * pxCreateGlyphCursor(+Connection, +SrcFont, +MaskFont, +SrcChar, +MaskChar,
 * 	+ForeRed, +ForeGreen, +ForeBlue, +BackRed, +BackGreen, +BackBlue,
 *	-Cursor, 0)
 *
 *	integer: Connection, SrcFont, MaskFont, SrcChar, MaskChar, ForeRed,
 *		ForeGreen, ForeBlue, BackRed, BackGreen, BackBlue, Cursor
 */
FFInteger
pxCreateGlyphCursor(pc, psf, pmf, psc, pmc, pfr, pfg, pfb, pbr, pbg, pbb, pcur)
     FFInteger pc, psf, pmf, psc, pmc, pfr, pfg, pfb, pbr, pbg, pbb, *pcur;
{
  PxConnection *pcp;
  XColor fore, back;
  
  PX_ErrorInit("xCreateGlyphCursor/8");
  *pcur = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  fore.red = (unsigned short)pfr;
  fore.green = (unsigned short)pfg;
  fore.blue = (unsigned short)pfb;
  back.red = (unsigned short)pbr;
  back.green = (unsigned short)pbg;
  back.blue = (unsigned short)pbb;
  *pcur = XCreateGlyphCursor(pcp->xDisplay, psf, pmf, psc, pmc, &fore, &back);
  return FF_Ok;
}

/*
 * pxCreatePixmapCursor(+Connection, +Source, +Mask, +ForeRed, +ForeGreen,
 *	+ForeBlue, +BackRed, +BackGreen, +BackBlue, +X, +Y, -Cursor, 0)
 *
 *	integer: Connection, Source, Mask, ForeRed, ForeGreen, ForeBlue,
 *		BackRed, BackGreen, BackBlue, X, Y, Cursor
 */
FFInteger
pxCreatePixmapCursor(pc, ps, pm, pfr, pfg, pfb, pbr, pbg, pbb, px, py, pcur)
     FFInteger pc, ps, pm, pfr, pfg, pfb, pbr, pbg, pbb, px, py, *pcur;
{
  PxConnection *pcp;
  XColor fore, back;

  PX_ErrorInit("CreatePixmapCursor/8");
  *pcur = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  fore.red = (unsigned short)pfr;
  fore.green = (unsigned short)pfg;
  fore.blue = (unsigned short)pfb;
  back.red = (unsigned short)pbr;
  back.green = (unsigned short)pbg;
  back.blue = (unsigned short)pbb;
  *pcur = XCreatePixmapCursor(pcp->xDisplay, ps, pm, &fore, &back, px, py);
  return FF_Ok;
}

/*
 * pxDestroyCursor(+Connection, +Cursor, 0)
 *	integer: Connection, Cursor
 */
FFInteger
pxDestroyCursor(pc, pcur)
     FFInteger pc, pcur;
{
  PxConnection *pcp;
  
  PX_ErrorInit("xDestroyCursor/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XFreeCursor(pcp->xDisplay, pcur);
  return FF_Ok;
}

/*
 * pxRecolorCursor(+Connection, +Cursor, +ForeRed, +ForeGreen, +ForeBlue,
 *	+BackRed, +BackGreen, +BackBlue, 0)
 *
 *	integer: Connection, Cursor, ForeRed, ForeGreen, ForeBlue, BackRed,
 *		BackGreen, BackBlue
 */
FFInteger
pxRecolorCursor(pc, pcur, pfr, pfg, pfb, pbr, pbg, pbb)
     FFInteger pc, pcur, pfr, pfg, pfb, pbr, pbg, pbb;
{
  PxConnection *pcp;
  XColor fore, back;
  
  PX_ErrorInit("xRecolorCursor/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  fore.red = (unsigned short)pfr;
  fore.green = (unsigned short)pfg;
  fore.blue = (unsigned short)pfb;
  back.red = (unsigned short)pbr;
  back.green = (unsigned short)pbg;
  back.blue = (unsigned short)pbb;
  XRecolorCursor(pcp->xDisplay, pcur, &fore, &back);
  return FF_Ok;
}

/*
 * eof
 */

