/*
 * Copyright (C) 1990 by Ted Kim.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * conn.h - shadow Xlib structures, etc.
 */

#ifdef _XLIB_H_			/* Xlib loaded */

typedef struct _PxImage {
  struct _PxImage *next;
  int des;
  XImage *xImage;
} PxImage;

typedef struct _PxGC {
  struct _PxGC *next;
  int des;
  int conn;
  GC xGC;
} PxGC;

typedef struct _PxVisual {
  struct _PxVisual *next;
  int des;
  Visual *xVisual;
} PxVisual;

typedef struct _PxDepthVisual {
  struct _PxDepthVisual *next;
  int des;
  int global;
} PxDepthVisual;

typedef struct _PxDepth {
  struct _PxDepth *next;
  int des;
  Depth *xDepth;
  DL visuals;
} PxDepth;

typedef struct _PxScreenDepth {
  struct _PxScreenDepth *next;
  int des;
  int global;
} PxScreenDepth;

typedef struct _PxScreen {
  struct _PxScreen *next;
  int des;
  Screen *xScreen;
  int connection;
  DL depths;
  int root_visual;
  int default_gc;
} PxScreen;

typedef struct _PxConnectionScreen {
  struct _PxConnectionScreen *next;
  int des;
  int global;
} PxConnectionScreen;

typedef struct _PxFormat {
  struct _PxFormat *next;
  int des;
  ScreenFormat *xFormat;
  int connection;
} PxFormat;

typedef struct _PxConnectionFormat {
  struct _PxConnectionFormat *next;
  int des;
  int global;
} PxConnectionFormat;

typedef struct _PxConnection {
  struct _PxConnection *next;
  int des;
  Display *xDisplay;
  DL screens;
  int default_screen;
  DL formats;
} PxConnection;

#endif _X_LIB_H_

extern DL pxImageList, pxGCList, pxVisualList, pxScreenList, pxFormatList,
  pxConnectionList;

extern PXLookupConnection();

/*
 * eof
 */
