/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * window.c - window functions
 *
 * pxCreateWindow
 * pxDestroyWindow
 * pxDestroySubwindows
 *
 * pxGetWindowAttribute
 * pxSetWindowAttribute
 * pxQueryWindow
 * pxSetWindow
 *
 * pxQueryTree
 * pxTranslateCoordinates
 *
 * pxMapWindow
 * pxMapSubwindows
 * pxUnmapWindow
 * pxUnmapSubwindows
 *
 * pxCirculateSubwindows
 */

#include <stdio.h>
#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"
#include "attrib.h"

/*
 * pxCreateWindow(+Connection, +Parent, +X, +Y, +Width, +Height, +BorderWidth, 
 * 	+Depth, +Class, +Visual, -Window, 0)
 *
 *	integer: Connection, Parent, X, Y, Width, Height, BorderWidth, Depth,
 *		Class, Visual, Window
 */
				/* used by ConfigureWindow */
#define XWC_Changed pxAttribChanged1
#define XWC_Mask pxAttribMask1
#define XWC (pxAttribBuf.pwa.xwc)
				/* used by ChangeWindowAttributes */
#define XSWA_Changed pxAttribChanged2
#define XSWA_Mask pxAttribMask2
#define XSWA (pxAttribBuf.pwa.xswa)

FFInteger
pxCreateWindow(pc, pp, px, py, pwth, ph, pbw, pd, pcl, pv, pw)
     FFInteger pc, pp, px, py, pwth, ph, pbw, pd, pcl, pv, *pw;
{
  PxConnection *pcp; PxVisual *pvp;
  Visual *xvp;

  PX_ErrorInit("xCreateWindow/12");
  *pw = PX_Invalid;

  if (PXLookupConnection(pc, &pcp)) {
    XSWA_Changed = XWC_Changed = False;
    XSWA_Mask = XWC_Mask = 0;
    return FF_Fail;
  }

  if (!pv)
    xvp = NULL;			/* CopyFromParent */
  else {
    if (DLLookup(pxVisualList, (int)pv, (DLHeader **)&pvp)) {
      XSWA_Changed = XWC_Changed = False;
      XSWA_Mask = XWC_Mask = 0;
      PX_Error(no_such_visual);
    }
    xvp = pvp->xVisual;
  }

  if (XSWA_Changed) {
    *pw = XCreateWindow(pcp->xDisplay, pp, px, py, pwth, ph, pbw, pd, pcl, xvp,
			XSWA_Mask, &XSWA);
    XSWA_Changed = False;
    XSWA_Mask = 0;
  }
  else 
    *pw = XCreateWindow(pcp->xDisplay, pp, px, py, pwth, ph, pbw, pd, pcl, xvp,
			0, (XSetWindowAttributes *)NULL);

  if (XWC_Changed) {
    XConfigureWindow(pcp->xDisplay, *pw, XWC_Mask, &XWC);
    XWC_Changed = False;
    XWC_Mask = 0;
  }
  return FF_Ok;
}

/* 
 * pxDestroyWindow(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxDestroyWindow(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xDestroyWindow/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XDestroyWindow(pcp->xDisplay, pw);
  return FF_Ok;
}

/* 
 * pxDestroySubwindows(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxDestroySubwindows(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xDestroySubwindows/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XDestroySubwindows(pcp->xDisplay, pw);
  return FF_Ok;
}

/*
 * pxGetWindowAttribute(+Attribute, -Value, 0)
 *	integer: Attribute, Value
 */

#define XWA (pxAttribBuf.xwa)

#define PX_GetAttribute(NAME, MEMBER) \
  case NAME: *pv = XWA.MEMBER; \
             break

FFInteger
pxGetWindowAttribute(pa, pv)
     FFInteger pa, *pv;
{
  *pv = PX_Invalid;

  switch (pa) {
				/* GetGeometry */
    PX_GetAttribute(0, x);	
    PX_GetAttribute(1, y);
    PX_GetAttribute(2, width);
    PX_GetAttribute(3, height);
    PX_GetAttribute(4, border_width);
    PX_GetAttribute(5, depth);
    PX_GetAttribute(6, root);
				/* GetWindowAttributes */
    case 7: *pv = (int)XWA.screen;
             break;
    case 8: *pv = (int)XWA.visual;
            break;
    PX_GetAttribute(9, class);
    PX_GetAttribute(10, all_event_masks);
    PX_GetAttribute(11, bit_gravity);
    PX_GetAttribute(12, win_gravity);
    PX_GetAttribute(13, backing_store);
    PX_GetAttribute(14, backing_planes);
    PX_GetAttribute(15, backing_pixel);
    PX_GetAttribute(16, override_redirect);
    PX_GetAttribute(17, save_under);
    PX_GetAttribute(18, your_event_mask);
    PX_GetAttribute(19, do_not_propagate_mask);
    PX_GetAttribute(20, colormap);
    PX_GetAttribute(21, map_installed);
    PX_GetAttribute(22, map_state);
				/* ErrorInit in pxQueryWindow */
    default: PX_Error(unknown_attribute); 
  }

  return FF_Ok;
}

/*
 * pxSetWindowAttribute(+Attribute, +Value, 0)
 *	integer: Attribute, Value
 */

#define PX_SetConfigure(A, MEM, BIT) \
   case A: XWC.MEM = pv; \
           XWC_Mask |= BIT; \
           break

#define PX_SetAttribute(A, MEM, BIT) \
   case A: XSWA.MEM = pv; \
           XSWA_Mask |= BIT; \
           break

FFInteger
pxSetWindowAttribute(pa, pv)
     FFInteger pa, pv;
{
  PX_ErrorInit("xSetWindow/3");	

  switch (pa) {
				/* ConfigureWindow */
    PX_SetConfigure(0, x, CWX);
    PX_SetConfigure(1, y, CWY);
    PX_SetConfigure(2, width, CWWidth);
    PX_SetConfigure(3, height, CWHeight);
    PX_SetConfigure(4, border_width, CWBorderWidth);
    PX_SetConfigure(23, sibling, CWSibling);
    PX_SetConfigure(24, stack_mode, CWStackMode);
				/* ChangeWindowAttributes */
    PX_SetAttribute(25, background_pixmap, CWBackPixmap);
    PX_SetAttribute(26, background_pixel, CWBackPixel);
    PX_SetAttribute(27, border_pixmap, CWBorderPixmap);
    PX_SetAttribute(28, border_pixel, CWBorderPixel);
    PX_SetAttribute(11, bit_gravity, CWBitGravity);
    PX_SetAttribute(12, win_gravity, CWWinGravity);
    PX_SetAttribute(13, backing_store, CWBackingStore);
    PX_SetAttribute(14, backing_planes, CWBackingPlanes);
    PX_SetAttribute(15, backing_pixel, CWBackingPixel);
    PX_SetAttribute(16, override_redirect, CWOverrideRedirect);
    PX_SetAttribute(17, save_under, CWSaveUnder);
    PX_SetAttribute(18, event_mask, CWEventMask);
    PX_SetAttribute(19, do_not_propagate_mask, CWDontPropagate);
    PX_SetAttribute(20, colormap, CWColormap);
    PX_SetAttribute(29, cursor, CWCursor);
    default: PX_Error(unknown_attribute);
  }

  if (pa < 7)
    XWC_Changed = True;
  else
    XSWA_Changed = True;
  return FF_Ok;
}

/*
 * pxQueryWindow(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxQueryWindow(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;
  DLHeader *dlhp;

  PX_ErrorInit("xQueryWindow/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XGetWindowAttributes(pcp->xDisplay, pw, &XWA))
    PX_Error(no_such_window);

  if (DLFind(pxScreenList, (char *)(XWA.screen), &dlhp))
    PX_Error(no_matching_screen);
  XWA.screen = (Screen *)(dlhp->des);
  if (DLFind(pxVisualList, (char *)(XWA.visual), &dlhp))
    PX_Error("no matching visual");
  XWA.visual = (Visual *)(dlhp->des);
  return FF_Ok;
}

/*
 * pxSetWindow(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxSetWindow(pc, pw)
   FFInteger pc, pw;
{
  PxConnection *pcp;

  /* need to error init here in case pxSetWindowAttribute is not called */
  PX_ErrorInit("xSetWindow/3");

  if (PXLookupConnection(pc, &pcp)) {
    XSWA_Changed = XWC_Changed = False;
    XSWA_Mask = XWC_Mask = 0;
    return FF_Fail;
  }

  if (XSWA_Changed) {
    XChangeWindowAttributes(pcp->xDisplay, pw, XSWA_Mask, &XSWA);
    XSWA_Changed = False;
    XSWA_Mask = 0;
  }

  if (XWC_Changed) {
    XConfigureWindow(pcp->xDisplay, pw, XWC_Mask, &XWC);
    XWC_Changed = False;
    XWC_Mask = 0;
  }
  return FF_Ok;
}

/*
 * pxQueryTree(+Connection, +Window, -Root, -Parent, -Next, 0)
 *	integer: Connection, Window, Root, Parent, Next
 */
FFInteger
pxQueryTree(pc, pw, pr, pp, pn)
     FFInteger pc, pw, *pr, *pp, *pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xQueryTree/5");
  *pr = *pp = *pn = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XQueryTree(pcp->xDisplay, pw, pr, pp, &pxVector32, &pxElements))
    PX_Error(no_such_window);

  if (pxElements) {
    pxMallocBlock = (char *)pxVector32;
    pxType = PX_Vector32;
    *pn = PX_Cont;
  } else 
    *pn = PX_End;
  return FF_Ok;
}

/*
 * pxTranslateCoordinates(+Connection, +Source, +Dest, +SrcX, +SrcY, -DestX,
 *	-DestY, -Child, 0)
 *
 *	integer: Connection, Source, Dest, SrcX, SrcY, DestX, DestY, Child
 */
FFInteger
pxTranslateCoordinates(pc, ps, pd, psx, psy, pdx, pdy, pch)
     FFInteger pc, ps, pd, psx, psy, *pdx, *pdy, *pch;
{
  PxConnection *pcp;

  PX_ErrorInit("xTranslateCoordinates/8");
  *pdx = *pdy = *pch = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if (!XTranslateCoordinates(pcp->xDisplay, ps, pd, psx, psy, pdx, pdy, pch))
    return FF_Fail;
  return FF_Ok;
}

/*
 * pxMapWindow(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxMapWindow(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xMapWindow/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XMapWindow(pcp->xDisplay, pw);
  return FF_Ok;
}

/*
 * pxMapSubwindows(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxMapSubwindows(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xMapSubwindows/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XMapSubwindows(pcp->xDisplay, pw);
  return FF_Ok;
}

/*
 * pxUnmapWindow(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxUnmapWindow(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xUnmapWindow/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUnmapWindow(pcp->xDisplay, pw);
  return FF_Ok;
}

/*
 * pxUnmapSubwindows(+Connection, +Window, 0)
 *	integer: Connection, Window
 */
FFInteger
pxUnmapSubwindows(pc, pw)
     FFInteger pc, pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xUnmapSubwindows/2");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XUnmapSubwindows(pcp->xDisplay, pw);
  return FF_Ok;
}

/*
 * pxCirculateSubwindows(+Connection, +Window, +LowerHighest, 0)
 *	integer: Connection, Window, LowerHighest
 */
FFInteger
pxCirculateSubwindows(pc, pw, plh)
     FFInteger pc, pw, plh;
{
  PxConnection *pcp;

  PX_ErrorInit("xCirculateSubwindows/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XCirculateSubwindows(pcp->xDisplay, pw, plh);
  return FF_Ok;
}

/*
 * eof
 */
