/*
 * Copyright (C) 1989 by The Regents of the University of California.
 *
 * This software work was developed at UCLA with support in part from
 * DARPA Contract F29601-87-C-0072.
 */

/*
 * prop.c - atoms, properties, selections
 *
 * pxInternAtom
 * pxGetAtomName
 *
 * pxWindowProperties
 * pxGetProperty
 * pxSetProperty
 * pxDeleteProperty
 * pxRotateProperties
 *
 * pxGetSelectionOwner
 * pxSetSelectionOwner
 * pxConvertSelection
 */

#include <stdio.h>
#include <X11/Xlib.h>

#include "dl.h"
#include "conn.h"
#include "ff.h"

/*
 * pxInternAtom(+Connection, +XAtomName, +DontCreate, -XAtom, 0)
 *	integer: Connection, DontCreate, XAtom
 *	string: XAtomName
 */
FFInteger
pxInternAtom(pc, pxan, pdc, pxa)
     FFInteger pc, pdc, *pxa;
     FFString pxan;
{
  PxConnection *pcp;

  if (pdc)
    PX_ErrorInit("xAtomExists/3");
  else
    PX_ErrorInit("xAtom/3");
  *pxa = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if ((*pxa = XInternAtom(pcp->xDisplay, pxan, pdc)) == None)
    return FF_Fail;
  return FF_Ok;
}

/*
 * pxGetAtomName(+Connection, +XAtom, -XAtomName, 0)
 *	integer: Connection, XAtom
 *	string: XAtomName
 */
FFInteger
pxGetAtomName(pc, pxa, pxan)
     FFInteger pc, pxa;
     FFString *pxan;
{
  PxConnection *pcp;

  PX_ErrorInit("xAtom/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;
  *pxan = pxNil;

  if ((*pxan = XGetAtomName(pcp->xDisplay, pxa)) == NULL)
    return FF_Fail;
  pxMallocBlock = *pxan;	/* for suceeding pxVectorXFree */
  return FF_Ok;
}

/*
 * pxWindowProperties(+Connection, +Window, -Next, 0)
 *	integer: Connection, Window, Next
 */
FFInteger
pxWindowProperties(pc, pw, pn)
     FFInteger pc, pw, *pn;
{
  PxConnection *pcp;

  PX_ErrorInit("xWindowProperties/3");
  *pn = PX_Invalid;
  
  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if ((pxVector32 = (PxVector32 *)XListProperties(pcp->xDisplay, pw,
						  &pxElements)) == NULL) 
    PX_Error(no_such_window);


  if (pxElements) {
    pxMallocBlock = (char *)pxVector32;
    pxType = PX_Vector32;
    *pn = PX_Cont;
  } else 
    *pn = PX_End;
  return FF_Ok;
}

/*
 * pxGetProperty(+Connection, +Window, +Property, +Offset, +Length,
 *	+DeleteIfEnd, +RequestedType, +WantAtom, -Type, -Remaining, -Format,
 *	-String, -Next, 0).
 *
 *	integer: Connection, Window, Property, Offset, Length, DeleteIfEnd,
 *		RequestedType, WantAtom, Type, Remaining, Format, Next
 *	string: String
 */
FFInteger
pxGetProperty(pc, pw, pp, po, pl, pdie, prt, pwa, pt, pr, pf, ps, pn)
     FFInteger pc, pw, pp, po, pl, pdie, prt, pwa, *pt, *pr, *pf, *pn;
     FFString *ps;
{
  int type, format, elements, bytes_left;
  char *value;
  PxConnection *pcp;

  PX_ErrorInit("xGetProperty/11");
  *pt = *pr = *pf = *pn = PX_Invalid;
  *ps = pxNil;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  /* has wierd return values */
  if (XGetWindowProperty(pcp->xDisplay, pw, pp,
			 ((po + 3) >> 2), ((pl + 3) >> 2), pdie, prt,
			 &type, &format, &elements, &bytes_left, &value) !=
      Success)
    return FF_Fail;

  if (type == None)		/* no such property */
    PX_Error("no such property");
  *pt = type;

  *pr = (format == PX_Vector8) ? bytes_left :
    ((format == PX_Vector16) ? ((bytes_left + 1) >> 1) :
     ((bytes_left + 3) >> 2));

  if (pwa && ((!prt) || (prt == type)) && (format == PX_Vector8)) {
    *pf = PX_String;
    *ps = value;
    *pn = PX_End;

    pxMallocBlock = value;	/* to be used by pxVectorXFree */
    return FF_Ok;
  }    

  *pf = format;
  *ps = pxNil;			/* need to fill in something */
  
  if (!elements) {
    *pn = PX_End;
    return FF_Ok;
  }

  pxMallocBlock = value;
  switch (format) {
  case PX_Vector8:
    pxVector8 = value;
    break;

  case PX_Vector16:
    pxVector16 = (PxVector16 *)value;
    break;

  case PX_Vector32:
    pxVector32 = (PxVector32 *)value;
    break;
  }
  pxElements = elements;
  pxType = format;
  *pn = ((format == PX_Vector32) && ((*pxVector32) & pxPrecisionMask)) ?
    PX_SplitVector : PX_Cont;
  return FF_Ok;
}

/*
 * pxSetProperty(+Connection, +Window, +Property, +Type, +Mode, +Format, +Data,
 *	0)
 *
 *	integer: Connection, Window, Property, Type, Mode, Format
 *	string: Data
 */
FFInteger
pxSetProperty(pc, pw, pp, pt, pm, pf, pd)
     FFInteger pc, pw, pp, pt, pm, pf;
     FFString pd;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetProperty/6");

  if (pf == PX_String) {
    if (PXLookupConnection(pc, &pcp))
      return FF_Fail;
				/* don't add one for null terminator! */
    XChangeProperty(pcp->xDisplay, pw, pp, pt, 8, pm, pd, strlen(pd));
  } else {
    if (PXLookupConnection(pc, &pcp))
      return PXVectorFree();
    XChangeProperty(pcp->xDisplay, pw, pp, pt, pxType, pm, pxMallocBlock, 
		    pxElements);
    (void)PXVectorFree();
  }
  return FF_Ok;
}

/*
 * pxDeleteProperty(+Connection, +Window, +Property, 0)
 *	integer: Connection, Window, Property
 */
FFInteger
pxDeleteProperty(pc, pw, pp)
     FFInteger pc, pw, pp;
{
  PxConnection *pcp;

  PX_ErrorInit("xDeleteProperty/3");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XDeleteProperty(pcp->xDisplay, pw, pp);
  return FF_Ok;
}

/*
 * pxRotateProperties(+Connection, +Window, +Positions, 0)
 *	integer: Connection, Window, Positions
 */
FFInteger
pxRotateProperties(pc, pw, pp)
     FFInteger pc, pw, pp;
{
  PxConnection *pcp;

  PX_ErrorInit("xRotateProperties/4");

  if (PXLookupConnection(pc, &pcp))
    return PXVectorFree();

  XRotateWindowProperties(pcp->xDisplay, pw, pxMallocBlock, pxElements, pp);
  (void)PXVectorFree();
  return FF_Ok;
}

/*
 * pxGetSelectionOwner(+Connection, +Selection, -Window, 0)
 *	integer: Connection, Selection, Window
 */
FFInteger
pxGetSelectionOwner(pc, ps, pw)
     FFInteger pc, ps, *pw;
{
  PxConnection *pcp;

  PX_ErrorInit("xGetSelectionOwner/3");
  *pw = PX_Invalid;

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  if ((*pw = XGetSelectionOwner(pcp->xDisplay, ps)) == None)
    return FF_Fail;
  return FF_Ok;
}

/*
 * pxSetSelectionOwner(+Connection, +Selection, +Owner, 0)
 *	integer: Connection, Selection, Owner
 */
FFInteger
pxSetSelectionOwner(pc, ps, po)
     FFInteger pc, ps, po;
{
  PxConnection *pcp;

  PX_ErrorInit("xSetSelectionOwner/4");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XSetSelectionOwner(pcp->xDisplay, ps, po, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * pxConvertSelection(+Connection, +Selection, +DestType, +DestProperty,
 *	+DestWindow, 0)
 *
 *	integer: Connection, Selection, DestType, DestProperty, DestWindow
 */
FFInteger
pxConvertSelection(pc, ps, pdt, pdp, pdw)
     FFInteger pc, ps, pdt, pdp, pdw;
{
  PxConnection *pcp;

  PX_ErrorInit("xConvertSelection/6");

  if (PXLookupConnection(pc, &pcp))
    return FF_Fail;

  XConvertSelection(pcp->xDisplay, ps, pdt, pdp, pdw, pxUnsignedArg1);
  return FF_Ok;
}

/*
 * eof
 */
