
:- module(select,[]).
:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

:- ytoolkit:super_class(select:scrollwindow).


default(item_height,20).
default(list,[]).
default(select,'$none').

sub_widgets(N) :- make_items(N).

make_items(N) :-
	get_attr(N,back,B),
	get_attr(N,item_height,IH),
	get_attr(N,list,L),
	mk_items(L,N,B,1,IH,H,0,W),
	(H>0, W>0 ->
	    change_widget(_,[height=H,width=W],B);
	    change_widget(_,[height=1],B)
	).


mk_items([],_,_,H,_,H,W,W).
mk_items([I|R],N,P,Y,IH,H,CW,W) :-
	writebox(I,IW,_),
	(IW > CW -> NW=IW; NW=CW),
	new_widget(item,[
    		parent=P,
		x=0,y=Y,height=IH,
		width=10000,		% infinitely wide
		text=I,callback=ytoolkit:set_attr(N,selected,I)
	],_),
	NY is Y+IH,
	mk_items(R,N,P,NY,IH,H,NW,W).

change_attr(list,Name,_) :-
	get_attr(Name,back,B),
	(current_widget(item,[parent=B],W),
	kill_widget(_,[],W), fail; true),
	make_items(Name).
change_attr(item_height,Name,_) :-
	change_attr(list,Name,_).

	    
