/************************************************************************
*									*
*		Yap Toolkit standart widgets		Jan 90		*
*									*
*							Ze Paulo Leal	*
*									*
*************************************************************************
*									*
*	widget name	: scrollwindow					*
*									*
*	features	 - 						*
*									*
*	creation date	: 90/02/05					*
*	last change	: 90/04/09					*
*									*
*************************************************************************
*									*
*	use		: new_widget(					*
*			   scrollwindow(X,Y,W,H,T,B),Parent,Name))	*
*		where	:						*
*				X,Y,W,H		Scrool window rect	*
*				T		Type of scrool {x,y,xy}	*
*				B		background window name	*
*									*
************************************************************************/


:- module(scrollwindow,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

default(border,1).
default(type,sy).

behavior(configureNotify(_,_,_,_,_),Name) :-
	get_attr(Name,back,B),
	send_event(createNotify,B).

sub_widgets(N) :-
	get_attr(N,type,T),
	set_sb(T,N).

set_sb(sy,N) :-
	new_widget(no_class,[
		parent=N
		,x=16
		,y= 1
		,width= N~width-17
		,height= N~height-2
	],Front),
	(get_attr(N,back,B) -> true;  true),
	new_widget(scrollback,[
		parent=Front
		,x= -1
		,y= -1
	    	,width=Front~width
		],B),
	set_attr(B,front,Front),
	set_attr(N,back,B),
	new_widget(scrollbar_y,[
		parent=N
		,x= -1
		,y= -1	
		,width=15
		,height=N~height
		,callback(Pos,Part,Total)=move(py,B,Pos,Part,Total)
	],SB),
	set_attr(B,sby,SB).
set_sb(sx,N) :-
	new_widget(no_class,[
		parent=N
		,x= 1
		,y= 1
		,width= N~width-2
		,height= N~height-16
	],Front),
	(get_attr(N,back,B) -> true;  true),
	new_widget(scrollback,[
		parent=Front
		,x= -1
		,y= -1
	    	,height=Front~height
		],B),
	set_attr(B,front,Front),
	set_attr(N,back,B),

	new_widget(scrollbar_x,[
		parent=N
		,x= -1
		,y=N~height-16
		,width=N~width
		,height=15
		,callback(Pos,Part,Total)=move(px,B,Pos,Part,Total)
	],SB),
	set_attr(B,sbx,SB).
set_sb(sxy,N) :-
	new_widget(no_class,[
		parent=N
		,x=17
		,y= 1
		,width= N~width-20
		,height= N~height-20
		,border=1
	],Front),
	(get_attr(N,back,B) -> true;  true),
	current_window(Front,[width=WF,height=HF]),
	new_widget(scrollback,[
		parent=Front
		,x= -1
		,y= -1
	        ,width=WF
	        ,height=HF
		],B),
	set_attr(B,front,Front),
	set_attr(N,back,B),

	new_widget(scrollbar_y,[
		parent=N
		,x= -1
		,y= -1
		,width=15
		,height=N~height-16
		,border=1
		,callback(Pos,Part,Total)=move(py,B,Pos,Part,Total)
	],SBY),
	set_attr(B,sby,SBY),
	new_widget(scrollbar_x,[
		parent=N
		,x=15	
		,y=N~height-16
		,width=N~width-15
		,height=15
		,border=1
		,callback(Pos,Part,Total)=move(px,B,Pos,Part,Total)
	],SBX),
	set_attr(B,sbx,SBX).
%	draw(N,using([Y is ],rectangle(1,1,12,12))),
%	draw(N,using([],rectangle(1,1,11,11))).


move(px,B,Pos,_Part,Total) :-
	get_window_attr(B,width,W),
	X is integer(-Pos/Total*W),
	window(B,[x=X]).
move(py,B,Pos,_Part,Total) :-
	get_window_attr(B,height,H),
	Y is integer(-Pos/Total*H),
	window(B,[y=Y]).



