


:- module(popup,[menu_bar/4,change_menu/2,toggle_menu_item/2]).


:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).
:- ensure_loaded(library('behaviors/pressable')).

default(width,100).
default(height,25).
default(width,100).
default(font,Font) :- popup_font(Font).
default(border,1).
default(is_hilite,false).
default(sep,4).
default(itemFont,Font) :-popup_font(Font).
default(text,'').


popup_font(Font) :-
	current_font([
			'9x15bold',
			'-*-helvetica-bold-r-*-*-14-*-*-*-*-*-*-*',
			'*bold',
			'*bold*'
		],Font).


layout :-
	get_attr(text,Text),
	writebox(Text,W,H),
	draw(writeterm((width-W)/2,(height+H)/2,Text)).

behavior(buttonPress(_,_,_),Name) :- 
	\+ get_attr(Name,open,true),
	get_attr(Name,menu,Menu), \+ atomic(Menu),
	get_attr(sep,Sep),
	set_attr(Name,open,true),
	draw_inv_label(Name),
	(get_attr(Name,list,List) -> 
		get_attr(Name,shadow,Shadow),
		window(Shadow,[]),	map,
		window(List,[]), 	map,
		gc(List,[]), 		draw_list(Menu,Sep)
	;
		current_window(Name,[parent=P,x=X,y=Y,height=H,border=B]),
		get_attr(Name,itemFont,IF),
		LY is Y+H+2*B+1,
		list_size(Menu,Sep,IW,IH,LH),
		new_widget(no_class,[
			parent=P,
			x=X+4,
			y=LY+4,
			width=IW,
			height=LH
			],
		Shadow),		
		new_widget(no_class,[
			parent=P,
			x=X,
			y=LY,
			width=IW,
			height=LH,
			border=1,
			font=IF
			],
		List),
		draw_list(Menu,Sep),
		set_attr(Name,info,info(H,IH,IW,Sep)),
		dup_gc(inv),
		gc(inv,[foreground=white,background=black]),
		window(Shadow,[bkg_pixel=black]),
		set_attr(Name,shadow,Shadow),
		set_attr(Name,list,List)).
behavior(motionNotify(X,Y),Name) :- 
	get_attr(Name,open,true),
	get_attr(Name,list,List),
	window(List,[]),
	get_attr(Name,info,info(H,IH,IW,Sep)),
	get_attr(Name,menu,Menu),
	I is (Y-H)//IH,
	((X>0,X<IW) -> 	
		(get_attr(Name,hilite,OI) ->
			(OI == I -> 
				true
			;
				set_attr(Name,hilite,I),
				draw_item(List,Menu,Sep,OI,IW,IH,true),
				(draw_item(List,Menu,Sep,I,IW,IH,inv) -> true;
					unset_attr(Name,hilite)
				)
			)
		; 
			draw_item(List,Menu,Sep,I,IW,IH,inv),
			set_attr(Name,hilite,I)
		)
	;
		get_attr(Name,hilite,OI),
		draw_item(List,Menu,Sep,OI,IW,IH,true),
		unset_attr(Name,hilite)
	).
behavior(buttonRelease(_,_,_),Name) :- 
	get_attr(Name,open,true),
	get_attr(Name,list,List),
	window(List,[]),
	(get_attr(Name,hilite,I) ->
		get_attr(Name,info,info(_H,IH,IW,Sep)),
		get_attr(Name,menu,Menu),
		draw_item(List,Menu,Sep,I,IW,IH,true),	
		draw_item(List,Menu,Sep,I,IW,IH,inv),
		draw_item(List,Menu,Sep,I,IW,IH,true),
		unset_attr(Name,hilite),
		A is I+1, 	arg(A,Menu,item(_,Callback))
	;
		Callback=true
	),
	unmap,
	get_attr(Name,shadow,Shadow),	window(Shadow,[]),	
	unmap,
	unset_attr(Name,open),
	event_flush,
	get_attr(Name,source,S),
	(S:Callback, fail; true),
	re_draw_label(Name).

dispatch_all_events :- all(send_events(E,W),events(W,E),L), send_events(L).

send_events([]).
send_events([send_event(E,W)|R]) :-
	send_event(E,W),
	send_events(R).

/* drawing utils */


draw_inv_label(Name) :-
	window(Name,[bkg_pixel=black]), gc(Name,[]),
	dup_gc(copy),
	gc(Name,[foreground=white,background=black]),
	send_event(expose(0),Name).

re_draw_label(Name) :-
	current_window(Name,[]), 
	window(Name,[bkg_pixel=white]),
	gc(copy,[]),
	dup_gc(Name),
	send_event(expose(0),Name).

draw_list(M,Sep) :-
	writebox(6,_,HH), H is HH+Sep,
	M =.. [_F|List],
	put_list(List,Sep,HH,H).

put_list([],_,_,_).
put_list([item(I,_)|R],Sep,P,H) :-
	writeterm(Sep,P,I),
	Q is P+H,
	put_list(R,Sep,Q,H).


draw_item(List,Menu,Sep,UI,IW,IH,Type) :-
	type(Type,List,GC1,GC2),
	P is UI*IH,	gc(GC1,[]),	frectangle(0,P,IW,IH),
	A is UI+1, 	arg(A,Menu,item(Text,_)),
	PT is P+IH-Sep,	gc(GC2,[]),	writeterm(Sep,PT,Text).

type(true,Name,inv,Name).
type(inv,Name,Name,inv).

	

list_size(Menu,Sep,IW,IH,LH) :-
	Menu =.. [_|Args],
	list_size_l(Args,Sep,W,H,LH),
	IH is H+Sep,
	IW is W + 2*Sep.

list_size_l([],_,0,TH,0) :- writebox(6,_,TH).
list_size_l([item(T,_)|R],Sep,W,TH,LH) :-
	writebox(T,TW,TH),
	list_size_l(R,Sep,RIW,TH,RLH),
	LH is TH+RLH+Sep,
	max(TW,RIW,W).

max(A,B,B) :- A < B, !.
max(A,_,A).
	


/* user utils */

menu_bar(List,X,Y,Attr) :-
	(in(font=IF,Attr);default(font,IF)),
	gc(font,[font=IF]),
	my_menu_bar(List,X,[y=Y|Attr]).

my_menu_bar([],_X,_Attr).
my_menu_bar([Label+Menu|R],X,Attr) :-
	writebox(Label,W,_),
	WW is W+10,
	new_widget(popup,[x=X,width=WW,text=Label,menu=Menu|Attr],Label),
	XX is X+WW,
	my_menu_bar(R,XX,Attr).

in(X,[X|_]) :- !.
in(X,[_|R]) :- in(X,R).

change_attr(text,Name,_) :- clear_widget(Name), layout.
change_attr(menu,Name,Menu) :- change_menu(Name,Menu).

change_menu(Name,NewMenu) :-
	set_attr(Name,menu,NewMenu),
	remove(Name,list),
	remove(Name,shadow).

remove(Name,A) :- 
	get_attr(Name,A,WA),
	kill_widget(_,_,WA),
	unset_attr(Name,A).


toggle_menu_item(Name,ItemNumber) :-
	get_attr(Name,menu,Menu),
	arg(ItemNumber,Menu,item(Label,_Call)),
	name(Label,LabelChars),
	toggle(LabelChars,NewLabelChars),	
	name(NewLabel,NewLabelChars),
	Menu =.. [F|Args],
	change_item_list(Args,Label,NewLabel,NewArgs),
	NewMenu =..[F|NewArgs],
	set_attr(Name,menu,NewMenu).

toggle([1|R],[32|R]).
toggle([32|R],[1|R]).

change_item_list([],_Item,_NewItem,[]).
change_item_list([item(Item,Call)|R],Item,NewItem,[item(NewItem,Call)|NR]) :-!,
	change_item_list(R,Item,NewItem,NR).
change_item_list([item(I,Call)|R],Item,NewItem,[item(I,Call)|NR]) :- 
	change_item_list(R,Item,NewItem,NR).


