


:- module(key,[key__shape/1,draw_label/0]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('behaviors/pressable')).

default(type,normal).
default(width,80).
default(height,35).
default(border,1).
default(border_pixel,0).
default(bkg_pixel,0).
default(text,'Ok').
%default(font,'chicago-12').
default(background,0).
default(foreground,1).
default(is_pressed,false).
default(layout,key:layout).


layout :- get_attr(is_pressed,S), get_attr(type,T), key_shape(T,S).

behavior(Event,Window) :- pressable(Event,Window).


key_shape(normal,S) :-  (S=true -> I=1;I=2),
	draw(rectangle(I,0,width-(I+1),height-(I+1))),
	draw(line(0,I,I,0)),draw(line(0,height,I,height-(I+1))),
	draw(line(width-(I+1),height,width,height-(I+1))),
	draw(line(0,I,0,height)),
	draw(line(0,height-1,width-I,height-1)),
	draw_label.

key_shape(box,S) :-  (S=true -> I=1;I=2),
	draw(rectangle(I,0,width-(I+1),height-(I+1))),
	draw(line(0,I,I,0)),draw(line(0,height,I,height-(I+1))),
	draw(line(width-(I+1),height,width,height-(I+1))),
	draw(line(0,I,0,height)),
	draw(line(0,height-1,width-I,height-1)),
	draw_label.

key_shape(old_key,S) :- (S=true -> I=3;I=6),
	draw(rectangle(I,I,width-2*I,height-2*I)),
	draw(line(0,0,I,I)),
	draw(line(width,0,width-I,I)),
	draw(line(0,height,I,height-I)),
	draw(line(width,height,width-I,height-I)),
	draw_label,
	draw(line(I,I/2,width-I,I/2)),
	draw(line(I/2,I,I/2,height-I)).

key_shape(key,S) :- (S=true -> I=3;I=6),
	draw(fpoly([(0+0),(I+I),(width-I)+I,(width+0)])),
	draw(poly([(0+height),(I+(height-I)),(width-I)+(height-I),(width+height)])),
	draw(line(I,I,I,height-I)),
	draw(line(width-I,I,width-I,height-I)),
	draw_label.

draw_label :-
	get_attr(text,Text),
	writebox(Text,W,H),
	draw(writeterm((width-W)/2,(height-H)/2+H,Text)).

