
:- module(help,[]).

:- ensure_loaded(library(edipo)).
:- ensure_loaded(library(ytoolkit)).

default(width,600).

default(BK_A,BK_V) :- (color -> 
		BK_A=bkg_pixel, BK_V='dark khaki'
	;
		BK_A=bkg_pixmap, BK_V=["   #",	" #  ",	"  # ",	"#   "]
	).

sub_widgets(Self) :-
	get_attr(Self,file,F),
	read_text(F,T),
	new_widget(showtext,[
    		parent=Self,
		x=10,
		y=10,
		width=Self~width-20,
		height=Self~height-80|T]
	,_),
	new_widget(button,[
		parent=Self,
		x=(Self~width-100)/2,
		y=Self~height-50,
		width=100,
		text='Dismiss',
		callback=ytoolkit:kill_widget(_,[],Self)
	    ],_).


read_text(File,Text) :-
	see(File),
	get0(C),
	read_line(C,1,Line,D),
	read_text(D,2,[Line],Text),
	seen.

read_text(-1,_,Text,Text) :-!.
read_text(_,N,Diff,Text) :-
	get0(C),
	read_line(C,N,Line,D),
	M is N+1,
	read_text(D,M,[Line|Diff],Text).
	
read_line(C,N,line(N)=Line,D) :- 
	read_line(C,Chars,D),
	name(Line,Chars).

read_line(-1,[],-1) :- !.
read_line(10,[],10) :- !.
read_line(C,[C|R],E) :- get0(D), read_line(D,R,E).
