


:- module(field,[set_field/2,get_field/2]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('behaviors/editable')).

default(height,19).
	%window
default(border,1).
default(cursor,xterm).
	%gc
default(font,Font) :- current_font(['9x15',*],Font).
default(chars,[]).
default(lines,1).


layout.

behavior(Event,Window) :- editable(Event,Window).

current_attr(chars,Name,C) :- get_line(Name,C).

change_attr(chars,Name,C) :- set_line(Name,C), unset_attr(Name,chars).
change_attr(font,Name,_F) :- 
	get_line(Name,C), set_attr(Name,chars,C),
	send_event(createNotify,Name).


/* to be removed */
set_field(A,B) :- set_line(A,B).
get_field(A,B) :- get_line(A,B).
