%-----------------------------------------------------------------------%
%									%
%			       Ytoolkit					%
%									%
%					April 90 Ze' Paulo Leal		%
%									%
%-----------------------------------------------------------------------%
%									%
%	File: 		manip.yap					%
%	Version:	2.0						%
%	Purpose:	widget manipulation preds.			%
%									%
%-----------------------------------------------------------------------%
%									%
%	Last change:	93/05/19					%
%	Bugs & Com.:							%
%									%
%-----------------------------------------------------------------------%


/*----------------------- (sub)window management------------------------------

predicates:
		
new_widget(+Class,?Parent,?Name).
renew_widget(+Class,?Parent,?Name).
current_widget(+Class,?Parent,?Name).
kill_widget(+Class,?Parent,?Name).

sub_widget(A,B).

remove_all_widgets.

bring_widget_front(+Name).
send_widget_back(+Name).

move_widget(+Name,+X,+Y).
resize_widget(+Name,+W,+H).

*/

% ---- select_widget_name ------------------------------
%							|
%
select_widget_name(Root,Name) :-
	(recorded(Root,B,Ref) -> erase(Ref), V is B+1; V=0),
	recorda(Root,V,_),
	name(Root,Label),
	name(V,VL),
	append(Label,[58|VL],NL),
	name(Name,NL).	
%							|
%							|
%-------------------------------------------------------

% ---- set_widget --------------------------------------
%							|
%
set_widget(_,_,Name) :-	current_widget(_,_,Name), !,
	working_envir(Name).
set_widget(Class,Attr,Name) :-
	new_widget(Class,Attr,Name).

%							|
%							|
%-------------------------------------------------------



% ---- manip classes (inherit preds from another module) ---
%							|
%
update_class(Class) :-
	[-Class],
	inherit(Class).

add_class(no_class) :- !.
add_class(Class) :- atomic(Class), !,
	(current_module(Class) -> 
	    otherwise
	;
	    class_file(Class,File),
	    absolute_file_name(File,_),
	    ensure_loaded(File)
	).
add_class([]).
add_class([Class|R]) :- add_class(Class),add_class(R).

class_file(Class,Class).
class_file(Class,library(File)) :-
	name(Class,Chars),
	name(File, [119,105,100,103,101,116,115,47|Chars]). % widgets/<Class>



write_decl(D) :- write((:- multifile D)), write(.), nl.

'$super_class'(Class:Super) :-
	add_class(Super), 
	name(Super,CharsSuper),
	append("/usr/tmp/super_",CharsSuper,CharsFile),
	name(File,CharsFile),
	tell(File),
	write_decl(default/2),
	write_decl(layout/0), 
	write_decl(layout/1),
	write_decl(sub_widgets/1),
	write_decl(behavior/2),
	write_decl(change_attr/3),
	write((default(A,B):-Super:default(A,B))), write(.), nl,
	write((layout:-Super:layout)), write(.), nl,		%OBSOLETE
	write((layout(A):-Super:layout(A))), write(.), nl,
	write((sub_widgets(A):-Super:sub_widgets(A))), write(.), nl,
	write((behavior(A,B):-Super:behavior(A,B))),write(.), nl,
	write((change_attr(A,B,C):-Super:change_attr(A,B,C))), write(.), nl,
	told,
	Class:compile(File),
	!.
'$super_class'(Super) :- !,
	format('[[ytoolkit: cannot set super_class with  "~w" ]]~n',[Super]).
%							|
%							|
%-------------------------------------------------------



% ---- new_widget --------------------------------------
%							|
%
'$new_widget'(Classes,SAttrs,Name) :-
	(SAttrs=Source:NewAttrs -> otherwise; Source=user,NewAttrs=SAttrs),
	'$rename'(Name),
	(
		add_class(Classes),

% set_value('$working_widget',Name), this changes semantics a bit ...
		set_attr(Name,source,Source),
		'$get_defaults'(Classes,Defaults),
		'$parse_attrs'(Defaults,Name,Classes,WA1,GCA1),
		'$parse_attrs'(NewAttrs,Name,Classes,WA2,GCA2),
		append(WA1,WA2,WindowAttrs),
		append(GCA1,GCA2,GCAttrs),
	
		(member(parent=Parent,WindowAttrs), Parent \== [] -> 
		    otherwise 
		; 
						% creating a Top-Levelwindow
format('[[ytoolkit: creating top-level widget ~w from ~w ...',[Name,Classes]),
			 flush_output(user),
			 Parent=[],
			 create_unmapped,
			 window(Name,[]),
			 create_mapped
		),
		recorda(Parent,'$son'(Name),_),

		(window(Name,WindowAttrs) -> true ;
			format('[[ytoolkit: cannot create window with ~w ]]~n',
					[WindowAttrs])
		),
		(gc(Name,GCAttrs)-> true ;
			format('[[ytoolkit: cannot create gc with ~w ]]~n',
					[GCAttrs])
		),
		
		(atomic(Classes), Class=Classes; member(Class,Classes)),
		recorda(Name,'$object'(Class),_),
		try(Class:layout),	
		try(Class:layout(Name)),	
		try(Class:sub_widgets(Name)),
		(Parent=[] -> 
		    format(' done ]]~n',[]),
		    working_window(Name), 
		    map;
		    true
		),	
	fail
	;
	true). /* trying to recover some space */


'$rename'(Name) :- var(Name), !, gen_name(Name).
'$rename'(Name) :-
	current_widget(Class,_,Name), !,
	kill_widget(Class,_,Name).
'$rename'(_Name).

gen_name(Name) :-
	(recorded('$free',Name,Ref) ->
		erase(Ref)
	;
		(get_attr('$$name','$$name',B) -> Name is B+1; Name=0),
		set_attr('$$name','$$name',Name)
	).

	

'$get_defaults'([],[]) :- !.
'$get_defaults'([Class|R],Defaults) :- !,
	'$get_defaults'(Class,DC),
	'$get_defaults'(R,DR),
	append(DC,DR,Defaults).
'$get_defaults'(Class,Defaults) :-
	findall(Attr=Value,Class:default(Attr,Value),Defaults), !.
'$get_defaults'(_Class,[]).


'$parse_attrs'([],_,_,[],[]) :- !. 	% first arg. can be uninst.
'$parse_attrs'([A=E|R],Name,Class,WA,GCA) :-	edipo_attr(Type,A), !,
	'$parse_attrs'(R,Name,Class,RWA,RGCA),
	(config_attr(A) ->
		eval_attr(E,WV,D), 
		yt_coord(WV,V),
		set_depend(D,'$attr_depend'(Type,A,E,V,Name))
	;
		V=E
	),
	'$assign'(Type,A=V,RWA,RGCA,WA,GCA).
'$parse_attrs'([A=V|R],Name,Class,WA,GCA) :- !,
%$parse_attrs([A=E|R],Name,Class,WA,GCA) :- !,
%	eval_attr(E,V,D), set_depend(D,$attr_depend(other,A,E,V,Name)),
%	(get_attr(Name,A,_) -> otherwise; set_attr(Name,A,V)),
	set_attr(Name,A,V),
	'$parse_attrs'(R,Name,Class,WA,GCA).
'$parse_attrs'([A|R],Name,Class,WA,GCA) :- !,
	format('[[ytoolkit: invalide attribute ~w]]~n',A),
	'$parse_attrs'(R,Name,Class,WA,GCA).

config_attr(x).
config_attr(y).
config_attr(width).
config_attr(height).
config_attr(border).

'$assign'(window,AV,RWA,GCA,[AV|RWA],GCA).
'$assign'(gc,AV,WA,RGCA,WA,[AV|RGCA]).
%							|
%							|
%-------------------------------------------------------


% ---- current_widget (and sub_widget) -----------------
%							|
%
current_widget(Class,Attr,Name) :-
	current_window(Name,[]), recorded(Name,'$object'(Class),_),
	working_window(Name),
	parse_attr_cw(Attr,Name,Class,WA,GC),
	current_window(Name,WA),
	(GC=[] -> otherwise; 	
		format('<<Ytoolkit:cannot query gc attributes ~w>>~n',GC)
	).

sub_widget(A,B) :- 
	current_widget(_,_,A),
	recorded(A,'$son'(B),_),
	current_widget(_,A,B).


parse_attr_cw([],_Name,_Class,[],[]) :- !.
parse_attr_cw([A=E|R],Name,Class,WA,GCA) :-	edipo_attr(Type,A), !,
	parse_attr_cw(R,Name,Class,RWA,RGCA),
	'$assign'(Type,A=E,RWA,RGCA,WA,GCA).
parse_attr_cw([A=E|R],Name,Class,WA,GCA) :- !,
	(get_attr(Name,A,E); call(Class:current_attr(A,Name,E))),
	parse_attr_cw(R,Name,Class,WA,GCA).
parse_attr_cw([A|R],Name,Class,WA,GCA) :- !,
	format('<<Ytoolkit:invalide attribute ~w>>~n',A),
	parse_attr_cw(R,Name,Class,WA,GCA).

%							|
%							|
%-------------------------------------------------------


% ---- change_widget (and sub_widget) -----------------
%							|
%
change_widget(Class,Attr,Name) :-
	current_window(Name,[]), 
	(recorded(Name,'$object'(Class),_) -> 
		otherwise
	;
		recorda(Name,'$object'(Class),_),
		add_class(Class),
		'$get_defaults'(Class,Defaults),
		'$parse_attrs'(Defaults,Name,Class,WAD,GCAD),
		window(Name,WAD),
		gc(Name,GCAD)
	),
	working_envir(Name),
	parse_attr_chw(Attr,Name,Class,WA,GC),
	window(Name,WA), notify_change(WA,Name,Class),
	gc(Name,GC), notify_change(GC,Name,Class).


parse_attr_chw([],_Name,_Class,[],[]) :- !.
parse_attr_chw([A=E|R],Name,Class,WA,GCA) :-	edipo_attr(Type,A), !,
	parse_attr_chw(R,Name,Class,RWA,RGCA),
	(config_attr(A) ->
		eval_attr(E,V,D), 
		set_depend(D,'$attr_depend'(Type,A,E,V,Name))
	;
		V=E
	),
	'$assign'(Type,A=V,RWA,RGCA,WA,GCA).
parse_attr_chw([A=E|R],Name,Class,WA,GCA) :- !,
	set_attr(Name,A,E), try(Class:change_attr(A,Name,E)),
	parse_attr_chw(R,Name,Class,WA,GCA).
parse_attr_chw([A|R],Name,Class,WA,GCA) :- !,
	format('<<Ytoolkit:invalide attribute ~w>>~n',A),
	parse_attr_chw(R,Name,Class,WA,GCA).

notify_change([],_Name,_Class).
notify_change([A=V|R],Name,Class) :- 
	try(Class:change_attr(A,Name,V)),
	notify_change(R,Name,Class).
%							|
%							|
%-------------------------------------------------------



% ---- kill_widget -------------------------------------
%							|
%
kill_widget(Class,_Attr,Name) :- 
	recorded(Name,'$object'(Class),_),
	current_window(Name,[parent=Parent]),			% Edipo	
	working_window(Name), 					% Edipo	
	unmap, 							% Edipo	
	'$clear_widgets_and_sons'(Name),
	recorded(Parent,'$son'(Name),Ref), erase(Ref),
	working_window(Name), 					% Edipo	
	destroy,						% Edipo	
	(current_window(Name,[]) -> % working widget cannot be a zombie
		(current_widget(_,_,CW);CW='$zombie$'), CW \== Name,
		working_window(CW)				% Edipo	
	;
		true
	), !.

'$clear_widgets_and_sons'(Name) :-
	recorded(Name,'$son'(Son),_),
		'$clear_widgets_and_sons'(Son),
	fail.
'$clear_widgets_and_sons'(Name) :-
	recorded(Name,_,Ref),
		erase(Ref), 	% erase all info on the widget
	fail.
'$clear_widgets_and_sons'(Name) :-
	(number(Name) -> recorda('$free',Name,_); otherwise).

%							|
%							|
%-------------------------------------------------------



% ---- miscelanious ------------------------------------
%							|
%
remove_all_widgets :-
	current_widget(Class,_,Name),
	kill_widget(Class,_,Name),
	fail.
remove_all_widgets.
	

bring_widget_front(Name) :- working_window(Name), raise.	% Edipo

send_widget_back(Name) :- working_window(Name), lower.		% Edipo

move_widget(Name,X,Y) :- window(Name,[x=X,y=Y]).		% Edipo

resize_widget(Name,W,H) :- window(Name,[width=W,height=H]).	% Edipo
%							|
%							|
%-------------------------------------------------------
