/*----------------------------------------------------------------------*
*									*
*			Edipo - yap/sicstus/quintus version		*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		window.c					*
*	purpose : 							*
*	creation	90/08/01					*
*	last changes :	91/12/12					*
*	bugs :								*
*	commennts :	some invalid values are traped (width, height)  *
*									*
*----------------------------------------------------------------------*/

#include "callx.h"
#include "attr.h"

Window x_default_root_window(d) Display *d; {  return DefaultRootWindow(d); }

XSetWindowAttributes	window_attrs;
unsigned long int	window_attrs_mask=0L;
XWindowChanges		window_config;
unsigned long int	window_config_mask=0L;


x_reset_window_attr() 
{    
  window_config_mask=0L;
  window_attrs_mask=0L; 
  return TRUE;
}

x_config_window(attr,value) 
     unsigned long int attr;
     long value;
{
  atom_entry *an;
  WindowAtomSearch(an,attr);

  window_config_mask |= an->mask;
  switch(an->mask)
    {
    case CWX: 		window_config.x = (int) value; 			break;
    case CWY: 		window_config.y = (int) value; 			break;
    case CWWidth:
      if(value <= 0)
	my_error_handler("invalid size config. attribute",ABORT_AFTER_ERROR);
      window_config.width = (int) value;		break;
    case CWHeight: 	
      if(value <= 0)
	my_error_handler("invalid size config. attribute",ABORT_AFTER_ERROR);
      window_config.height = (int) value;		break;
    case CWBorderWidth: window_config.border_width = (int) value;	break;
    }
  return TRUE;
}


x_set_window_attr(attr,value) 
     unsigned long int attr;
     long value;
{
  atom_entry *an;
  WindowAtomSearch(an,attr);

  window_attrs_mask |= an->mask;
  switch(an->mask)
    {
    case CWBackPixmap: 					
      window_attrs.border_pixmap = (Pixmap) value;
      break;
    case CWBackPixel: 		
      window_attrs.background_pixel = (unsigned int)value; 
      break;
    case CWBorderPixmap: 				break;
    case CWBorderPixel: 	
      window_attrs.border_pixel = (unsigned int) value;	
      break;
    case CWBitGravity: 					break;
    case CWWinGravity: 					break;
    case CWBackingStore:  				break;
    case CWBackingPlanes:  				break;
    case CWBackingPixel:  				break;
    case CWSaveUnder:  					break;
    case CWOverrideRedirect:  				break;
    case CWColormap:  					break;
    case CWCursor:  		
      window_attrs.cursor = value;		
      break;
    }
  return TRUE;
}

static Window known_attr_window=0L;

x_my_change_window(display,w)
     Display *display;
     Window   w;
{
  known_attr_window=0L; /* zp; need by get_window_attr() */
    if(window_config_mask != 0L)
      XConfigureWindow(display,w,window_config_mask,&window_config);
    window_config_mask=0L;
    if(window_attrs_mask != 0L)
      XChangeWindowAttributes(display,w,window_attrs_mask,&window_attrs);
    window_attrs_mask=0L;
    return TRUE;
};


struct _get
{
  XWindowAttributes attr;
/* Term		parent; */
  char	       *display;
} get_window;

unsigned long int x_get_window_attr(display,window,attr,value)
     Display* display;
     Window   window;
     unsigned long int attr;
     unsigned long int *value;
{
  atom_entry *an;
  unsigned long int ret;

  if(window != known_attr_window)
    {
      XGetWindowAttributes(display,window,&get_window.attr);
      known_attr_window=window;
    }
  
  WindowAtomSearch(an,attr);

  if(an != NULL)
    switch(an->mask)
      {
      case CWX:		*value = get_window.attr.x; ret=true_atom; break;
      case CWY: 	*value = get_window.attr.y; ret=true_atom; break;
      case CWWidth: 	*value = get_window.attr.width; ret=true_atom; break;
      case CWHeight: 	*value = get_window.attr.height; ret=true_atom; break;
      case CWBorderWidth: 	*value = get_window.attr.border_width; 
				ret=true_atom; break;
      default: 		*value = 0; ret = false_atom;
      }
  else
    { *value = 0; ret = false_atom; }
  return ret;
}




/************************************************************************
 *									*
 * 				COLOR					*
 *									*
 ************************************************************************/

extern x_color(display,depth)
     Display *display;
     long int *depth;
{
  *depth = DisplayPlanes(display,DefaultScreen(display));
  return TRUE;
}

unsigned int x_get_color_pixel(display,color,pixel) 
     Display *display;
     char *color;
{
  XColor sd, ed;

  if(XAllocNamedColor(display,edipo_cmap,color,&sd,&ed) == 0)
    {
      char M[256];
      sprintf(M,"Can't load color \"%s\"",color);
      ErrorHandler(M,ABORT_AFTER_ERROR);
    }
  else
    return sd.pixel;
}
