/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		text.c						*
*	purpose : 							*
*	creation	90/08/03					*
*	last changes :	90/09/04					*
*	bugs :								*
*	commennts :					 		*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"
#define TERM_STR 1024

/*			Not very sound way of implementing backtrackables */
static char **p;	
int count;

x_init_font_list(display,pattern)
     Display *display;
     char *pattern;
{
  p = XListFonts(display,pattern,STRSIZE,&count);
}

x_list_font(name)
     char **name;
{
  if(count-- == 0)
    *name="[]";
  else
    *name = *p++;
}


/************************************************************************
 *									*
 * 		   Font Info Handling					*
 *									*
 ************************************************************************/


typedef struct FontNode {
  XFontStruct *info;
     Font	  Id;
     struct FontNode *next;
}  *FontList;

static FontList fonts = 0;

XFontStruct *font_info=0;
Font font_loaded=0;

query_font(display,gc)
     Display *display;
     GC gc;
{
  FontList fi=fonts;
  Font new;
  if(font_loaded==(new=gc->values.font)) return;
  while(fi) {
    if(fi->Id==new) {
      font_loaded=new;
      font_info = fi->info;
      return;
    }
    fi = fi->next;
  }
  fi = (FontList) malloc(sizeof(*fi));
  fi->Id = font_loaded = new;
  if((fi->info = font_info = XQueryFont(display,new))==NULL)
    ErrorHandler("invalid font",ABORT_AFTER_ERROR);
  fi->next = fonts;
  fonts = fi;  
}


x_my_draw_atom(display,window,gc,x,y,str)
     Display *display;
     Window window;
     GC gc;
     long int x,y;
     char *str;
{
  int n;

  n=strlen(str);
  query_font(display,gc);
  XDrawImageString(display,window,gc,x,y-font_info->max_bounds.descent,str,n);
}



char string[256];
int  pos;

x_end_string()
{
  string[pos]='\0';
  pos=0;
}

x_next_char(c)
     long int c;
{
  string[pos++]=(char) c;
}

x_my_draw_string(display,window,gc,x,y)
     Display *display;
     Window window;
     GC gc;
     long int x,y;
{
  int n;

  n=strlen(string);
  query_font(display,gc);
  XDrawImageString(display,window,gc,x,y-font_info->max_bounds.descent,string,n);
}

static get_string();

x_my_draw_term(display,window,gc,x,y,file_name)
     Display *display;
     Window window;
     GC gc;
     long int x,y;
     char *file_name;
{
  char str[TERM_STR];
  int n;

  n=get_string(file_name,str);
  query_font(display,gc);
  XDrawImageString(display,window,gc,x,y-font_info->max_bounds.descent,str,n);
}


x_my_writebox(display,gc,string,width,height)
     Display *display;
     GC gc;
     char *string;
     long int *height, *width;
{
  query_font(display,gc);
  *height = (long)font_info->max_bounds.ascent + font_info->max_bounds.descent;
  *width = (long) XTextWidth(font_info,string,strlen(string));

} /* end of writebox */


x_my_termbox(display,gc,file_name,width,height)
     Display *display;
     GC gc;
     char *file_name;
     long int *height, *width;
{
  char str[TERM_STR];
  int n;

  n=get_string(file_name,str);
  query_font(display,gc);
  *height = (long)font_info->max_bounds.ascent + font_info->max_bounds.descent;
  *width = (long) XTextWidth(font_info,str,n);

} /* end of termbox */


/************************************************************************
 *									*
 * 		   		Utils					*
 *									*
 ************************************************************************/


char file[STRSIZE];

x_tmp(File) 
     char **File;
{ 
  sprintf(file,"/usr/tmp/edipo%d",getpid());
  *File=file;
}


static get_string(file_name,str)
     char *file_name, *str;
{
  int i;
  FILE *fs; 
  
  if((fs=fopen(file_name,"r")) == NULL)
    ErrorHandler("can't open tmp file",ABORT_AFTER_ERROR);
  
  for(i=0;(str[i]=getc(fs))!=EOF && i<TERM_STR; i++);
  if(i==TERM_STR)
    ErrorHandler("term too long",CONTINUE_AFTER_ERROR);
  fclose(fs);
  unlink(file_name);
  return i;
}



