%-----------------------------------------------------------------------%
%									%
%			Edipo - sicstus/quintus version			%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		event.pl					%
%	purpose : 	event handling predicates			%
%	creation	90/08/01					%
%	last changes :	92/05/12					%
%	bugs :								%
%	comments :	key events are not very efficient		%
%									%
%-----------------------------------------------------------------------%



/* :- module(event,[event/2]). */




event(WindowName,Event) :- %  blocking
	recorded('$display','$display'(_,Display),_),
	x_my_next_event(0,Display,Window,EventType,A0,A1,A2,A3,A4,A5),
	(window_name(Window,WindowName,EventType)  -> 
	    mk_event(EventType,A0,A1,A2,A3,A4,A5,Event)
	;
	    event(WindowName,Event)
	).

events(WindowName,Event) :- % no blocking
	repeat,
	(recorded('$display','$display'(_,Display),_) -> true; !, fail),
	x_my_next_event(1,Display,Window,EventType,A0,A1,A2,A3,A4,A5),
	(mk_event(EventType,A0,A1,A2,A3,A4,A5,MyEvent) -> true; !, fail),
	(window_name(Window,WindowName,EventType) -> 
	    Event=MyEvent
	;
	    events(WindowName,Event)
	).

window_name(Window,WindowName,_) :- % living window
	recorded('$window','$window'(WindowName,_,Window,_),_), !.
window_name(_,WindowName,unmapNotify) :- %living dead window
	recorded('$zombie',WindowName,Ref), !, erase(Ref).

mk_event(keyPress,Text,Key,X,Y,_,_,keyPress(LText,Key,X,Y)) :-name(Text,LText).
mk_event(keyRelease,Text,Key,X,Y,_,_,keyRelease(LT,Key,X,Y)):-name(Text,LT).
mk_event(buttonPress,_,Button,X,Y,_,_,buttonPress(Button,X,Y)).
mk_event(buttonRelease,_,Button,X,Y,_,_,buttonRelease(Button,X,Y)).
mk_event(motionNotify,_,X,Y,_,_,_,motionNotify(X,Y)).
mk_event(enterNotify,_,_,_,_,_,_,enterNotify).
mk_event(leaveNotify,_,_,_,_,_,_,leaveNotify).
mk_event(expose,_,Count,_,_,_,_,expose(Count)).
mk_event(visibilityNotify,Type,_,_,_,_,_,visibilityNotify(Type)).
mk_event(createNotify,_,_,_,_,_,_,createNotify).
mk_event(configureNotify,_,X,Y,W,H,B,configureNotify(X,Y,W,H,B)).
mk_event(destroyNotify,_,_,_,_,_,_,destroyNotify).
mk_event(mapNotify,_,_,_,_,_,_,mapNotify).
mk_event(unmapNotify,_,_,_,_,_,_,unmapNotify).
