%-----------------------------------------------------------------------%
%									%
%			Edipo - yap/sicstus/quintus version		%
%									%
%						August 90		%
%						Ze' Paulo Leal		%
%						Universidade do Porto	%
%									%
%-----------------------------------------------------------------------%
%									%
%	file :		callx.pl					%
%	purpose : 	low level interface with Xlib			%
%	creation	90/08/01					%
%	last changes :	91/010/23					%
%	bugs :								%
%	comments :	yap cannot abolish properly/Window is now addr.	%
%									%
%-----------------------------------------------------------------------%


foreign_file('window.o',[

	x_reset_window_attr,
	x_config_window,
	x_set_window_attr,
	x_get_window_attr,
	x_my_change_window,
	x_color,
	x_get_color_pixel,

	'XOpenDisplay',
	'XCreateWindow',
	x_default_root_window,
	'XSetStandardProperties',
	'XClearWindow',
	'XMapWindow',
	'XUnmapWindow',
	'XMapRaised',
	'XLowerWindow',
	'XDestroyWindow',
	'XFlush',
	'XMoveWindow',
	'XResizeWindow',
	'XSetWindowBackground',
	'XSetWindowBackgroundPixmap',
	'XSetWindowBorder',
	'XSetWindowBorderWidth',
	'XSetWindowBorderPixmap',
	'XReparentWindow',
	'XCreateFontCursor']).
foreign_file('gc.o',[
	'XCreateGC',
	'XCopyGC',
	'XSetFunction',
	'XSetForeground',
	'XSetBackground',
	'XSetLineAttributes',
	'XSetFillStyle',
	'XSetFillRule',
	'XSetTile',
	'XSetStipple',
	'XSetArcMode',
	x_set_gc_int_attr,
	x_set_gc_atom_attr,
	x_my_change_gc]).
foreign_file('attr.o',[
	x_window_attr,
	x_gc_attr]).
foreign_file('text.o',[
	'XSetFont',
	'XLoadFont',
	x_init_font_list,
	x_list_font,
	x_tmp,
%	x_my_make_stream,
	x_my_draw_atom,
	x_my_draw_term,
	x_my_termbox,
	x_my_draw_string,
	x_next_char,
	x_end_string,
	x_my_writebox]).
foreign_file('draw.o',[
	'XDrawLine',
	'XDrawRectangle',
	'XFillRectangle',
	'XClearArea',
	'XDrawArc',
	'XFillArc',
	x_my_init_poly,
	x_my_poly_point,
	x_my_polygon,
	'XBell']).
foreign_file('bitmap.o',[
	x_my_add_pixel,
	x_my_end_pixmap_line,
	x_my_create_pixmap_from_data]).
foreign_file('event.o',[
	my_select_input,
	my_next_event]).
foreign_file('init.o',[
	c_init_edipo]).


/* Window, Display and GC Creation */

foreign(x_window_attr,c,x_window_attr(+atom,[-atom])).
foreign(x_gc_attr,c,x_gc_attr(+atom,[-atom])).

foreign(x_reset_window_attr,c,x_reset_window_attr).
foreign(x_config_window,c,x_config_window(+atom,+integer)).
foreign(x_set_window_attr,c,x_set_window_attr(+atom,+integer)).
foreign(x_my_change_window,c,x_my_change_window(+address('Display'),+address('Window'))).
foreign(x_get_window_attr,c,x_get_window_attr(
	+address('Display'),
	+address('Window'),
	+atom,
	-integer,
	[-atom])).
foreign(x_color,c,x_color(+address('Display'),-integer)).
foreign(x_get_color_pixel,c,
	x_get_color_pixel(+address('Display'),+string,[-integer])).

foreign('XOpenDisplay',c,x_display(+string,[-address('Display')])).
foreign('XCreateWindow',c,x_create_window(
	+address('Display'),
	+address('Window'),	% Window
	+integer, +integer, +integer, +integer, +integer,
	+integer, +integer,
	+integer,
	+address('XSetWindowAttributes'),
	[-address('Window')])).
foreign('XSetStandardProperties',c,x_set_standart_properties(
	+address('Display'),
	+address('Window'),	% Window
	+string, +string,
	+integer, +integer, +integer,+integer)).	
foreign('x_default_root_window',c,x_default_root_window(+address('Display'),
	[-address('Window')])).
foreign('XClearWindow',c,x_clear(+address('Display'),+address('Window'))).
foreign('XMapWindow',c,x_map(+address('Display'),+address('Window'))).
foreign('XUnmapWindow',c,x_unmap(+address('Display'),+address('Window'))).
foreign('XMapRaised',c,x_raise(+address('Display'),+address('Window'))).
foreign('XLowerWindow',c,x_lower(+address('Display'),+address('Window'))).
foreign('XDestroyWindow',c,x_destroy(+address('Display'),+address('Window'))).
foreign('XFlush',c,x_flush(+address('Display'))).
foreign('XReparentWindow',c,
	x_reparent_window(+address('Display'),
	+address('Window'),+address('Window'),
	+integer,+integer)).
foreign('XCreateFontCursor',c,x_create_font_cursor(
	+address('Display'),+integer,[-integer])).

/* Change Window Configuration */

foreign('XMoveWindow',c,
	x_move_window(+address('Display'),+address('Window'),+integer,+integer)).
foreign('XResizeWindow',c,
	x_resize_window(+address('Display'),+address('Window'),+integer,+integer)).
foreign('XSetWindowBorderWidth',c,
	x_set_window_border_width(+address('Display'),+address('Window'),+integer)).

/* Change Window Attributes */

foreign('XSetWindowBackground',c,
	x_set_window_background(+address('Display'),+address('Window'),
	+integer)).
foreign('XSetWindowBackgroundPixmap',c,
	x_set_window_background_pixmap(+address('Display'),+address('Window'),
	+address('Pixamp'))).
foreign('XSetWindowBorder',c,
	x_set_window_border(+address('Display'),+address('Window'),+integer)).
foreign('XSetWindowBorderPixmap',c,
	x_set_window_border_pixmap(+address('Display'),+address('Window'),
	+address('Pixamp'))).
/* GC  */


foreign('XCreateGC',c,x_create_gc(
	+address('Display'),
	+address('Window'),
	+integer,
	+address('XGCValues'),
	[-address('GC')])).
foreign('XCopyGC',c,x_copy_gc(
	+address('Display'),
	+address('GC'),
	+integer,
	+address('GC'))).

% gc attributes 

foreign('XSetFunction',c,
	x_set_function(+address('Display'),+address('GC'),+integer)).
foreign('XSetForeground',c,
	x_set_foreground(+address('Display'),+address('GC'),+integer)).
foreign('XSetBackground',c,
	x_set_background(+address('Display'),+address('GC'),+integer)).
foreign('XSetLineAttributes',c,
	x_set_line_attributes(+address('Display'),+address('GC'),
	+integer,+integer,+integer,+integer)).

foreign('XSetFillStyle',c,
	x_set_fill_style(+address('Display'),+address('GC'),+integer)).
foreign('XSetFillRule',c,
	x_set_fill_rule(+address('Display'),+address('GC'),+integer)).
foreign('XSetTile',c,'XSetTile'(+address('Display'),+address('GC'),
	+address('Pixmap'))).
foreign('XSetStipple',c,'XSetStipple'(+address('Display'),+address('GC'),
	+address('Pixmap'))).
foreign('XSetArcMode',c,
	x_set_arc_mode(+address('Display'),+address('GC'),+integer)).

foreign('XSetFont',c,
	x_set_font(+address('Display'),+address('GC'),+integer)).
foreign('XLoadFont',c,
	x_load_font(+address('Display'),+string,[-integer])).
foreign('x_init_font_list',c,x_init_font_list(+address('Display'),+string)).
foreign('x_list_font',c,x_list_font(-string)).


foreign(x_set_gc_int_attr,c,x_set_gc_int_attr(+atom,+integer)).
foreign(x_set_gc_atom_attr,c,x_set_gc_atom_attr(+atom,+atom)).
foreign(x_my_change_gc,c,x_my_change_gc(+address('Display'),+address('GC'))).

/* Text primitives */

foreign('x_end_string',c,x_end_string).
foreign('x_next_char',c,x_next_char(+integer)).
foreign('x_my_draw_string',c,
	x_my_draw_string(+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer)).
foreign('x_my_writebox',c,
	x_my_writebox(+address('Display'),+address('GC'),+string,
	-integer,-integer)).
foreign(x_tmp,c,x_tmp(-string)).
%foreign(x_my_make_stream,c,x_my_make_stream([-integer])).
foreign(x_my_draw_atom,c,x_my_draw_atom(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+string)).
foreign(x_my_draw_term,c,x_my_draw_term(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+string)).
foreign(x_my_termbox,c,x_my_termbox(
	+address('Display'),+address('GC'),+string,
	-integer,-integer)).

/* Drawing primitives */

foreign('XDrawLine',c,x_draw_line(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+integer,+integer)).
foreign('XDrawRectangle',c,x_draw_rectangle(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+integer,+integer)).
foreign('XFillRectangle',c,x_fill_rectangle(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+integer,+integer)).
foreign('XClearArea',c,x_clear_area(
	+address('Display'),+address('Window'),
	+integer,+integer,+integer,+integer,+integer)).
foreign('XDrawArc',c,x_draw_arc(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+integer,+integer,+integer,+integer)).
foreign('XFillArc',c,x_fill_arc(
	+address('Display'),+address('Window'),+address('GC'),
	+integer,+integer,+integer,+integer,+integer,+integer)).
foreign(x_my_init_poly,c,x_my_init_poly(+integer)).
foreign(x_my_poly_point,c,x_my_poly_point(+integer,+integer)).
foreign(x_my_polygon,c,x_my_polygon(
	+address('Display'),+address('Window'),+address('GC'),+integer,+integer)).
foreign('XBell',c,'XBell'(+address('Display'),+integer)).

foreign(x_my_add_pixel,c,x_my_add_pixel(+integer)).
foreign(x_my_end_pixmap_line,c,x_my_end_pixmap_line).
foreign(x_my_create_pixmap_from_data,c,x_my_create_pixmap_from_data(
	+address('Display'),+address('Window'),+address('GC'),
	-address('Pixmap'))).


/* Events */

foreign(my_select_input,c,x_my_select_input(+address('Display'),+address('Window'))).
foreign(my_next_event,c,x_my_next_event(
	+integer,			% (0=blocking, 1=no_blocking)
	+address('Display'),		% Display *
	-address('Window'),		% window
	-atom,				% event type
	-string,			% atom argument
	-integer,-integer,-integer,-integer,-integer)).

/* Init */

foreign(c_init_edipo,c,x_my_init_edipo(+address('Display'))).


:- prolog_flag(_,_) ->  true; [qy].

:- load_foreign_files(edipo:[
	'window.o',
	'gc.o',
	'event.o',
	'draw.o',
	'text.o',
	'init.o',
	'attr.o',
	'bitmap.o'],
	['-lX11']),
	abolish(foreign,3),
	abolish(foreign_file,2).
	
