/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		callx.h						*
*	purpose :     	edipo C files header file			*
*	creation	90/08/03					*
*	last changes :	90/08/03					*
*	bugs :								*
*	commennts :					 		*
*									*
*----------------------------------------------------------------------*/

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>

#if YAP
#undef Bool
#define Bool BoolYap
#define Atom YapAtom
#include "c_interface.h"
#define AtomFromString(A) 	MkAtomTerm(LookupAtom(A))
#define StringFromAtom(A) 	AtomName(AtomOfTerm(A))
#endif
#if SICSTUS
#include "sicstus.h"
#ifdef OLD
#define AtomFromString(A)	SP_atom_from_string(A)
#define StringFromAtom(A) 	SP_string_from_atom(A)
#else
#define AtomFromString(A)	sp_atom_from_string(A)
#define StringFromAtom(A) 	sp_string_from_atom(A)
extern char *sp_string_from_atom();
extern unsigned long int sp_atom_from_string();
#endif
#endif
#if QUINTUS
#define AtomFromString(A)	QP_atom_from_string(A)
#define StringFromAtom(A) 	QP_string_from_atom(A)
#endif



#define STRSIZE	256
#define FALSE	0
#define TRUE	1


/************************************************************************
 *									*
 *				Error Handling				*
 *									*
 ************************************************************************/

/* The behaviour of ErrorHandler is set by these flags :

   CONTINUE_AFTER_ERROR: return to the caller, who should take the necessary
   	measures.
   ABORT_AFTER_ERROR: output the message, and then abort, back to the
	top level.
   EXIT_AFTER_ERROR: output the message, and exit Prolog

*/

#define CONTINUE_AFTER_ERROR	0
#define ABORT_AFTER_ERROR	1
#define EXIT_AFTER_ERROR	2

#define ErrorHandler(M,F)	my_error_handler(M,F)




/************************************************************************
 *									*
 *			 Global Variables				*
 *									*
 ************************************************************************/

extern int edipo_on;
extern int  edipo_screen;
extern Colormap  edipo_cmap;

extern unsigned long int nil_atom;





