/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		attr.c						*
*	purpose : 	window and gc attr functions			*
*	creation	91/12/16					*
*	last changes :	92/04/24					*
*	bugs :								*
*	commennts :							*
*									*
*----------------------------------------------------------------------*/

#include "callx.h"

#define MAXDATA	256
int width=0,max_width=0, height=0, bit_counter=0;
char data[MAXDATA], *ptr=data;

x_my_add_pixel(Pixel) long int Pixel;
{
  *ptr |= ((char) Pixel==' ' ? '\0' : 0x01<<bit_counter);
  if( (bit_counter=(bit_counter+1)%8)==0 )
    {
      if(ptr-data > MAXDATA)
	ErrorHandler("bitmap too long",ABORT_AFTER_ERROR);
      else
	ptr++;
    }
  width++;
}
x_my_end_pixmap_line()
{
  height++;
  if( width>max_width ) max_width=width;
  width=0;
  if( bit_counter!=0 ) ptr++;
  bit_counter=0;
}

x_my_create_pixmap_from_data(display,window,gc,pixmap)
     Display *display;
     Window window;
     GC gc;
     Pixmap *pixmap;
{int depth, i;	

 depth= DisplayPlanes(display,DefaultScreen(display));
 *pixmap= XCreatePixmapFromBitmapData(display,
				      window, /*DefaultRootWindow(display),*/
				      data,max_width,height,
				      gc->values.foreground,
				      gc->values.background,
				      depth);

 /* XSetWindowBackgroundPixmap(display,window,*pixmap); */

 /* Reset data structures */
 width=max_width=height=bit_counter=0;
 ptr=data;
 for(i=0;i<MAXDATA;i++)
   data[i]='\0';
}
