/*----------------------------------------------------------------------*
*									*
*			Edipo - sicstus/quintus version			*
*									*
*						August 90		*
*						Ze' Paulo Leal		*
*						Universidade do Porto	*
*									*
*-----------------------------------------------------------------------*
*									*
*	file :		attr.c						*
*	purpose : 	window and gc attr functions			*
*	creation	91/04/12					*
*	last changes :	91/04/12					*
*	bugs :								*
*	commennts :							*
*									*
*----------------------------------------------------------------------*/


typedef struct
  {
    char *name;
    unsigned long int mask;
    unsigned long int atom;
  } atom_entry;

extern atom_entry window_atoms[],gc_atoms[],window_val_atoms[],gc_val_atoms[];
extern int n_wd_atoms, n_gc_atoms, n_wd_v_atoms, n_gc_v_atoms;
extern int atom_compare();
extern unsigned long int true_atom, false_atom;

#define WindowAtomSearch(attr,ka) AtomSearch(attr,window_atoms,n_wd_atoms,ka)
#define GCAtomSearch(attr,ka) AtomSearch(attr,gc_atoms,n_gc_atoms,ka)
#define WindowValAtomSearch(attr,ka) \
  AtomSearch(attr,window_val_atoms,n_wd_v_atoms,ka)
#define GCValAtomSearch(attr,ka) \
  AtomSearch(attr,gc_val_atoms,n_gc_v_atoms,ka)

#define AtomSearch(attr,table,size,ka) {  atom_entry key; \
				 key.atom=ka; \
			      attr=(atom_entry *)bsearch((char *)&key, \
				      (char *)table, \
				      size, \
				      sizeof(key), \
				      atom_compare); \
				      }
