%-----------------------------------------------------------------------%
%									%
%		Ydraw: Ytoolkit Interface Builder			%
%									%
%									%
%						Feb 91 Ze' Paulo Leal	%
%									%
%-----------------------------------------------------------------------%
%	file:	       ydraw.yap					%
%	changed:	91/02/22					%
%	bugs: 								%
%									%
%-----------------------------------------------------------------------%

:- module(ybuild,[ybuild/0]).
:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).

:- add_class(paper).

:- write('*** try this one ***			?- ybuild.'), nl,nl,nl.

ybuild :- new_widget(ybuild,[],ybuild),loop.


default(width,600).
default(height,400).
default(line_width,3).
default(BK_A,BK_V) :- (color -> 
		BK_A=bkg_pixel, BK_V='dark khaki'
	;
		BK_A=bkg_pixmap, BK_V=["   #",	" #  ",	"  # ",	"#   "]
	).


sub_widgets(YB) :- 
	gen_name(B),
	new_widget(paper,[
		parent=YB
		,x=90
		,y=50
		,width=450
		,height=300
		,current_font_item=1
		,current_font='9x15'
		,font='9x15'
	],B),
%	draw(YB,frectangle(B~x+5,B~y+5,B~width+5,B~height+5)),

	new_widget(tools_yb,[
		parent=YB,
		x=10,
		y=50,
		paper=B
	],_),
	new_widget(commands_yb,[
		parent=YB,
		top=YB,
		paper=B
	],_),
	current_font(['9x15bold','*bold','*bold*'],Font),
	new_widget(ydraw_icon,[
		parent=YB,
		x=YB~width-35,
		y=5,
		border=2,
		border_pixel=black,
		font=Font,
		fig=writeterm(10,20,'?'),
		callback=ytoolkit:new_widget(help,[file='README'],help)
	],_).



	
