%-----------------------------------------------------------------------%
%									%
%		Ydraw: Ytoolkit drawing demo				%
%									%
%									%
%						Feb 91 Ze' Paulo Leal	%
%									%
%-----------------------------------------------------------------------%
%	file: 	    tools_yd.yap					%
%	changed:	91/02/22					%
%	bugs: 								%
%									%
%-----------------------------------------------------------------------%

:- module(tools_yb,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('behaviors/moveable')).

default(width,60).
default(height,160).
default(border,1).
default(border_pixel,black).
default(bkg_pixel,black).


sub_widgets(YD) :-
	get_attr(YD,paper,B),
	new_widget(ydraw_icon,[
		parent=YD,
		x=0,
		y=10,
		fig=line(5,5,20,25),
		callback=recorda(B,paper_drawing(line(_,_,_,_)),_)
	],_),
	current_font(['9x15bold','*bold','*bold*'],Font),
	new_widget(ydraw_icon,[
		parent=YD,
		x=30,
		y=10,
		font=Font,
		fig=writeterm(10,20,'T'),
		callback=recorda(B,paper_drawing(writestring(_,_,_)),_)
%		callback=draw_text(B)
	],_),
	Poly=[(5,5),(20,7),(13,20),(25,25)],
	new_widget(ydraw_icon,[
		parent=YD,
		x=0,
		y=40,
		fig=poly(Poly),
		callback=draw_poly(B,empty)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=30,
		y=40,
		fig=fpoly(Poly),
		callback=draw_poly(B,full)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=0,
		y=70,
		fig=rectangle(5,7,15,10),
		callback=recorda(B,paper_drawing(rectangle(_,_,_,_)),_)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=30,
		y=70,
		fig=frectangle(5,7,15,10),
		callback=recorda(B,paper_drawing(frectangle(_,_,_,_)),_)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=0,
		y=100,
		fig=circle(13,13,10),
		callback=recorda(B,paper_drawing(circle(_,_,_)),_)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=30,
		y=100,
		fig=farc(3,3,20,20,0,23040),
		callback=recorda(B,paper_drawing(fcircle(_,_,_)),_)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=0,
		y=130,
		fig=arc(3,3,20,20,0,18000),
		callback=recorda(B,paper_drawing(arc(_,_,_,_,_,_)),_)
	],_),
	new_widget(ydraw_icon,[
		parent=YD,
		x=30,
		y=130,
		fig=farc(3,3,20,20,0,18000),
		callback=recorda(B,paper_drawing(farc(_,_,_,_,_,_)),_)
	],_).

behavior(A,B) :- moveable(A,B).

