
:- module(dialog_attr,[]).

:- use_module(library(ytoolkit)).

:- ytoolkit:super_class(dialog_attr:dialog_box).

default(width,400).
default(height,250).
default(font,Font) :- current_font('*bold*',Font).

layout :- 
	get_attr(text,Text),
	draw(writeterm(30,30,Text)).		

sub_widgets(DialogBox) :-
	new_widget(scrollwindow,[
		parent=DialogBox
		,x=30
		,y=50
		,width=DialogBox~width-60
		,height=DialogBox~height-117
		,type=sy
		,back=Back
	],SW),
	current_widget(_,[back=Back],SW),
	get_attr(DialogBox,fields,Fields),
	make_fields(Fields,1,Back),
	new_widget(button,[
		parent=DialogBox
		,x=50
		,y=DialogBox~height-50
		,text='Ok'
		,callback=dialog_attr:ok(DialogBox,Back)
	],_),
	new_widget(button,[
		parent=DialogBox
		,x=DialogBox~width-150
		,y=DialogBox~height-50
		,text='Cancel'
		,callback=dialog_attr:cancel(DialogBox)
	],_).
	
make_fields([],H,Back) :-
	change_widget(_,[height=H],Back).
make_fields([A=V|R],Y,Back) :-
	H=19,
	(atomic(V) -> name(V,VC) ; term(V,VC,_)),
	new_widget(field,[
		parent=Back,
		x=110,
		y=Y,
		width=200,
		height=H,	
		chars=VC
	],Field),
	new_widget(label,[
		parent=Back,
		x=10,
		y=Y,
		width=100,
		height=H,
		text=A:'',
		align=left
	],_),
	change_widget(_,[field(A)=Field],Back),
	NY is Y+H+3,
	make_fields(R,NY,Back).

ok(DialB,Back) :-
	findall(A=V,attr_in(Back,A,V),Value),
	call_back(DialB,callback(Value)),
	kill_widget(dialog_attr,[],DialB).

cancel(DialB) :- kill_widget(dialog_attr,[],DialB).



attr_in(Back,A,V) :-
	current_widget(_,[field(A)=F],Back),
	current_widget(field,[chars=Chars],F), 
	get_char_value(Chars,V).

get_char_value([34|R],L) :- rest_of_list(R,L), !.
get_char_value(Chars,Value) :- term(Value,Chars,_), !.
get_char_value(Chars,Value) :- 	name(Value,Chars).

rest_of_list([34],[]) :- !.
rest_of_list([C|R],[C|L]) :- rest_of_list(R,L).




