

:- module(reversi,[reversi/0]).


:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library(edipo)).
:- ensure_loaded(play_reversi).

:- add_class(piece).
:- add_class(dialog).
:- add_class(message).
:- add_class(dialog).

:- use_module(library('widgets/popup')). % ,[toggle_menu_item/2]).

/*
	The Game
*/

:- write('*** try this one ***			?- reversi.'),nl,nl,nl.

reversi :- 
	W=reversi,
	new_widget(reversi,[],W),	% Make the interface
					% and create a Game
	loop.				% Interact
/*
	Interface Definition

*/


default(bkg_pixmap,[
			"#   ",
			"   #",
			" #  ",
			"  # "
			]).
default(cursor,circle).
default(line_width,4).
default(color,white).
default(against,computer).
default(play_first,false).
default(aginst,computer).
default(trace,true).
default(level,minimax(2)).
default(level_item,3).

default(square_size,25).
default(board_size,8).

default(tab,_T0).




sub_widgets(W) :-
%	select_widget_name(reversi,W),
	get_attr(W,square_size,S),

	get_attr(W,board_size,N),
	matrix:make_matrix(N,N,T0),
	set_attr(W,prev_tab,T0),
	
	draw(W,rectangle(S,33+S,N*S,N*S)),
	M=reversi, %	source_module(M),
	new_widget(popup,[
		parent=W,
		x=5,
		y=5,
		text=' Control ',
		menu=menu(
item(' Save Game... ',dialog(W,'Save game to file',F,M:save_game(W,F))),
item(' Load Game... ',dialog(W,'Load game from file',F,M:load_game(W,F))),
item(' Exit to Prolog ',ytoolkit:exit_loop)
			)
	],M1),
	new_widget(popup,[
		parent=W,
		x=M1~x+M1~width,
		y=5,
		text=' Game ',
		menu=menu(
		  item(' New Game ',new_game(W)),
		  item(' Play First ',play_first(W,M2,2)),
		  item(' Play With White ',change_color(W,M2,3)),
		  item(' Against Human ',against(W,M2,4)),
		  item(' No move',no_move(W)),
		  item(' How to play ',ytoolkit:new_widget(help,[file='help.txt'],' How to play '))
		)
	],M2),
	new_widget(popup,[
		parent=W,
		x=M2~x+M2~width,
		y=5,
		text=' Level ',
		menu=menu(
		  item(' Under-Graduate ',set_level(naive,W,M3,1)),
		  item(' Graduate ',set_level(heuristic,W,M3,2)),
		  item(' Master ',set_level(minimax(2),W,M3,3)),
		  item(' Professor ',set_level(minimax(4),W,M3,4)),
		  item(' Genius ',set_level(minimax(6),W,M3,5)),
		  item(' God ',set_level(minimax(18),W,M3,6))
		)
	],M3),
	toggle_menu_item(M3,3),

	current_font(['6x13',*],Font),
	row(N,N,S,W),
	new_widget(_,[
		parent=W,
		x=10*S,
		y=30+S,
		width=W~width-11*S,
		height=W~height-(30+S)-20,
		border=1,
		border_pixel=black,
		font=Font
	],Board),
	change_widget(_,[board=Board],W),
	new_game(W).

change_attr(tab,W,Tab) :- 	
	current_widget(_,[prev_tab=T0],W),
	show_tab(T0,Tab,W),
	set_attr(W,prev_tab,Tab).
change_attr(color,W,Color) :- 
	current_widget(_,[tab=T],_W), show_board(W,T),
	(Color=white->Cursor=circle;Cursor=dot),
	change_widget(_,[cursor=Cursor],W).
change_attr(level,W,_) :- current_widget(_,[tab=T],_W), show_board(W,T).
change_attr(level,W,_) :- current_widget(_,[tab=T],_W), show_board(W,T).
change_attr(board_size,W,_) :- 
	message(W,' board_size cannot be changed'),
	set_attr(W,board_size,8).
change_attr(square_size,W,_) :- 
	message(W,' square_size cannot be changed'),
	set_attr(W,board_size,25).


/* 
	Making the board (interface)

*/



row(R,N,S,W) :- 
	(R=0 -> 
	    otherwise 
	; 
	    column(R,N,S,W), 
	    R1 is R-1, row(R1,N,S,W)
	).

column(R,C,S,W) :- 
	(C=0 ->
	    otherwise
	;
	    new_piece(R,C,S,W),
	    C1 is C-1,
	    column(R,C1,S,W)
	).


new_piece(R,C,S,W) :- 
	new_widget(piece,[
		parent=W,
		x=C*S,
		y=30+R*S,
		border=2,
		width=S-1,
		height=S-1,
		status=empty,
		row=R,
		column=C,	
		callback(B)=change(B,P,W)
	],P),
	change_widget(_,[piece(R,C)=P],W).

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *

	Callbacks 

 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */



change(_B,P,W) :-
	change_widget(_,[cursor=watch],W),
	current_widget(_,[tab=T,color=C],W),
	current_widget(piece,[row=PR,column=PC],P),
	(make_move(T,PR,PC,C,NT) ->
		change_widget(_,[tab=NT,color=C,cursor=watch],W),
		current_widget(_,[winner=Status],W),
		(ending(Status,W) -> true ;reply(NT,C,W))
	;
		invalid_move(W)
	),
	(C=white->Cursor=circle;Cursor=dot),
	change_widget(_,[cursor=Cursor],W).

reply(T,C,W) :-
	current_widget(_,[against=A,level=L],W),
	other_color(C,O),
	reply(A,L,T,C,W,O).

reply(human,_,_T,_C,W,O) :-	change_widget(_,[color=O],W).
reply(computer,Level,T,C,W,O) :-
	(choose_position(Level,T,O,NT) ->
		change_widget(_,[tab=NT],W),
		current_widget(_,[winner=Status],W),
		(ending(Status,W) -> true;true),
		change_widget(_,[color=C],W)
	    ;
		message(W,'No move available')
	).

other_color(white,black).
other_color(black,white).

ending(computer,W) :-  message(W,'Could it be that I won?').
ending(human,W) :-  message(W,'Congratulatons, you won !!').

invalid_move(W) :- 
	(get_attr(W,invalid_move,N) ->
	    ((0 is N mod 2; N>10) ->
		message(W,'Invalid Move')
	    ;
		bell(100),bell(100)
	    ),
	    M is N+1,
	    set_attr(W,invalid_move,M)
	;
	    bell(100),bell(100),bell(100),
	    set_attr(W,invalid_move,1)
	).


message(W,M) :-
	TW=300,
	TH=80,
	new_widget(message,[
		x=(W~width-TW)/2,
		y=(W~height-TH)/2,
    		parent=W,
		message=M
	    ],_).

dialog(W,M,F,C) :-
	TW=300,
	TH=100,
	new_widget(dialog,[
		x=(W~width-TW)/2,
		y=(W~height-TH)/2,
    		parent=W,
		message=M,
		callback(F)=C
	    ],_).



/* menu callbacks */

save_game(W,File) :-
	(tell(File) -> 
	    (save_attribute(A),
		current_widget(_,[A=V],W),
	    	(A=tab -> write_tab(V); format('~w.~n',[A=V])),
	    	fail
	    ;
		told)
	    ;
	    message(W,'Cannot write to file '(File))
	).

save_attribute(tab).
save_attribute(color).


write_tab(T) :- write(tab), write('=['), nl, write_tab0(T), write('].'), nl.

write_tab0([L|R]) :- put(9), write(L),write_tab1(R).

write_tab1([]) :- nl.
write_tab1([L|R]) :- write(','), nl, put(9), write(L), write_tab1(R).

load_game(W,File) :-
	(see(File) -> 
	    (repeat,
	    	read(T),
		load_term(T,W),
		T=end_of_file, !, 
		seen
	    )
	    ;
	    message(W,'Cannot read from file '(File))
	).

load_term(end_of_file,_) :- !.
load_term(A=V,W) :- !,	change_widget(_,[A=V],W).
load_term(T,W) :- message(W,'Invalid attribute '(T)).


set_level(L,W,M,I) :-
	current_widget(_,[level_item=O],W),
	toggle_menu_item(M,O),
	toggle_menu_item(M,I),
	change_widget(_,[level_item=I,level=L],W).
	
new_game(W) :-
	change_widget(_,[cursor=watch],W),
	current_widget(_,[play_first=PF,color=C],W),
	new_tab(T),
	change_widget(_,[tab=T],W),
	(PF=false ->	otherwise; reply(T,C,W)),
	(C=white->Cursor=circle;Cursor=dot),
	change_widget(_,[cursor=Cursor],W).

play_first(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[play_first=true],W) ->
		change_widget(_,[play_first=false],W)
	;
		change_widget(_,[play_first=true],W)
	).

against(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[against=computer],W) ->
		change_widget(_,[against=human],W)
	;
		change_widget(_,[against=computer],W)
	).

change_color(W,M,I) :-
	toggle_menu_item(M,I),
	(current_widget(_,[color=white],W) ->
		change_widget(_,[color=black],W)
	;
		change_widget(_,[color=white],W)
	).

no_move(W) :-
	current_widget(_,[tab=T,color=C],W),
	reply(T,C,W).
	


/* utils */


show_tab(OT,T,W) :- 
	show_tab_(OT,T,W,1),
	show_board(W,T).

show_board(W,T) :-
	current_widget(_,[color=Color,board=B,level=Lv,board_size=BS],W),
	static_evaluation(T,V,Wh,Bl), 
	Diff is Wh - Bl,
	Total is Wh + Bl,
	clear_widget(B),
	draw(B,writeterm(5,30,color=Color)),
	draw(B,writeterm(5,60,Lv)),
	draw(B,writeterm(5,90,total=Total)),
	draw(B,writeterm(5,120,diff=Diff)),
	draw(B,writeterm(5,150,eval=V)),

	(Total is BS*BS -> 
	    (Bl > Wh ->
		(Color=black ->  Winner=human; Winner=computer)
	    ;
	        (Color=white ->  Winner=human; Winner=computer)
	    )
	;
		Winner=none
	    ),
	set_attr(W,winner,Winner).


show_tab_([],[],_W,_I).
show_tab_([OR|OC],[R|C],W,I) :- 
	show_tab_(OR,R,W,I,1),
	NI is I+1,
	show_tab_(OC,C,W,NI).

show_tab_([],[],_W,_I,_J).
show_tab_([OE|OC],[E|C],W,I,J) :- 
	(OE=E -> otherwise
	;
		current_widget(_,[piece(I,J)=P],W),
		change_widget(_,[status=E],P)
	),
	NJ is J+1,
	show_tab_(OC,C,W,I,NJ).


trace(_T,_L) :- !.
trace(T,L) :- 
	W=reversi,
	(current_widget(_,[trace=true,board=B,tab=OT],W) ->
		show_tab(OT,T),
		change_widget(_,[tab=T],reversi),
		draw(B,writeterm(5,90,level=L)),
		new_widget(button,[
			parent=B,
			x=5,
			y=120,
			width=B~width-12,
			text='Go on',
			callback=go_on(Bt)
		],Bt),
		dispatch:inner_loop
			
	;
		otherwise
	).

go_on(Bt) :- exit_loop, kill_widget(_,[],Bt).
