
:- module(piece,[]).

:- ensure_loaded(library(ytoolkit)).
:- ensure_loaded(library('behaviors/pressable')).


default(border,1).
default(border_pixel,black).
default(line_width,3).


layout :-  
	get_attr(status,S),
	make_piece(S).	

make_piece(empty) :- clear_widget.
make_piece(white) :- draw(circle(width/2,height/2,width/2-4)).
make_piece(black) :- draw(fcircle(width/2,height/2,width/2-4)).

change_attr(status,_,S) :- clear_widget, make_piece(S).

behavior(A,B) :- pressable(A,B).

