
:- ensure_loaded(turtle).

teste :- 
	read_params,
	leaf(default,400).

leaf(Type,Size) :-
	clear,
	home,
	get_turtle(_,Y,H), YY is 3/2*Y,
	set_turtle(50,YY,H),
	rt(10),

	pe(Size),
	rest(Type,Size).



pe(Size) :-
	gc(leave,[line_width=2]),
	A=0.015*Size, B=Size/4, pi(PI),
	W1 is A*A+B*B, sqrt(W1,C),
	W2 is B/C, acos(W2,W3), D is W3/ PI * 180,
	rt(90),	fd(A),
	rt(-90), rt(-D), fd(C),
	rt(180), rt(D), fd(B),
	rt(90), fd(A),
	rt(90), rt(D), fd(C),
	rt(-D),
	gc(leave,[line_width=0]).



rest(Type,Size) :-
	get_turtle(Xo,Yo,_),
	nerv(Type,Size,Xo+Yo,Xl+Yl),
	border(Xo,Yo,Xl,Yl).

nerv(Type,Size,Po,Xz+Yz) :-
	divide(Type,Size,LL),
	nervs(LL,Type,Po,Xw+Yw),
	get_turtle(Xz,Yz,_),
	border(Xw,Yw,Xz,Yz).

nervs([],_,P,P).
nervs([L|R],Type,Pa,Pz) :-
	param(Type,A,_,_,_,E),
	LE is L*E,
	fd(L),
	get_turtle(X,Y,H),
	rt(A),
	nerv(Type,LE,Pa,Pb),
	set_turtle(X,Y,H),
	nervs(R,Type,Pb,Pc),
	set_turtle(X,Y,H),
	rt(-A),
	nerv(Type,LE,Pc,Pz).


/*
divide(Type,L,[]) :- param(Type,_,M,_,_,_), L<M, !.
divide(_,L,[A,B,C,D]) :- A is L/4, B is L/5, C is L/6, D is L/7.
*/

divide(Type,L,[]) :- param(Type,_,M,_,_,_), L<M, !.
divide(Type,L,[F|R]) :- 
	param(Type,_,_,P,Q,_),
	F is L * P,
	C is L * (1-P)*Q,
	divide(Type,C,R).


border(Xo,Yo,Xl,Yl) :-
	gc(leave,[line_width=2]),
	iline(Xo,Yo,Xl,Yl),
	gc(leave,[line_width=0]).


read_params :-
	recorded(param,param(A,M,P,Q,E),Ref), erase(Ref),
	format('A=(~w)',A), read(AA),(AA=A;true),
	format('M=(~w)',M), read(MM),(MM=M;true),
	format('P=(~w)',P), read(PP),(PP=P;true),
	format('Q=(~w)',Q), read(QQ),(QQ=Q;true),
	format('E=(~w)',E), read(EE),(EE=E;true),
	!,
	recorda(param,param(AA,MM,PP,QQ,EE),_).

param(a,60,20,0.2,0.9,2.3).
param(b,80,10,0.33,1,1.5).
param(c,45,10,0.33,1,1.5).
param(d,60,10,0.33,1,1.5).
param(e,60,5,0.29,1.1,1.4).

param(default,A,B,C,D,E) :- recorded(param,param(A,B,C,D,E),_).

:- recorded(param,_,R),erase(R),fail;
	recorda(param,param(60,10,0.33,1,1.5),_).




:- write(' ?- leaf(Type,Size).		Type in {a,d,c,d,e}'), nl.





