/***************************************************************************/
/***************************************************************************/
/**                                                                       **/
/**                       Simple Lisp FIle Editor                         **/
/**      Adapted from examples in MS Windows Guide to Programming         **/
/**                                                                       **/
/***************************************************************************/
/***************************************************************************/

// *** paste/send into xlispstat (eval-selection) with DDE stuff
// *** search facility

#include <windows.h>
#include <dde.h>
#include <string.h>
#include <stdio.h>
#include <fcntl.h>
#include <io.h>
#include <sys\types.h>
#include <sys\stat.h>
#include "winutils.h"
#include "ledit.h"
#include "lspedit.h"

HANDLE hInst;
HWND hWnd;
HANDLE hAccTable;
HWND hEditWnd;
char FileName[128];
char PathName[128];
char OpenName[128];
char DefPath[128];
char DefSpec[13] = "*.*";
char DefExt[] = ".lsp";
char str[255];
HANDLE hEditBuffer;
HANDLE hOldBuffer;
HANDLE hHourGlass;
HANDLE hSaveCursor;
int hFile;
int count;
PSTR pBuffer;
OFSTRUCT OfStruct;
struct stat FileStatus;
BOOL bChanges = FALSE;
BOOL bSaveEnabled = FALSE;
PSTR pEditBuffer;

char Untitled[] = "LSPEdit - (untitled)";

FILE *fp;

HWND hXLSserver = NULL;
BOOL DDEclosing = FALSE, DDEopening = FALSE;
ATOM atomXLS, atomEval;
HANDLE hPokeData = NULL;

static void open_initial_file(void);

int PASCAL WinMain(HANDLE hInstance,
		   HANDLE hPrevInstance,
		   LPSTR lpCmdLine,
		   int nCmdShow)
{
  MSG msg;
  int i;

  /* Try to cooperate with other running instances of the application */
  if (!hPrevInstance)
    if (!InitApplication(hInstance))
      return(FALSE);

  /* initialize the specific instance */
  if (!InitInstance(hInstance, nCmdShow))
    return(FALSE);

  /* open an initial file if there is a command line argument */
  while (isspace(*lpCmdLine)) lpCmdLine++;
  for (i = 0; lpCmdLine[i] != '\0' && ! isspace(lpCmdLine[i]) && i < 128-1; i++)
    OpenName[i] = lpCmdLine[i];
  OpenName[i] = '\0';
  open_initial_file();

  /* process messages until a WM_QUIT message */
  while (GetMessage(&msg, NULL, NULL, NULL)) {
    if (! TranslateAccelerator(hWnd, hAccTable, &msg)) {
      TranslateMessage(&msg);
      DispatchMessage(&msg);
    }
  }
  return(msg.wParam);
}

BOOL InitApplication(HANDLE hInstance)
{
  WNDCLASS wc;

  /* fill in the class structure for the main window */
  wc.style = NULL;
  wc.lpfnWndProc = MainWndProc;
  wc.cbClsExtra = 0;
  wc.cbWndExtra = 0;
  wc.hInstance = hInstance;
  wc.hIcon = LoadIcon(hInstance, "LEditIcon");
  wc.hCursor = LoadCursor(NULL, IDC_ARROW);
  wc.hbrBackground = GetStockObject(WHITE_BRUSH);
  wc.lpszMenuName = "LSPEditMenu";
  wc.lpszClassName = "LSPEditWClass";

  /* register the window class and return result code */
  return(RegisterClass(&wc));
}

BOOL InitInstance(HANDLE hInstance, int nCmdShow)
{
  hInst = hInstance;

  _fmode = O_BINARY;

  hHourGlass = LoadCursor(hInstance, IDC_WAIT);
  InitLEditClass(NULL);

  /* create a main window for this instance */
  hWnd = CreateWindow("LSPEditWClass",
		      Untitled,
		      WS_OVERLAPPEDWINDOW,
		      CW_USEDEFAULT,
		      CW_USEDEFAULT,
		      CW_USEDEFAULT,
		      CW_USEDEFAULT,
		      NULL,
		      NULL,
		      hInstance,
		      NULL);

  hEditWnd = CreateLEditWindow(hWnd, IDC_EDIT, hInstance);
  if (! hEditWnd) {
    DestroyWindow(hWnd);
    return(NULL);
  }

  hAccTable = LoadAccelerators(hInst, "LSPEdit");

  /* if the window could not be created, return failure code */
  if (! hWnd) return(FALSE);

  /* make the window visible, update it, and return success */
  ShowWindow(hWnd, nCmdShow);
  UpdateWindow(hWnd);
  return(TRUE);
}

long FAR PASCAL MainWndProc(HWND hWnd,
			    unsigned message,
			    WORD wParam,
			    LONG lParam)
{
  FARPROC lpProcAbout;
  FARPROC lpOpenDlg, lpSaveAsDlg;
  int Success, IOStatus;

  switch(message) {
  case WM_COMMAND:
    switch (wParam) {
    case IDM_ABOUT:
      lpProcAbout = MakeProcInstance(About, hInst);
      DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
      FreeProcInstance(lpProcAbout);
      break;

    case IDM_NEW:
      if (! QuerySaveFile(hWnd)) return(NULL);
      bChanges = FALSE;
      FileName[0] = 0;
      SetNewBuffer(hWnd, NULL, Untitled);
      break;
    case IDM_OPEN:
      if (! QuerySaveFile(hWnd)) return(NULL);
      lpOpenDlg = MakeProcInstance((FARPROC) OpenDlg, hInst);
      hFile = DialogBox(hInst, "Open", hWnd, lpOpenDlg);
      FreeProcInstance(lpOpenDlg);
      if (hFile <= 0) return(NULL);
      hEditBuffer = LocalAlloc(LMEM_MOVEABLE | LMEM_ZEROINIT,
			       FileStatus.st_size + 1);
      if (! hEditBuffer) {
	MessageBox(hWnd, "Not enough memory.", NULL, MB_OK | MB_ICONHAND);
	return(NULL);
      }
      hSaveCursor = SetCursor(hHourGlass);
      pEditBuffer = LocalLock(hEditBuffer);
//      IOStatus = read(hFile, pEditBuffer, FileStatus.st_size);
      close(hFile);
      /*** OpenFile seems to insist on using default _fmode = O_TEXT ***/
      fp = fopen(OpenName, "r");
      IOStatus = fread(pEditBuffer, 1, FileStatus.st_size, fp);
      fclose(fp);
      if (IOStatus != FileStatus.st_size) {
	sprintf(str, "Error reading %s.", FileName);
	SetCursor(hSaveCursor);
	MessageBox(hWnd, str, NULL, MB_OK | MB_ICONEXCLAMATION);
	LocalUnlock(hEditBuffer);
	LocalFree(hEditBuffer);
	return(NULL);
      }
      LocalUnlock(hEditBuffer);
      sprintf(str, "LSPEdit - %s", FileName);
      SetNewBuffer(hWnd, hEditBuffer, str);
      SetCursor(hSaveCursor);
      break;
    case IDM_SAVE:
      if (! FileName[0]) goto saveas;
      if (bChanges) SaveFile(hWnd);
      break;
    case IDM_SAVEAS:
saveas:
      lpSaveAsDlg = MakeProcInstance(SaveAsDlg, hInst);
      Success = DialogBox(hInst, "SaveAs", hWnd, lpSaveAsDlg);
      FreeProcInstance(lpSaveAsDlg);
      if (Success == IDOK) {
	sprintf(str, "LSPEdit - %s", FileName);
	if (SaveFile(hWnd)) SetWindowText(hWnd, str);
      }
      break;
    case IDM_PRINT:
      MessageBox(GetFocus(),
		 "Command Not Implemented",
		 "LSPEdit",
		 MB_ICONASTERISK | MB_OK);
      break;
    case IDM_EXIT:
      if (! QuerySaveFile(hWnd)) return(NULL);
      DestroyWindow(hWnd);
      break;

    case IDM_UNDO:
      WarningBox("Command Not Implemented");
      break;
    case IDM_CUT:
      TTYSelToClip();
      TTYClearSel();
      break;
    case IDM_COPY:
      TTYSelToClip();
      break;
    case IDM_PASTE:
      TTYPasteFromClip();
      break;
    case IDM_CLEAR:
      TTYClearSel();
      break;
    case IDM_EVAL:
      if (hXLSserver)
	return(MessageBox(hWnd, "Conversation already in progress",
			  "LSPEdit", MB_ICONASTERISK | MB_OK));
      if (! TTYHasSelection()) {
	SysBeep(10);
	break;
      }
      DDEopening = TRUE;
      atomXLS = GlobalAddAtom("XLISP-STAT");
      atomEval = GlobalAddAtom("Eval");
      SendMessage(-1, WM_DDE_INITIATE, hWnd, MAKELONG(atomXLS, atomEval));
      GlobalDeleteAtom(atomXLS);
      GlobalDeleteAtom(atomEval);
      DDEopening = FALSE;
      if (hXLSserver) {
	/*** poke through the data ***/
	hPokeData = TTYSelectionPokeData();
	PostMessage(hXLSserver, WM_DDE_POKE, hWnd, hPokeData);
      }
      else
	MessageBox(hWnd, "Cannot connect to XLISP-STAT",
		   "LSPEdit", MB_ICONASTERISK | MB_OK);
      break;
    case IDC_EDIT:
      if (HIWORD(lParam) == EN_ERRSPACE) {
	MessageBox(GetFocus(),
		   "Out of memory",
		   "LSPEdit",
		   MB_ICONASTERISK | MB_OK);
      }
      if (HIWORD(lParam) == EN_CHANGE) bChanges = TRUE;
      break;
    default: return(DefWindowProc(hWnd, message, wParam, lParam));
    }
    break;
  case WM_DDE_ACK:
    if (DDEopening) {
      if (! hXLSserver && atomXLS == LOWORD(lParam) && atomEval == HIWORD(lParam)) {
	hXLSserver = wParam;
	GlobalDeleteAtom(LOWORD(lParam));
	GlobalDeleteAtom(HIWORD(lParam));
      }
      else PostMessage(wParam, WM_DDE_TERMINATE, hWnd, 0);
    }
    else if (wParam == hXLSserver && ! DDEclosing) {
      if (hPokeData) {
	GlobalFree(hPokeData);
	hPokeData = NULL;
      }
      DDEclosing = TRUE;
      PostMessage(hXLSserver, WM_DDE_TERMINATE, hWnd, 0);
    }
    break;
  case WM_DDE_TERMINATE:
    if (DDEclosing) {
      hXLSserver = NULL;
      DDEclosing = FALSE;
    }
    break;
  case WM_SETFOCUS:
    SetFocus(hEditWnd);
    break;
  case WM_SIZE:
    MoveWindow(hEditWnd, 0, 0, LOWORD(lParam), HIWORD(lParam), TRUE);
    break;
  case WM_QUERYENDSESSION:
    return(QuerySaveFile(hWnd));
  case WM_CLOSE:
    if (QuerySaveFile(hWnd)) DestroyWindow(hWnd);
    break;
  case WM_DESTROY:
    PostQuitMessage(0);
    break;
  default:
    return(DefWindowProc(hWnd, message, wParam, lParam));
  }
  return(NULL);
}

BOOL FAR PASCAL About(HWND hDlg, unsigned message, WORD wParam, LONG lParam)
{
  switch(message) {
  case WM_INITDIALOG:
    return(TRUE);
  case WM_COMMAND:
    if (wParam == IDOK || wParam == IDCANCEL) {
      EndDialog(hDlg, TRUE);
      return(TRUE);
    }
    else break;
  }
  return(FALSE);
}

HANDLE FAR PASCAL OpenDlg(HWND hDlg,
			  unsigned message,
			  WORD wParam,
			  LONG lParam)
{
  WORD index;
  PSTR pTptr;
  HANDLE hFile;

  switch (message) {
  case WM_COMMAND:
    switch (wParam) {
    case IDC_LISTBOX:
      switch (HIWORD(lParam)) {
      case LBN_SELCHANGE:
	if (! DlgDirSelect(hDlg, str, IDC_LISTBOX)) {
	  SetDlgItemText(hDlg, IDC_EDIT, str);
	  SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, NULL,
			     MAKELONG(0, 0x7fff));
	}
	else {
	  strcat(str, DefSpec);
	  DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);
	}
	break;
      case LBN_DBLCLK:
	goto openfile;
      }
      return(TRUE);
    case IDOK:
openfile:
      GetDlgItemText(hDlg, IDC_EDIT, OpenName, 128);
      if (strchr(OpenName, '*') || strchr(OpenName, '?')) {
	SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec, (LPSTR) OpenName);
	if (str[0]) strcpy(DefPath, str);
	ChangeDefExt(DefExt, DefSpec);
	UpdateListBox(hDlg);
	return(TRUE);
      }
      if (! OpenName[0]) {
	MessageBox(hDlg, "No filename specified.", NULL,
		   MB_OK | MB_ICONQUESTION);
	return(TRUE);
      }
      AddExt(OpenName, DefExt);
      if ((hFile = OpenFile(OpenName, (LPOFSTRUCT) &OfStruct, OF_READ)) < 0) {
	sprintf(str, "Error %d opening %s.", OfStruct.nErrCode, OpenName);
	MessageBox(hDlg, str, NULL, MB_OK | MB_ICONHAND);
      }
      else {
	fstat(hFile, &FileStatus);
	if (FileStatus.st_size > MAXFILESIZE) {
	  sprintf(str, "Not enough memory to load %s.\n%s exceeds %ld bytes",
		  OpenName, OpenName, MAXFILESIZE);
	  MessageBox(hDlg, str, NULL, MB_OK | MB_ICONHAND);
	  return(TRUE);
	}
	strcpy(FileName, OpenName);
	EndDialog(hDlg, hFile);
	return(TRUE);
      }
      EndDialog(hDlg, NULL);
      return(TRUE);
    case IDCANCEL:
      EndDialog(hDlg, NULL);
      return(TRUE);
    }
    break;
  case WM_INITDIALOG:
    UpdateListBox(hDlg);
    SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
    SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, NULL, MAKELONG(0, 0x7fff));
    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
    return(FALSE);
  }
  return(FALSE);
}

int FAR PASCAL SaveAsDlg(HWND hDlg,
			 unsigned message,
			 WORD wParam,
			 LONG lParam)
{
  char TempName[128];

  switch (message) {
  case WM_INITDIALOG:
    if (! FileName[0]) bSaveEnabled = FALSE;
    else {
      bSaveEnabled = TRUE;
      DlgDirList(hDlg, DefPath, NULL, IDC_PATH, 0x4010);
      SetDlgItemText(hDlg, IDC_EDIT, FileName);
      SendDlgItemMessage(hDlg, IDC_EDIT, EM_SETSEL, 0, MAKELONG(0, 0x7fff));
    }
    EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled);
    SetFocus(GetDlgItem(hDlg, IDC_EDIT));
    return(FALSE);
  case WM_COMMAND:
    switch (wParam) {
    case IDC_EDIT:
      if (HIWORD(lParam) == EN_CHANGE && ! bSaveEnabled)
	EnableWindow(GetDlgItem(hDlg, IDOK), bSaveEnabled = TRUE);
      return(TRUE);
    case IDOK:
      GetDlgItemText(hDlg, IDC_EDIT, TempName, 128);
      if (CheckFileName(hDlg, (PSTR) FileName, (PSTR) TempName)) {
	SeparateFile(hDlg, (LPSTR) str, (LPSTR) DefSpec, (LPSTR) FileName);
	if (str[0]) strcpy(DefPath, str);
	EndDialog(hDlg, IDOK);
      }
      return(TRUE);
    case IDCANCEL:
      EndDialog(hDlg, IDCANCEL);
      return(TRUE);
    }
    break;
  }
  return(FALSE);
}

void UpdateListBox(HWND hDlg)
{
  strcpy(str, DefPath);
  strcat(str, DefSpec);
  DlgDirList(hDlg, str, IDC_LISTBOX, IDC_PATH, 0x4010);
  SetDlgItemText(hDlg, IDC_EDIT, DefSpec);
}

void SeparateFile(HWND hDlg,
		  LPSTR lpDestPath,
		  LPSTR lpDestFileName,
		  LPSTR lpSrcFileName)
{
  LPSTR lpTmp;
  char cTmp;

  lpTmp = lpSrcFileName + (long) lstrlen(lpSrcFileName);

  while (*lpTmp != ':' && *lpTmp != '\\' && lpTmp > lpSrcFileName)
    lpTmp = AnsiPrev(lpSrcFileName, lpTmp);

  if (*lpTmp != ':' && *lpTmp != '\\') {
    lstrcpy(lpDestFileName, lpSrcFileName);
    lpDestPath[0] = 0;
    return;
  }
  lstrcpy(lpDestFileName, lpTmp + 1);
  cTmp = *(lpTmp + 1);
  lstrcpy(lpDestPath, lpSrcFileName);
  *(lpTmp + 1) = cTmp;
  lpDestPath[(lpTmp - lpSrcFileName) + 1] = 0;
}

void ChangeDefExt(PSTR Ext, PSTR Name)
{
  PSTR pTptr;

  pTptr = Name;
  while (*pTptr && *pTptr != '.') pTptr++;
  if (*pTptr)
    if (! strchr(pTptr, '*') && ! strchr(pTptr, '?'))
      strcpy(Ext, pTptr);
}

void AddExt(PSTR Name, PSTR Ext)
{
  PSTR pTptr;

  pTptr = Name;
  while (*pTptr && *pTptr != '.') pTptr++;
  if (*pTptr != '.') strcat(Name, Ext);
}

BOOL CheckFileName(HWND hWnd, PSTR pDest, PSTR pSrc)
{
  PSTR pTmp;

  if (! pSrc[0]) return(FALSE);

  pTmp = pSrc;
  while (*pTmp) {
    switch (*pTmp++) {
    case '*':
    case '?':
      MessageBox(hWnd, "Wildcards not allowed.", NULL, MB_OK | MB_ICONEXCLAMATION);
      return(FALSE);
    }
  }

  AddExt(pSrc, DefExt);

  if (OpenFile(pSrc, (LPOFSTRUCT) & OfStruct, OF_EXIST) >= 0) {
    sprintf(str, "Replace existing %s?", (LPSTR) pSrc);
    if (MessageBox(hWnd, str, "LSPEdit", MB_OKCANCEL | MB_ICONHAND) == IDCANCEL)
      return(FALSE);
  }
  strcpy(pDest, pSrc);
  return(TRUE);
}

BOOL SaveFile(HWND hWnd)
{
  BOOL bSuccess;
  int IOStatus, length;

  if ((hFile = OpenFile(FileName, &OfStruct,
			OF_PROMPT | OF_CANCEL | OF_CREATE)) < 0) {
    sprintf(str, "Cannot write to %s.", FileName);
    MessageBox(hWnd, str, NULL, MB_OK | MB_ICONEXCLAMATION);
    return(FALSE);
  }
  hEditBuffer = SendMessage(hEditWnd, EM_GETHANDLE, 0, 0);
  pEditBuffer = LocalLock(hEditBuffer);
  hSaveCursor = SetCursor(hHourGlass);
  length = SendMessage(hEditWnd, WM_GETTEXTLENGTH, 0, 0);
//  IOStatus = write(hFile, pEditBuffer, strlen(pEditBuffer));
  close(hFile);
  fp = fopen(FileName, "w");
  IOStatus = fwrite(pEditBuffer, 1, length, fp);
  fclose(fp);
  SetCursor(hSaveCursor);
  if (IOStatus != length) {
    sprintf(str, "Error writing to %s.", FileName);
    MessageBox(hWnd, str, NULL, MB_OK | MB_ICONHAND);
    bSuccess = FALSE;
  }
  else {
    bSuccess = TRUE;
    bChanges = FALSE;
  }
  LocalUnlock(hEditBuffer);
  return(bSuccess);
}

BOOL QuerySaveFile(HWND hWnd)
{
  int Response;
  FARPROC lpSaveAsDlg;

  if (bChanges) {
    sprintf(str, "Save current changes: %s", FileName);
    Response = MessageBox(hWnd, str, "LSPEdit",
			  MB_YESNOCANCEL | MB_ICONEXCLAMATION);
    if (Response == IDYES) {
check_name:
      if (! FileName[0]) {
	lpSaveAsDlg = MakeProcInstance(SaveAsDlg, hInst);
	Response = DialogBox(hInst, "SaveAs", hWnd, lpSaveAsDlg);
	FreeProcInstance(lpSaveAsDlg);
	if (Response == IDOK) goto check_name;
	else return(FALSE);
      }
      return(SaveFile(hWnd));
    }
    else if (Response == IDCANCEL)
      return(FALSE);
  }
  else return(TRUE);
}

void SetNewBuffer(HWND hWnd, HANDLE hNewBuffer, PSTR Title)
{
  HANDLE hOldBuffer;

  hOldBuffer = SendMessage(hEditWnd, EM_GETHANDLE, 0, 0);
  LocalFree(hOldBuffer);
  if (!hNewBuffer)
    hNewBuffer = LocalAlloc(LMEM_MOVEABLE | LMEM_ZEROINIT, 1);
  SendMessage(hEditWnd, EM_SETHANDLE, hNewBuffer, 0);
  InvalidateRect(hEditWnd, NULL, TRUE);
  UpdateWindow(hEditWnd);
  SetWindowText(hWnd, Title);
  SetFocus(hEditWnd);
  bChanges = FALSE;
}

static void open_initial_file(void)
{
  int IOStatus;

  if (strchr(OpenName, '*') || strchr(OpenName, '?')) OpenName[0] = 0;
  if (! OpenName[0]) return;
  AddExt(OpenName, DefExt);
  if ((hFile = OpenFile(OpenName, (LPOFSTRUCT) &OfStruct, OF_READ)) < 0) {
    sprintf(str, "Error %d opening %s.", OfStruct.nErrCode, OpenName);
    MessageBox(hWnd, str, NULL, MB_OK | MB_ICONHAND);
  }
  else {
    fstat(hFile, &FileStatus);
    if (FileStatus.st_size > MAXFILESIZE) {
      sprintf(str, "Not enough memory to load %s.\n%s exceeds %ld bytes",
	      OpenName, OpenName, MAXFILESIZE);
      MessageBox(hWnd, str, NULL, MB_OK | MB_ICONHAND);
      return;
    }
    strcpy(FileName, OpenName);
    if (hFile == -1) return;
    hEditBuffer = LocalAlloc(LMEM_MOVEABLE | LMEM_ZEROINIT,
			     FileStatus.st_size + 1);
    if (! hEditBuffer) {
      MessageBox(hWnd, "Not enough memory.", NULL, MB_OK | MB_ICONHAND);
      return;
    }
    hSaveCursor = SetCursor(hHourGlass);
    pEditBuffer = LocalLock(hEditBuffer);
//    IOStatus = read(hFile, pEditBuffer, FileStatus.st_size);
    close(hFile);
    /*** OpenFile seems to insist on using default _fmode = O_TEXT ***/
    fp = fopen(OpenName, "r");
    IOStatus = fread(pEditBuffer, 1, FileStatus.st_size, fp);
    fclose(fp);
    if (IOStatus != FileStatus.st_size) {
      sprintf(str, "Error reading %s.", FileName);
      SetCursor(hSaveCursor);
      MessageBox(hWnd, str, NULL, MB_OK | MB_ICONEXCLAMATION);
      LocalUnlock(hEditBuffer);
      LocalFree(hEditBuffer);
      return;
    }
    LocalUnlock(hEditBuffer);
    sprintf(str, "LSPEdit - %s", FileName);
    SetNewBuffer(hWnd, hEditBuffer, str);
    SetCursor(hSaveCursor);
  }
}
