;(expand 20)

(load "../cmplsp/common")
(load "../cmplsp/loadfsl")
(load "../cmplsp/conditns")

(push :packages *features*)
(push :times *features*)
(push :posfcns *features*)
(push :math *features*)
(push :mulvals *features*)

(xlisp::use-conditions)

(defpackage "XLSCMP"
  (:use "XLISP")
  (:import-from "XLISP" "*CMP-SETF*" "ADD-METHOD" "CMP-DO-DEFSTRUCT"))

(setf xlisp::*default-path* nil)

(cond
 ((probe-file "cmpfront.fsl") (load "cmpfront"))
 (t (load "../compiler/backquot")
    (load "../compiler/cmpmacro")
    (load "../compiler/convert")
    (load "../compiler/cells")
    (load "../compiler/simplify")
    (load "../compiler/lift")
    (load "../compiler/gencode")
    (load "../compiler/peephole")
    (load "../compiler/assemble")
    (load "../compiler/cmpfront")))

(in-package "XLISP")

(export '(compiler-let define-setf-method define-modify-macro locally))
(export '(save restore))

(setf *startup-functions* '(use-conditions))
