;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;
;;;;;                        Peephole Optimizer
;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; Currently only used for jump tensioning, dead code elimination, and
;;;; elimination of redundant copies. Based loosely on the one in Peter
;;;; Norvig's book, but not yet data-driven in design. Data-driven dispatch
;;;; is only worth adding if more optimizations are needed.
;;;;
;;;; The optimizer receives a list of code and literals. Code is a list of
;;;; instructions. Each instruction is a symbol, representing a label, or
;;;; a list of a symbol, representing an opcode, followed by numbers or
;;;; symbols.
;**** fun info; funs argument??

(in-package "XLSCMP")

(defun peephole-optimize (cl funs)
  (loop (if (not (peephole-optimize-one cl funs)) (return cl))))

(defun peephole-optimize-one (cl funs)
  (do* ((all-code (first cl))
	(code all-code (rest code))
	(instr (first code) (first code))
	(changed nil))
       ((or changed (null code)) changed)
       (setf changed
	     (cond
	      ((consp instr) ;;**** use cond, variable for tests
	       (case (first instr)
	         (%copy (drop-copy-if-same instr code all-code))
		 ((%test-1 %test-2 %test-arith-2)
		  (tension-test-jump instr code all-code))
		 (%goto
		  (tension-goto instr code all-code))))
	      ((not (member instr funs))
	       (drop-label-if-not-used instr code all-code))))))

(defun find-target (label code)
  (dolist (c (rest (member label code)) (error "no code after ~s" label))
    (if (consp c) (return c))))

(defun drop-label-if-not-used (label code all-code)
  (when (not (find label all-code
		   :test #'(lambda (x y) (if (consp y) (member x y)))))
	(setf (first code) (second code) (rest code) (rest (rest code)))
	t))

(defun drop-copy-if-same (instr code all-code)
  (when (= (second instr) (third instr))
	(setf (first code) (second code) (rest code) (rest (rest code)))
	t))

(defun tension-test-jump (instr code all-code)
  (let ((ct (find-target (third instr) all-code))
	(at (find-target (fourth instr) all-code))
	(changed nil))
    (when (eq '%goto (first ct))
	  (setf (third instr) (second ct))
	  (setf changed t))
    (when (eq '%goto (first at))
	  (setf (fourth instr) (second at))
	  (setf changed t))
    (when (drop-dead-code instr code all-code)
	  (setf changed t))
    changed))

(defun tension-goto (instr code all-code)
  (if (eq (second instr) (second code))
      (setf (first code) (second code) (rest code) (rest (rest code)))
      (let ((gt (find-target (second instr) all-code))
	    (changed nil))
	(when (eq '%goto (first gt))
	      (setf (second instr) (second gt))
	      (setf changed t))
	(when (drop-dead-code instr code all-code)
	      (setf changed t))
	changed)))

;;**** use loop here; is this ever called??
(defun drop-dead-code (instr code all-code)
  (when (and (consp (rest code)) (consp (second code)))
	(setf (rest code) (rest (rest code)))))
