;;
;; Some compiler/loader support
;;
;; needed by the compiler -- must appear before any defmeth's

(in-package "XLISP")

(defun add-method (object name method doc)
  (if doc (send object :internal-doc name doc))
  (send object :add-method name method))

;;**** this produces an interpreted function, but that should be fine.
;;**** the function cannot be compiled, since putting actual functions
;;**** in call position is illegal.
(defun cmp-make-structure-constructor (structname)
  (let ((slots (get structname '*struct-slots*)))
    (eval `#'(lambda (&key ,@slots)
	       (,#'%make-struct ',structname ,@(mapcar #'first slots))))))

(defun cmp-do-defstruct (structname incopt others slotargs)
  (let* ((pname (symbol-name structname))
	 (conc-name (concatenate 'string pname "-"))
	 (constrsym 0)
	 (predsym 0)
	 (parent-slots nil))

    ;; handle the include option
    (when incopt
	  (let ((parent (second incopt))
		(slotmods (rest (rest incopt))))
	    (setf parent-slots
		  (mapcar #'copy-list (get parent '*struct-slots*)))

	    ;; handle slot initialization overrides
	    (dolist (sp slotmods)
	      (let* ((sn (first sp))
		     (se (assoc sn parent-slots))
		     (sd (second sp)))
		(setf (second se) sd)))
	    (setf (get structname '*struct-include*) parent)))

    ;; handle the other options
    (dolist (opt others)
      (let ((optargs (rest opt)))
	(case (first opt)
	  (:conc-name
	   (let ((cname (first optargs)))
	     (setf conc-name (if cname (symbol-name cname) ""))))
	  (:print-function
	   (setf (get structname '*struct-print-function*) (first optargs)))
	  (:constructor
	   (setf constrsym (car optargs))
	   (setf (get structname '*struct-constructor*) constrsym))
	  (:predicate
	   (setf predsym (car optargs))
	   (setf (get structname '*struct-predicate*) predsym))
	  (t (error "unknown option - ~s" tmp)))))

    ;; install slots and make accessors and modifiers
    (let ((slots (append parent-slots slotargs))
	  (slotcount 1))
      (setf (get structname '*struct-slots*) slots)
      
      (dolist (sk slots)
        (let* ((sn (first sk))
	       (name (intern (concatenate 'string conc-name (symbol-name sn))))
	       (sd (second sk))
	       (i slotcount))
	  (setf (symbol-function name)
		#'(lambda (x) (%struct-ref x i)))
	  (remprop name '*setf*)
	  (setf (get name '*setf-lambda*)
		#'(lambda (x v) `(%struct-set ,x ,i ,v)))
	  (incf slotcount))))

    ;; enter the MAKE-xxx symbol
    (unless (symbolp constrsym)
	    (setf constrsym (intern (concatenate 'string "MAKE-" pname)))
	    (setf (get structname '*struct-constructor*) constrsym))
		  
    
    ;; make the MAKE-xxx function
    (unless (null constrsym)
	    (setf (symbol-function constrsym)
		  (cmp-make-structure-constructor structname)))
				    
    ;; enter the xxx-P symbol
    (unless (symbolp predsym)
	    (setf predsym (intern (concatenate 'string pname "-P"))) 
	    (setf (get structname '*struct-predicate*) predsym))

    ;; make the xxx-P function
    (unless (null predsym)
	    (setf (symbol-function predsym)
		  #'(lambda (x) (%struct-type-p structname x))))

    ;; make the COPY-xxx function
    (setf (symbol-function (intern (concatenate  'string "COPY-" pname)))
	  #'(lambda (x) (%copy-struct x)))

    structname))
