;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: (*SIM-I COMMON-LISP-GLOBAL); Muser: Yes -*-

(in-package '*sim-i :use '(lisp))

(defun char-bit!! (char-pvar name-pvar)
  (pvar-argument!! char-pvar character name-pvar char-bitspec)
  (safety-check
    (new-pvar-check char-pvar 'char-bit!!)
    (new-pvar-check name-pvar 'char-bit!!)
    )
  (incf-use-count 'char-bit!!)
  (let ((return-pvar (allocate-temp-general-pvar)))
    (when
      (with-selected-general-pvar-arrays (processor)
	(return-array char-array name-array)
	(return-pvar char-pvar name-pvar)
	(let* ((name (aref name-array processor)))
	  (if (and (integerp name) (<= 0 name 3))
	      (setq name (nth name '(:control :meta :super :hyper))))
	  (setf (aref return-array processor)
		(char-bit (aref char-array processor) name)))
	)
      (make-non-void return-pvar)
      )
    return-pvar
    ))

(defun set-char-bit!! (char-pvar name-pvar new-value-pvar)
  (pvar-argument!! char-pvar character name-pvar char-bitspec new-value-pvar boolean)
  (safety-check
    (new-pvar-check name-pvar 'set-char-bit!!)
    (new-two-pvar-check char-pvar new-value-pvar 'set-char-bit!!)
    )
  (incf-use-count 'set-char-bit!!)
  (let ((return-pvar (allocate-temp-general-pvar)))
    (when
      (with-selected-general-pvar-arrays
	(processor)
	(return-array char-array name-array new-value-array)
	(return-pvar char-pvar name-pvar new-value-pvar)
	(let* ((name (aref name-array processor)))
	  (if (and (integerp name) (<= 0 name 3))
	      (setq name (nth name '(:control :meta :super :hyper))))
	  (setf (aref return-array processor)
		(set-char-bit (aref char-array processor)
			      name
			      (aref new-value-array processor))))
	)
      (make-non-void return-pvar)
      )
    return-pvar
    ))



(defun equal!! (pvar1 pvar2)
  (equalp!! pvar1 pvar2))

(defun equalp!! (pvar1 pvar2)

  (simple-pvar-argument!! (pvar1 pvar2))
  
  (cond

    ((and (simple-general-pvar-p pvar1) (simple-general-pvar-p pvar2))

     (cond

       ((and (*and (numberp!! pvar1))
	     (*and (numberp!! pvar2)))
	(=!! pvar1 pvar2))
       
       (t (eql!! pvar1 pvar2))

       ))

    ((and (array-pvar-p pvar1) (array-pvar-p pvar2))
     (if (not (equal (array-pvar-dimensions pvar1) (array-pvar-dimensions pvar2)))
	 nil!!
	 (*let ((result t!!))
	   (with-many-array-elements-iterated (element1 element2) ((pvar-array pvar1) (pvar-array pvar2))
	     (*set result (and!! result (equalp!! element1 element2)))
	     )
	   result
	   )))

    ((and (structure-pvar-p pvar1) (structure-pvar-p pvar2))
     (if (not (eq (type-of (pvar-structure pvar1)) (type-of (pvar-structure pvar2))))
	 nil!!
	 (*let ((result t!!))
	   (with-structure-elements-iterated
	     ((slot1 slot2)
	      ((pvar-structure pvar1) (pvar-structure pvar2))
	      (structure-pvar-type-front-end-slot-accessors (pvar-canonical-pvar-type pvar1))
	      )
	     (*set result (and!! result (equalp!! slot1 slot2)))
	     )
	   result
	   )))

    ((or (and (simple-general-pvar-p pvar1) (or (array-pvar-p pvar2) (structure-pvar-p pvar2)))
	 (and (simple-general-pvar-p pvar2) (or (array-pvar-p pvar1) (structure-pvar-p pvar1)))
	 (and (array-pvar-p pvar1) (structure-pvar-p pvar2))
	 (and (structure-pvar-p pvar1) (array-pvar-p pvar2))
	 )
     nil!!
     )

    (t
     (*let (result)
       (do-for-selected-processors-internal (j)
	 (*setf (pref result j) (equalp (pref pvar1 j) (pref pvar2 j)))
	 )
       result
       ))

     ))


(setq *conversion-list*
    ;;; Elements of the form: (nametag declaration test [conversion optimization])
    ;;; listed in order of relative frequency of use of each data type.
    ;;; nametag is conversion tag used in pvar-argument!! to determine test needed
    ;;; declaration is how scalar value being converted should be declared
    ;;; test is a boolean test that checks for that scalar type
    ;;; conversion is an optional function that gets called on the scalar value
    ;;;   immediately prior to testing, to possibly convert it into a nicer form.
    ;;; optimization is an optional function that gets called on the scalar value
    ;;;   before (and independant of) testing, to allow possible optimizations that
    ;;;   make test unnecessary.
    '((float float floatp)
      (integer integer integerp)
      (boolean boolean booleanp nil boolean-optimize)
      (boolarg nil boolargp nil boolean-optimize)
      (complex complex complexp)
      (non-complex number non-complexp)
      (character character characterp)
      (number number numberp)
      (legal-pvar-value nil legal-pvar-valuep)
      (vector vector front-end-vector-p)
      (array array front-end-array-p)
      (*defstruct nil *defstructp)
      (*sequence vector *sequencep)
      (sf-vector vector sf-vectorp)
      (bit-array array bit-arrayp)
      (charint nil charintp)
      (char-bitspec integer char-bitspecp bitspec-to-integer)
      ;;; Bytespecs are a pain.
      (*bytespec 
           #-(AND LUCID *LISP-SIMULATOR) integer
           #+(AND LUCID *LISP-SIMULATOR) nil
           *bytespecp nil bytespec-optimize)
      (address-object nil address-object-p)
      (segment-set-object nil segment-set-objectp)
      ))

(defun bytespec-optimize (thingy)
  #+(AND LUCID *LISP-HARDWARE) ;; only need to convert Lucid bytespecs on hardware
  (if (eql (type-of thingy) *bytespec-type*)
      (setq thingy (constant-byte!! (byte-size thingy) (byte-position thingy))))
  #+(AND LUCID *LISP-SIMULATOR)
  (if (eql (type-of thingy) *bytespec-type*)
      (setq thingy (byte!! (!! (byte-size thingy)) (!! (byte-position thingy)))))
  thingy)

(defmacro def-trivial-one-arg-*lisp-functions (names-and-lisp-functions)
  `(progn
     (defun execute-trivial-one-arg-*lisp-function (name internal-name arg)
       (safety-check (new-pvar-check arg name))
       (let* ((return-pvar (allocate-temp-general-pvar))
	      (return-array (pvar-array return-pvar))
	      (arg-array (pvar-array arg))
	     )
	 (1-d-array-declaration arg-array return-array)
	 (when (funcall internal-name arg-array return-array)
	   (make-non-void return-pvar)
	   )
	 return-pvar
	))
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		   )
	       `(defun ,internal-name (pvar-array return-array)
		  (let ((pvar-array pvar-array) (return-array return-array))
		    (1-d-array-declaration pvar-array return-array)
		    #+(and lucid vax)
		    ,(when (eq lisp-function 'numberp)
		       `(declare (notinline ,lisp-function)))
		    (let ((any-set nil))
		      (do-for-selected-processors-internal (j)
			(setq any-set t)
			(setf (aref return-array j) (,lisp-function (aref pvar-array j)))
			)
		      any-set
		      )))))
	 names-and-lisp-functions
	)
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		   )
	       `(defun ,name (pvar)
		  (declare-pvar-arglist ,lisp-function)
		  ,(if (or (eql name 'byte-position!!)
			   (eql name 'byte-size!!))
		       '(pvar-argument!! pvar *bytespec)
		       '(simple-pvar-argument!! pvar))
		  (execute-trivial-one-arg-*lisp-function ',name ',internal-name pvar))
	      ))
	 names-and-lisp-functions
	)
     (note-trivial-macro ,@(mapcar #'car names-and-lisp-functions))
     ))

(defmacro def-trivial-two-arg-*lisp-functions (names-and-lisp-functions)
  `(progn
     (defun execute-trivial-two-arg-*lisp-function (name internal-name arg1 arg2)
       (safety-check (new-two-pvar-check arg1 arg2 name))
       (let* ((return-pvar (allocate-temp-general-pvar))
	      (return-array (pvar-array return-pvar))
	      (arg1-array (pvar-array arg1))
	      (arg2-array (pvar-array arg2))
	     )
	 (1-d-array-declaration arg1-array arg2-array return-array)
	 (when (funcall internal-name arg1-array arg2-array return-array)
	   (make-non-void return-pvar)
	   )
	 return-pvar
	))
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		    )
	       `(defun ,internal-name (pvar1-array pvar2-array return-array)
		  (let ((pvar1-array pvar1-array)
			(pvar2-array pvar2-array)
			(return-array return-array)
			)
		    (1-d-array-declaration pvar1-array pvar2-array return-array)
		    (let ((any-set nil))
		      (do-for-selected-processors-internal (j)
			(setq any-set t)
			(setf (aref return-array j)
			      (,lisp-function (aref pvar1-array j) (aref pvar2-array j)))
			)
		      any-set
		      )))))
	 names-and-lisp-functions
	)
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		   )
	       `(defun ,name (pvar1 pvar2)
		  (declare-pvar-arglist ,lisp-function)
		  ,(case name
		     ((ldb!! ldb-test!! mask-field!!)
		      '(pvar-argument!! pvar1 *bytespec pvar2 legal-pvar-value))
		     (otherwise '(simple-pvar-argument!! (pvar1 pvar2))))
		  (execute-trivial-two-arg-*lisp-function ',name ',internal-name pvar1 pvar2))
	      ))
	 names-and-lisp-functions
	)
     (note-trivial-macro ,@(mapcar #'car names-and-lisp-functions))
     ))


(defmacro def-trivial-three-arg-*lisp-functions (names-and-lisp-functions)
  `(progn
     (defun execute-trivial-three-arg-*lisp-function (name internal-name arg1 arg2 arg3)
       (safety-check (new-two-pvar-check arg1 arg2 name))
       (let* ((return-pvar (allocate-temp-general-pvar))
	      (return-array (pvar-array return-pvar))
	      (arg1-array (pvar-array arg1))
	      (arg2-array (pvar-array arg2))
	      (arg3-array (pvar-array arg3))
	     )
	 (1-d-array-declaration arg1-array arg2-array arg3-array return-array)
	 (when (funcall internal-name arg1-array arg2-array arg3-array return-array)
	   (make-non-void return-pvar)
	   )
	 return-pvar
	))
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		    )
	       `(defun ,internal-name (pvar1-array pvar2-array pvar3-array return-array)
		  (let ((pvar1-array pvar1-array)
			(pvar2-array pvar2-array)
			(pvar3-array pvar3-array)
			(return-array return-array)
			)
		    (1-d-array-declaration pvar1-array pvar2-array pvar3-array return-array)
		    (let ((any-set nil))
		      (do-for-selected-processors-internal (j)
			(setq any-set t)
			(setf (aref return-array j)
			      (,lisp-function (aref pvar1-array j) (aref pvar2-array j) (aref pvar3-array j))
			      ))
		      any-set
		      )))))
	 names-and-lisp-functions
	)
     ,@(mapcar
	 #'(lambda (name-and-lisp-function)
	     (let* ((name (car name-and-lisp-function))
		    (lisp-function (cadr name-and-lisp-function))
		    (internal-name (trivial-name name))
		   )
	       `(defun ,name (pvar1 pvar2 pvar3)
		  (declare-pvar-arglist ,lisp-function)
		  ,(case name
		     ((deposit-field!! dpb!!)
		      '(pvar-argument!! pvar2 *bytespec (pvar1 pvar3) integer))
		     (otherwise '(simple-pvar-argument!! (pvar1 pvar2 pvar3))))
		  (execute-trivial-three-arg-*lisp-function ',name ',internal-name pvar1 pvar2 pvar3))
	      ))
	 names-and-lisp-functions
	)
     (note-trivial-macro ,@(mapcar #'car names-and-lisp-functions))
     ))


(def-trivial-one-arg-*lisp-functions (
				      (byte-size!! byte-size)
				      (byte-position!! byte-position)
				      ))
(def-trivial-two-arg-*lisp-functions (
				      (mask-field!! mask-field)
				      (ldb!! ldb)
				      (ldb-test!! ldb-test)
				      ))

(def-trivial-three-arg-*lisp-functions (
					(dpb!! dpb)
					(deposit-field!! deposit-field)
					))

(defun array!! (dimensions &rest pvars)
  (unless (= (reduce #'* dimensions) (length pvars))
    (error "Dimensions ~S must have the save size as the number of pvars ~D provided to array!!."
	   dimensions (length pvars)
	   ))
  (let ((result (make-pvar-based-on-canonical-pvar-type :stack `(pvar (array t ,dimensions)))))
    (setf (pvar-name result) 'ARRAY!!-RETURN)
    (setf (pvar-lvalue? result) t)
    (dotimes (j (length pvars))
      (*setf (row-major-aref!! result (!! j)) (nth j pvars))
      )
    (setf (pvar-lvalue? result) nil)
    (setf (pvar-array-dimensions result) dimensions)
    result
    ))

(defmacro *when (test-pvar &body body)
  "subselect all processors with test-pvar non-nil"
  (multiple-value-bind (body return-pvar-p)
      (remove-return-pvar-p-from-body body '*when)
    (let ((css-index-symbol (gensym "CSS-INDEX-"))
	  (old-temp-pvar-list-symbol (gensym "OLD-TEMP-PVAR-LIST-"))
	  (test-pvar-symbol (gensym "TEST-PVAR-"))
	  (value-symbol (gensym "*WHEN-RETURN-VALUE-"))
	  )
      `(let* ((,css-index-symbol *css-current-level*)
	      (,old-temp-pvar-list-symbol *temp-pvar-list*)
	      (,test-pvar-symbol ,test-pvar)
	      ,value-symbol)
	 (simple-pvar-argument!! ,test-pvar-symbol)
	 (setq ,value-symbol
	       (prog2
		 (push-css ,test-pvar-symbol)
		 (progn ,@body)
		 (pop-css-to-level ,css-index-symbol)
		 ))
	 (check-return-pvar-p ,value-symbol ,return-pvar-p)
	 (handle-returning-pvar
	   ,value-symbol
	   ,old-temp-pvar-list-symbol
	   nil
	   )))))


(defmacro *unless (test-pvar &body body)
  `(*when (not!! ,test-pvar)
     ,@body
     ))

(defmacro *if (condition true-clause &optional else-clause)
  (if (null else-clause)
      `(progn (*when ,condition ,true-clause) (values))
      `(progn
	 ,(let ((condition-symbol (gensym "*IF-CONDITION-")))
	    `(*let ((,condition-symbol ,condition))
	       (*when ,condition-symbol ,true-clause)
	       (*when (not!! ,condition-symbol) ,else-clause)
	       ))
	 (values)
	 )))



(DEFMACRO *COND (&REST CLAUSES)
  "Similar to *IF"
  (COND ((NULL CLAUSES) NIL)
	((EQL (LENGTH CLAUSES) 1)
	 `(*IF ,(FIRST (FIRST CLAUSES)) (PROGN ,@(REST (FIRST CLAUSES))))
	 )
	((EQ (FIRST (FIRST CLAUSES)) 'T!!)
	 ;; if there are more clauses, issue a warning to that effect
	 (when (NOT (EQL (LENGTH CLAUSES) 1))
	   (ERROR "~% *COND: T!! is used in a clause other than the last")
	   ))
	(T
	 `(*IF ,(FIRST (FIRST CLAUSES))
	       (PROGN ., (REST (FIRST CLAUSES)))
	       (*COND ., (REST CLAUSES))))))


(DEFMACRO IF!! (PVAR-EXPRESSION TRUE-PVAR &OPTIONAL (ELSE-PVAR NIL!!))

  "IF!! will return a pvar.  This pvar will contain TRUE-PVAR
   for all processors with PVAR-EXPRESSION 
   true and ELSE-PVAR for all those with PVAR-EXPRESSION false.
   During the execution of TRUE-PVAR, the CSS
   will be set to those processors that passed PVAR-EXPRESSION,
   whereas during execution of ELSE-PVAR, the
   CSS will be set to those processors which failed PVAR-EXPRESSION.
  "
  
  (let ((if!!-result-symbol (gensym "IF!!-RESULT-")))
    `(*let (,if!!-result-symbol)
       (*if ,pvar-expression (*set ,if!!-result-symbol ,true-pvar) (*set ,if!!-result-symbol ,else-pvar))
       ,if!!-result-symbol
       )))

(defmacro cond!! (&rest clauses)
  (let ((len (length clauses)))
    (cond ( (eql 0 len) 'nil!! )
	  ( (eql 1 len)
	    (let* ((clause (car clauses))
		   (test (car clause))
		   (consequents (cdr clause))
		  )
	      (if (null consequents)
		  test
		  `(if!! ,test (progn ,@consequents) nil!!)
	       ))
	  )
	  ( t
	    (let* ((clause1 (car clauses))
		   (test1 (car clause1))
		   (consequents1 (cdr clause1))
		  )
	      (if (null consequents1)
		  (let ((test-symbol (gensym "COND!!-TEMP-TEST-")))
		    `(*let ((,test-symbol ,test1))
		       (if!! ,test-symbol
			     ,test-symbol
			     (cond!! ,@(cdr clauses))
			)))
		  `(if!! ,test1
			 (progn ,@consequents1)
			 (cond!! ,@(cdr clauses))
		    )))
	  )
      )))



(*defun *fill (sequence item &key (start (!! 0)) (end (length!! sequence)))
  
  (simple-pvar-argument!! (item start end))

  (safety-check
    (new-two-pvar-check start end '*fill)
    (new-vp-pvar-check item '*fill)
    )

  (without-void-sequence sequence *fill
    (without-void-pvars (item start end)
      (*fill-internal sequence item start end)
      )))


(defun coerce!! (pvar type &aux (ctype (canonical-pvar-type type)))
  (simple-pvar-argument!! pvar)
  (if (or (null ctype) (atom ctype) (not (eq (car ctype) 'pvar)))
      (error "Invalid type ~S to coerce!!." type))
  (case (canonical-pvar-element-type ctype)
    (boolean
      (assert (*and (booleanp!! pvar)) () "Cannot coerce pvar with non-boolean values into boolean pvar")
      pvar
      )
    (front-end pvar)
    (unsigned-byte
      (assert (*and (and!! (integerp!! pvar) (not!! (minusp!! pvar)))) ()
	      "Cannot coerce pvar with negative or non-integer values to unsigned-byte pvar"
	      )
      pvar
      )
    (signed-byte
      (assert (*and (integerp!! pvar)) () "Cannot coerce pvar with non-integer values to signed-byte pvar")
      pvar
      )
    (defined-float
      (assert (*and (and!! (numberp!! pvar) (not!! (complexp!! pvar)))) ()
	      "Cannot coerce pvar with non-integer/non-float values to float pvar"
	      )
      (let ((mantissa (float-pvar-type-mantissa ctype)) (exponent (float-pvar-type-exponent ctype)))
	(if (or (eq mantissa '*) (eq exponent '*))
	    (float!! pvar)
	    (if (and (<= (float-pvar-type-mantissa ctype) 23) (<= (float-pvar-type-exponent ctype) 8))
		(float!! pvar (!! 0.0))
		(float!! pvar (!! 0.0d0))
		))))
    (complex
      (assert (*and (numberp!! pvar)) () "Cannot coerce pvar with non-numeric valuue to complex pvar")
      (let* ((mantissa (complex-pvar-type-mantissa ctype))
	     (exponent (complex-pvar-type-exponent ctype))
	     (float-pvar-type `(float-pvar ,mantissa ,exponent))
	     )
	(if (or (eq mantissa '*) (eq exponent '*))
	    (complex!! (float!! (realpart!! pvar)) (float!! (imagpart!! pvar)))
	    (if!! (complexp!! pvar)
		  (complex!! (coerce!! (realpart!! pvar) float-pvar-type) (coerce!! (imagpart!! pvar) float-pvar-type))
		  (complex!! (coerce!! pvar float-pvar-type) (coerce!! (!! 0) float-pvar-type))
		  ))))
    (string-char
      (if!! (and!! (characterp!! pvar) (string-char-p!! pvar)) pvar (code-char!! pvar))
      )
    (character
      (if (eql (pvar-type pvar) :array)
	  (let ((dimensions (array-pvar-dimensions pvar))
		(rank (array-pvar-rank pvar)))
	    (assert (and (= rank 1)
			 (= (car dimensions) 1))
		    (pvar)
		    "Can only coerce character vector pvars of length 1 to character pvars.")
	    (setq pvar (aref!! pvar 0))))
      (if!! (characterp!! pvar) pvar (code-char!! pvar))
      )
    (array
      (coerce-to-array-pvar pvar ctype)
      )
    (structure
      (error "The *Lisp Simulator does not handle coercions to structure pvars.")
      )
    ((t)
     (cond
       ((array-pvar-p pvar) (error "Array pvars cannot be coerced to general pvars"))
       ((structure-pvar-p pvar) (error "Structure pvars cannot be coerced to general pvars"))
       (t pvar)
       ))
    ((* pvar) (error "Invalid type ~S to coerce!!." ctype))
    ))

(defun array-dimensions!! (pvar-array)
  "Returns a vector pvar of length the rank of the array,
   the nth element containing the nth dimension size.
  "
  (simple-pvar-argument!! pvar-array)

  (flet
    ((foo ()
       (apply 'typed-vector!!
	 `(pvar (unsigned-byte ,*max-index-pvar-length*))
	 (mapcar #'!! (*array-dimensions pvar-array))
	 )))
    (safety-check (new-pvar-check pvar-array 'array-dimensions!!))
    (case-pvar-array
      (pvar-array)
      nil
;      (if (no-processors-active)
;	  (typed-vector!! `(pvar (array (unsigned-byte ,*max-index-pvar-length*) (0))))
;	  (foo)
;	  )
      (foo)
      )))


(defun row-major-aref!! (array-pvar index-pvar)
  (simple-pvar-argument!! array-pvar index-pvar)
  (safety-check
    (new-two-pvar-check array-pvar index-pvar 'row-major-aref!!)
    (assert (array-pvar-p array-pvar))
    )
  (let ((return-pvar (allocate-temp-pvar-given-canonical-pvar-type (array-pvar-canonical-element-type array-pvar))))
    (setf (pvar-lvalue? return-pvar) t)
    (setf (pvar-constant? return-pvar) nil)
    (let* ((array-holding-pvars (pvar-array array-pvar))
	   (displaced-array
	    (coerce
	     (make-array
	       (array-total-size array-holding-pvars)
	       :element-type (array-element-type array-holding-pvars)
	       :displaced-to array-holding-pvars
	       )
	     'simple-array)))
      (setf (pvar-array array-pvar) displaced-array)
      (unwind-protect
	  (progn
	    (if (pvar-constant-value index-pvar)
		(svref!!-internal-constant-index array-pvar (pvar-constant-value index-pvar) return-pvar nil)
		(svref!!-internal array-pvar index-pvar return-pvar nil)
		)
	    (setf (pvar-lvalue? return-pvar) nil)
	    return-pvar
	    )
	(setf (pvar-array array-pvar) array-holding-pvars)
	))))

(eval-when (compile load eval)

(defun macroexpand-form-for-pref!! (form env)

  ;; Returns 2 values, the macroexpanded form and whether the form
  ;; can definitely be evaluated safely in the CSS, and does not
  ;; have to be evaluated in the source CSS and VP Set.

  (cond
    ((symbolp form) (values form t))
    ((not (listp form)) (values form t)) ;;; modified to allow scalar args WRS 9/16/90
;;;                           (error "Unrecognizable form, ~S, in pref!!" form))
    ((eq 'the (car form))
     (if (not (eql 3 (length form)))
	 (error "Bad THE form inside PREF!!.  ~S" form)
	 (multiple-value-bind (the-body-form evaluate-in-css?)
	     (macroexpand-form-for-pref!! (third form) env)
	   (values `(the ,(second form) ,the-body-form) evaluate-in-css?)
	   )))
    ((is-place form env) (values (recursive-alias!! form env) t))
    ((really-macroexpandable-p form env)
     (macroexpand-form-for-pref!! (macroexpand-1 form) env)
     )
    (t (values form nil))
    ))

)

(defmacro pref
    #-(OR :CCL KCL)
    (&whole form pvar processor &key vp-set &environment macroexpand-environment)
    #+(OR :CCL KCL)
    (&whole form &environment macroexpand-environment pvar processor &key vp-set)

  ;; What's going on here?

  ;; We need to look at the form to evaluate to get the pvar being referenced,
  ;; and the form to evaluate to get the processor from which we will do
  ;; the extraction.

  ;; There are two cases for the pvar expression.  Either it is a symbol or
  ;; it is not.  If it is a symbol, life is easy; we can just call
  ;; pref-function, which works with a pvar in any vp set.  If it is not
  ;; a symbol, then two things must happen:  we must evaluate the expression
  ;; in the proper vp set, and we must evaluate the expression in the
  ;; active set which consists solely of the processor being read from.
  ;; The :vp-set argument, if provided, is used to determine the proper
  ;; vp set in expression case.  If it is not provided in the expression
  ;; case the *current-vp-set* is assumed, and the user will lose if
  ;; the expression references pvars in a different vp set.

  ;; There are two major cases for the processor form.  Either it is
  ;; of the form (grid!! &rest args) or it is not.

  ;; If it is a grid!! call, then there are 3 subcases:

  ;; First, if no :vp-set argument is provided and the pvar expression
  ;; is a symbol, we convert the arguments of the grid!! call into
  ;; a cube address using the vp-set of the pvar symbol.

  ;; Second, if a :vp-set argument is provided, we convert the
  ;; arguments using that vp set.

  ;; Finally, if no :vp-set argument is provided and the pvar expression
  ;; is not a symbol we convert using *current-vp-set*.

  ;; If the form is not a grid!! call, then what it evaluates to can
  ;; be one of two things: a cube address or an address object.

  ;; If it is a cube address we just use it.  If it is an address object,
  ;; then we must extract a cube address from it.  To do this we must
  ;; transform the address object into an address object in the proper
  ;; vp-set.  The proper vp set is one of three possibilities, as discussed
  ;; above.

  ;; First check if the *compiler wants to deal with it.  If so, let it!

  (or (*lisp-compiler-hook form macroexpand-environment)     

      (let ((me-pvar-expression (macroexpand pvar macroexpand-environment))
	    (me-processor-expression (macroexpand processor macroexpand-environment))
	    )
	(let* ((is-grid-expression (and (listp me-processor-expression) (eq 'grid (car me-processor-expression))))
	       (processor-form
		 (if is-grid-expression
		     (cond
		       (vp-set `(cube-from-vp-grid-address ,vp-set ,@(cdr me-processor-expression)))
		       ((symbolp me-pvar-expression)
			`(cube-from-vp-grid-address (pvar-vp-set ,me-pvar-expression) ,@(cdr me-processor-expression))
			)
		       (t `(cube-from-grid-address ,@(cdr me-processor-expression)))
		       )
		     me-processor-expression
		     ))
	       )
		       
	  (if (symbolp me-pvar-expression)
	      (let ((vp-set-form (if vp-set vp-set `(if (fast-pvarp ,me-pvar-expression)
							(pvar-vp-set ,me-pvar-expression)
							*current-vp-set*))))
		`(new-pref-function ,me-pvar-expression ,processor-form ,vp-set-form))
	      (let ((vp-set-form (if vp-set vp-set '*current-vp-set*)))
		`(new-pref-function #'(lambda () 
					(let ((pvar-exp ,me-pvar-expression))
					  (simple-pvar-argument!! pvar-exp)
					  pvar-exp)) ,processor-form ,vp-set-form)))))))


(defun ppp-internal
       
       (pvar
	&key
	(mode *ppp-default-mode* mode-provided)
	(format *ppp-default-format*)
	(per-line *ppp-default-per-line*)
	(title *ppp-default-title*)
	(start *ppp-default-start* start-provided)
	(end *ppp-default-end* end-provided)
	(processor-list *ppp-default-processor-list*)
	(ordering *ppp-default-ordering*)
	(print-arrays t)
	(return-argument-pvar nil)
	((:pretty *print-pretty*) nil)
	stream)

  (simple-pvar-argument!! pvar)
  
  (let* ((*print-array* print-arrays)
	 (current-vp-set *current-vp-set*)
	 (*standard-output* (cond ((eq stream nil) *standard-output*)
				  ((eq stream t) *terminal-io*)
				  ((streamp stream) stream)
				  (t (error "Invalid stream argument ~S to ppp." stream)))))
    
    (flet ((argument-error-test (condition format-string &rest format-args)
	     (when (not condition)
	       (apply #'format *error-output* format-string format-args)
	       (return-from ppp-internal (if return-argument-pvar pvar nil))
	       ))
	   (integer-range-test (x low high) (and (integerp x) (>= x low) (< x high)))
	   )
      
      (fresh-line *standard-output*)
      
      ;; check all the arguments.
      
      (argument-error-test (pvarp pvar) "Not a pvar: ~A~%" pvar)
      
      (*with-vp-set (pvar-vp-set pvar)
	
	;; This code makes no sense to me now.  JP.
	;; I think this says that if the pvar being printed is in another Vp Set,
	;; and the user specified an end which is bigger than *ppp-default-end*
	;; (which presumably is *number-of-processors-limit* for that Vp Set)
	;; then smash the user-provided end value to be OK.  But shouldn't it
	;; just error out if end > *number-of-processors-limit*, and just be
	;; ok if *ppp-default-end* < end < *number-of-processors-limit* ?

	(when (and (not (eq *current-vp-set* current-vp-set))
		   (and (integerp end) (integerp *ppp-default-end*) (> end *ppp-default-end*))
		   (setq end *ppp-default-end*)
		   ))

	;; When an END argument was not provided, and the pvar we are
	;; printing is in a different Vp Set, then if *ppp-default-end*
	;; for that Vp Set is reasonable, make end have that value.

	(when (and (not (eq *current-vp-set* current-vp-set))
		   (not end-provided)
		   (integerp *ppp-default-end*)
		   (setq end *ppp-default-end*)
		   ))

	(argument-error-test (or (eq mode :cube) (eq mode :grid)) "Bad mode keyword: ~A~%" mode)
	
	(multiple-value-bind (start end mode error? error-string)
	    
	    (determine-reasonable-values-for-start-and-end mode mode-provided start end start-provided end-provided)
	  
	  (when error? (argument-error-test nil error-string))
	  
	  (cond
	    ((eq mode :cube)
	     (argument-error-test
	       (integer-range-test start 0 *number-of-processors-limit*)
	       "Invalid start keyword value: ~A~%"
	       start
	       )
	     (argument-error-test
	       (integer-range-test end (1+ start) (1+ *number-of-processors-limit*))
	       "Invalid end keyword value: ~A~%"
	       end
	       ))
	    ((eq mode :grid)
	     (argument-error-test
	       (eql (length start) *number-of-dimensions*)
	       "There are ~D dimensions in the current VP SET, but you provided ~D coordinates for :start"
	       *number-of-dimensions* (length start)
	       )
	     (argument-error-test
	       (eql (length end) *number-of-dimensions*)
	       "There are ~D dimensions in the current VP SET, but you provided ~D coordinates for :end"
	       *number-of-dimensions* (length end)
	       )
	     (flet ((check-grid-coordinate (x low limit keyname dimension decr)
		      (argument-error-test		
			(integer-range-test x low limit)
			"For ~S, grid coordinate ~D, which has value ~S, is not between ~D and ~D"
			keyname dimension x (- low decr) (- limit decr)
			)))
	       (let ((count -1))
		 (mapc #'(lambda (start limit) (check-grid-coordinate start 0 limit :start (incf count) 0))
		       start *current-cm-configuration*
		       ))
	       (let ((count -1))
		 (mapc #'(lambda (start end limit)
			   (check-grid-coordinate end (1+ start) (1+ limit) :end (incf count) 1)
			   )
		       start end *current-cm-configuration*
		       ))
	       ))
	    )
	  
	  (argument-error-test (stringp format) "Format keyword value is not a string: ~S~%" format)
	  (argument-error-test
	    (or (null per-line) (integer-range-test per-line 1 1000000))
	    "Per-line keyword value ~A is not a small integer~%"
	    per-line
	    )
	  (argument-error-test (or (null title) (symbolp title) (stringp title)) "Title keyword value not a string: ~A~%" title)
	  
	  ;; If there is an ordering given, we assume grid mode.
	  ;; The ordering is just a list of dimensions
	  ;; The dimensions are numbered from 0 up to (1- *number-of-dimensions*)
	  ;; which is the default dimension ordering.
	  ;; The ordering controls the iteration order over dimensions.
	  ;; we ignore ordering for 2-dimensions, making our life easier.
	  
	  (when ordering
	    (argument-error-test
	      (eq mode :grid)
	      "You specified a dimensions ordering, but you also specified or defaulted to :CUBE mode"
	      ))
	  
	  (let ((default-ordering nil))
	    (dotimes (j *number-of-dimensions*) (push j default-ordering))
	    (setq default-ordering (nreverse default-ordering))
	    (if (null ordering)
		(setq ordering default-ordering)
		(argument-error-test
		  (equal default-ordering (sort (copy-list ordering) #'<))
		  "Bad ordering ~S. ~
                     An ordering must be a list of non-repeated integers from 0 to *number-of-dimensions*"
		  ordering
		  )))
	  
	  (argument-error-test
	    (every #'(lambda (n) (integer-range-test n start end)) processor-list)
	    "Processor list contains invalid processor number: ~A~%" processor-list
	    )
	  
	  ;; start printing!
	  
	  (and title (if per-line (format *standard-output* "~A:~%" title) (format *standard-output* "~A: " title)))
	  
	  ;; print using cube addressing
	  
	  (cond
	    ((eq mode :cube)
	     (ppp-cube-ordering pvar start end format per-line processor-list)
	     )
	    ((and (eq mode :grid) (eql 1 *number-of-dimensions*))
	     (ppp-1d-news pvar start end format per-line)
	     )
	    ((and (eq mode :grid) (eql 2 *number-of-dimensions*))
	     (ppp-2d-news pvar start end format per-line ordering)
	     )
	    (t
	     (print-hypergrid pvar ordering start end format per-line)
	     ))
	  
	  ))))
  
  (if return-argument-pvar pvar (values))
  
  )


(defun-wco ppp-address-object

	   (address-object-pvar
	     &key title (start 0 start-provided) (end *number-of-processors-limit* end-provided) (mode :cube))

  (simple-pvar-argument!! address-object-pvar)
  
  (when (and (null start-provided) (eq mode :grid)) (setq start (make-list *number-of-dimensions* :initial-element 0)))
  (when (and (null end-provided) (eq mode :grid)) (setq end (copy-list *current-cm-configuration*)))

  (terpri *standard-output*)
  (when title (format *standard-output* "~A:~%" title))

  (let ((geometry-id (address-object-cached-geometry-id address-object-pvar)))

    ;; Figure out the rank in each processor.
    ;; Use -1 if we have *illegal-geometry-id*.
    ;; For printing, we will print out NIL for the rank if *illegal-geometry-id*.

    (*let (rank printing-rank)
      (declare (type (pvar (signed-byte 32)) rank))
      (declare (type (pvar t) printing-rank))
      (*all
	(*map-geometries
	  #'(lambda (id)
	      (*set rank
		    (if (eql id *illegal-geometry-id*)
			(!! -1)
			(!! (geometry-rank (geometry-from-id id)))
			)))
	  address-object-pvar
	  )
	(*set printing-rank (if!! (=!! (!! -1) rank) nil!! rank))
	)

      ;; If the geometry id is cached, just print out the
      ;; scalar id and rank.  Otherwise print them out
      ;; in each processor.

      (if geometry-id
	  (format *standard-output* "Single cached geometry id: ~D, Rank: ~D" geometry-id (geometry-rank (geometry-from-id geometry-id)))
	  (progn
	    (ppp (alias!! (address-object-geometry-id!! address-object-pvar))
		 :title "Geometry Id" :start start :end end :mode mode
		 )
	    (ppp printing-rank :title "Address Rank" :start start :end end :mode mode)
	    ))

      ;; Print out the cube address.  This should always be 0 for
      ;; processors with *illegal-geometry-id*.

      (ppp (alias!! (address-object-cube-address!! address-object-pvar))
	   :title "Cube Address     " :start start :end end :mode mode
	   )

      ;; Print out the grid coordinates.
      ;; Print out NIL for *illegal-geometry-id* and also
      ;; for those geometry id's which do not have an nth
      ;; grid address.  (i.e., if there are two different
      ;; geometries, and one is 2d and one is 3d, then
      ;; print out NIL in the 2d ones when printing out
      ;; the third grid coordinate of the 3d one).

      (*all
	(let ((max-rank (*max rank)))
	  (*let (grid-address)
	    (declare (type (pvar t) grid-address))
	    (dotimes (j max-rank)
	      (*all (*set grid-address nil!!))
	      (*when (and!! (/=!! (!! -1) rank) (>!! rank (!! j)))
		(*set grid-address (address-nth!! address-object-pvar (!! j)))
		)
	      (ppp grid-address :title (format nil "Grid Coordinate ~D" j) :start start :end end :mode mode)
	      ))))

      )))



	    (fresh-line stream)

	    (cond
	      ((null title) nil)
	      ((eq t title) (format stream "~%*DEFSTRUCT ~S~%" (pvar-structure-name pvar)))
	      (t (format stream "~%~A~%" title))
	      )

	    (dotimes (j number-of-pages)
	      (format stream "~%")
	      (mapc
		#'(lambda (slot-name aliased-pvar)
		    (format stream "~S: " slot-name)
		    (dotimes (i (- max-slot-name-length (length (symbol-name slot-name))))
		      (format stream " ")
		      )
		    (dotimes (k per-line)
		      (when (< (+ index k) end)
			(format stream format-string (pref-or-junk aliased-pvar (+ index k)))
			))
		    (terpri stream)
		    )
		list-of-slot-names
		list-of-aliased-slot-pvars
		)
	      (incf index per-line)
	      )

	    ))))))


(defun segmented-grid-rank!!-internal (pvar dimension segment-pvar)

  ;; Enumerate the start bits of the segment pvar.
  ;; This uniquely identifies each segment.
  ;; Scan out this tag to every processor in the segment.

  ;; Select every processor, and identify those
  ;; that were previously selected.

  ;; Append the enumeration tag and a bit which indicates
  ;; whether the processor was originally active or not
  ;; as the high order bits of the source
  ;; so that source values in the same segment will get
  ;; ranked next to each other, and so that inactive
  ;; processors will all have higher rankings per
  ;; segment than inactive processors.

  ;; Rank this concatenation across the whole machine.

  ;; Figure out where the end of each segment is.

  ;; Finally, scan across the segments forward and
  ;; backwards to get the minimum rank per segment
  ;; in every processor of the segment.  Then
  ;; subtract this minimum ranking from the
  ;; processor's rank value, to produce the ranking
  ;; relative to the segment.

  (*locally
    (declare (type (field-pvar *) pvar))
    (declare (type boolean-pvar segment-pvar))
    (*compile-blindly
      (*let (enumeration result min-result css segment-start segment-end pvar-copy)
	(declare (type (field-pvar *current-send-address-length*) enumeration result min-result))
	(declare (type boolean-pvar css segment-start segment-end))
	(declare (type (field-pvar *) pvar-copy))
	(declare (return-pvar-p t))
	nil
	(*all
	  (*set css nil!!)
	  (*set segment-start nil!!)
	  (if dimension
	      (*set segment-start (zerop!! (self-address-grid!! (!! (the fixnum dimension)))))
	      (*setf (pref segment-start 0) t)
	      )
	  (*set segment-end nil!!)
	  )
	(*set css t!!)
	(if (*and (null!! segment-pvar))      ;; if there are no segments selected
	    (*setf (pref segment-start 0) t)  ;; fake one
	    (*set segment-start segment-pvar));; else use selected segments - WRS 9/18/90
	;; make all the integers non-negative
	(*set pvar-copy (-!! pvar (!! (*min pvar))))
	(*all
	  (declare (return-pvar-p nil))
	  (*when (not!! css) (*set pvar-copy (!! 0)))
	  (*when segment-start (*set enumeration (enumerate!!)))
	  (*set enumeration
		(scan!! enumeration 'copy!! :segment-pvar segment-start :dimension dimension :direction :forward))
	  (let ((enumerate-size (*integer-length enumeration))
		(source-size (*integer-length pvar-copy))
		(active-set-tag-size 1)
		)
	    #+*LISP-SIMULATOR
	    (declare (ignore active-set-tag-size))
	    (*locally
	      (declare (type fixnum enumerate-size source-size active-set-tag-size))
	      (*let (concatenation)
		(declare (type (field-pvar (+ enumerate-size active-set-tag-size source-size)) concatenation))
		(declare (return-pvar-p nil))
		nil
		(*set concatenation pvar-copy)
		(*set concatenation (deposit-byte!! concatenation (!! source-size) (!! 1) (if!! css (!! 0) (!! 1))))
		(let ((temp (1+ source-size)))
		  (*locally
		    (declare (type fixnum temp))
		    (*set concatenation (deposit-byte!! concatenation (!! temp) (!! enumerate-size) enumeration))
		    ))
		(*set result (rank!! concatenation '<=!!))
		(*set segment-end
		      (scan!! segment-start 'copy!!
			      :dimension dimension :direction :backward :segment-pvar t!! :include-self nil))
		(if dimension
		    (*set segment-end
			  (or!! segment-end (=!! (self-address-grid!! (!! (the fixnum dimension)))
						 (!! (the fixnum (1- (dimension-size dimension)))))))
		    (*setf (pref segment-end (1- *number-of-processors-limit*)) t)
		    )
		(*set min-result (scan!! result 'min!! :segment-pvar segment-start :dimension dimension))
		(*set min-result (scan!! min-result 'min!! :direction :backward :segment-pvar segment-end :dimension dimension))
		(*set result (-!! result min-result))
		))))
	result
	))))

