;; -*- Mode:Lisp; Syntax:Common-Lisp; Package: (*SIM-I COMMON-LISP-GLOBAL); Muser: yes -*-

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> Copyright 1986 Thinking Machines Corporation, Inc. of Cambridge, Massachusetts.
;;;> 
;;;> Permission is hereby granted to copy this source onto any machine at a site
;;;> which legitimately has this software, and to execute the resulting object
;;;> code on any machine at a site which legitimately has this software.

;;;> Permission is hereby granted to make such changes as are necessary to port this
;;;> source to a version of Common Lisp running on any machine so long as said changes
;;;> are sent back to Thinking Machines so that they may be incorporated in future
;;;> releases.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com

;;;> The *Lisp Simulator was written by JP Massar.
;;;> The *Lisp language was designed by Cliff Lasser and Steve Omohundro, with
;;;> help from may others at Thinking Machines Corporation.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+



;;; This file contains macros that expand into function definitions.  These
;;; functions are simple, parallel extensions of Common Lisp functions.


(in-package '*SIM-I)


(defun macroexpand-properly-completely (form env)
  (let ((new-form (macroexpand-properly form env)))
    (if (listp form)
	(cons (car new-form)
	      (mapcar
		#'(lambda (subform) (macroexpand-properly-completely subform env))
		(cdr new-form)
		))
	form
	)))

(defun is-correct-the (form)
  (and (listp form) (eq 'the (car form)) (eql 3 (length form)))
  )

(defun is-symbolic-the (form)
  (and (is-correct-the form) (symbolp (third form)))
  )


(defun *set-can-be-compiled-p (single-*set-form env)
  (let ((dest (macroexpand-properly-completely (car single-*set-form) env))
	(source (macroexpand-properly-completely (cadr single-*set-form) env))
	)
    (when (and (not (symbolp dest)) (is-symbolic-the dest))
      (print 'hello)
      (return-from *set-can-be-compiled-p nil)
      )
    (when (or (symbolp source) (is-symbolic-the source))
      (return-from *set-can-be-compiled-p nil)
      )
    (if (and (trivial-expression-p source)
	     (trivial-expression-contains-trivial-function-call-p source)
	     )
	(compile-*set dest source)
	nil
	)))


(defun trivial-structure-reference-p (reference)
  (labels
    ((trivial-structure-referent-p (referent)
       (cond
	 ((symbolp referent) t)
	 ((listp referent)
	  (cond
	    ((is-correct-the referent) (trivial-structure-referent-p (third referent)))
	    ((structure-accessor-function-p (car referent))
	     (trivial-structure-reference-p referent)
	     )
	    ((array-accessor-function-p (car referent))
	     (trivial-array-reference-p referent)
	     ))))))
    (and
      (eql 2 (length reference))
      (second reference)
      (trivial-structure-referent-p (second reference))
      )))

	       
(defun trivial-array-reference-p (reference)
  (labels
    ((trivial-array-referent-p (referent)
       (cond
	 ((symbolp referent) t)
	 ((listp referent)
	  (cond
	    ((is-correct-the referent) (trivial-array-referent-p (third referent)))
	    ((structure-accessor-function-p (car referent))
	     (trivial-structure-reference-p referent)
	     )
	    ((array-accessor-function-p (car referent))
	     (trivial-array-reference-p referent)
	     ))))))

  (let ((referent (second reference))
	(indices (cddr reference))
	)
    (and
      (compile-time-constant-pvars? indices)
      (trivial-array-referent-p referent)
      ))))


(defun trivial-expression-p (expression)
  (cond
    ((symbolp expression) t)
    ((listp expression)
     (cond
       ((is-!!-form expression nil) t)
       ((is-correct-the expression) (trivial-expression-p (third expression)))
       ((structure-accessor-function-p (car expression))
	(trivial-structure-reference-p expression)
	)
       ((array-accessor-function-p (car expression))
	(trivial-array-reference-p expression)
	)
       (t
	(and (symbolp (car expression))
	     (symbol-trivial-p (car expression))
	     (every 'trivial-expression-p (cdr expression))
	     ))))))


(defun trivial-expression-contains-trivial-function-call-p (expression)
  (cond
    ((symbolp expression) nil)
    ((listp expression)
     (cond
       ((is-!!-form expression nil) t)
       ((is-correct-the expression)
	(trivial-expression-contains-trivial-function-call-p (third expression))
	)
       ((and (symbolp (car expression)) (symbol-trivial-p (car expression))))
       ))))


(defun serial-equivalent-function-name (function)
  ;; THIS IS NOT RIGHT.  SQRT!! --> SQRT, but should go to STARLISP-SQRT
  ;; TEMPORARY HACK.
  (intern (subseq (symbol-name function) 0 (- (length (symbol-name function)) 2)))
  )

(defun front-end-accessor-from-*defstruct-accessor (*defstruct-accessor)
  (let* ((*defstruct-name (get *defstruct-accessor '*defstruct-accessor))
	 (*defstruct-accessor-list (get *defstruct-name '*defstruct-slot-accessors))
	 (front-end-accessor-list (get *defstruct-name '*defstruct-front-end-slot-accessors))
	 (position (position *defstruct-accessor *defstruct-accessor-list))
	 (front-end-accessor (nth position front-end-accessor-list))
	 )
    front-end-accessor
    ))


(defun construct-binding-for-trivial-form (form)
  (cond
    ((symbolp form) `(pvar-array ,form))
    ((is-correct-the form) (construct-binding-for-trivial-form (third form)))
    ((structure-accessor-function-p (car form))
     `(pvar-array
	(,(front-end-accessor-from-*defstruct-accessor (car form))
	 ,(construct-binding-for-trivial-form (second form))
	 )))
    ((array-accessor-function-p (car form))
     `(pvar-array
	(aref ,(construct-binding-for-trivial-form (second form))
	      ,@(mapcar #'cadr (cddr form))
	      )))
    ))

(defun compile-*set (dest source)
  (let ((processor-index-symbol (gensym "INDEX-"))
	(any-active-symbol (gensym "ANY-ACTIVE-"))
	dest-symbol
	)
    (let ((bindings nil))
      (labels
	((substitute-symbol (symbol)
	   (intern (concatenate 'string (symbol-name symbol) "-ARRAY"))
	   )
	 (substitute-for-trivial-dest (dest)
	   (let* ((symbol
		    (cond
		      ((symbolp dest) dest)
		      ((is-symbolic-the dest) (third dest))
		      (t (error "Internal error.  Inconsistency between parser and code generator"))
		      ))
		  (substitute-symbol (substitute-symbol symbol))
		  )
	     (pushnew `(,substitute-symbol (pvar-array ,symbol)) bindings :test #'equal)
	     (setq dest-symbol symbol)
	     `(aref ,substitute-symbol ,processor-index-symbol)
	     ))
	 (substitute-for-trivial-source (source)
	   (cond
	     ((symbolp source)
	      (let ((substitute-symbol (substitute-symbol source)))
		(pushnew `(,substitute-symbol (pvar-array ,source)) bindings :test #'equal)
		`(aref ,substitute-symbol ,processor-index-symbol)
		))
	     ((is-!!-form source nil) (cadr source))
	     ((is-correct-the source) (substitute-for-trivial-source (third source)))
	     ((structure-accessor-function-p (car source))
	      (let ((binding (construct-binding-for-trivial-form source))
		    (binding-symbol (gensym "STRUCTURE-REFERENCE-"))
		    )
		(push `(,binding-symbol ,binding) bindings)
		`(aref ,binding-symbol ,processor-index-symbol)
		))
	     ((array-accessor-function-p (car source))
	      (let ((binding (construct-binding-for-trivial-form source))
		    (binding-symbol (gensym "ARRAY-REFERENCE-"))
		    )
		(push `(,binding-symbol ,binding) bindings)
		`(aref ,binding-symbol ,processor-index-symbol)
		))
	     ((symbol-trivial-p (car source))
	      `(,(serial-equivalent-function-name (car source))
		,@(mapcar #'substitute-for-trivial-source (cdr source))
		))))
	 )

	(let ((inner-code
		`(setf ,(substitute-for-trivial-dest dest)
		       ,(substitute-for-trivial-source source)
		       )))

	  `(let ((,any-active-symbol nil) ,@bindings)
	     ,@(if bindings `((1-d-array-declaration ,@(mapcar 'car bindings))))
	     (do-for-selected-processors-internal (,processor-index-symbol)
	       (setq ,any-active-symbol t)
	       ,inner-code
	       )
	     (when ,any-active-symbol (make-non-void ,dest-symbol))
	     )

	  )))))
