;;; -*- SYNTAX: Common-Lisp; MODE: lisp; BASE: 10; PACKAGE: *lisp-i; MUSER: YES -*-
;;;> ************************************************************************************
;;;> Copyright 1986 Thinking Machines Corporation, Inc. of Cambridge, Massachusetts.
;;;> All rights reserved
;;;>
;;;> This notice is intended as a precaution against inadvertent publication
;;;> and does not constitute an admission or acknowledgement that publication 
;;;> has occurred or constitute a waiver of confidentiality.   Connection Machine software
;;;> is the proprietary and confidential property of Thinking Machines Corporation.
;;;> ************************************************************************************

;;; This definition is not needed. *Lisp is defined in
;;; simulator-specification.lisp   WRS 4/23/90


;;; User-interface functions and other syntactic sugar - WRS 4/10/90

(IN-PACKAGE '*LISP-I)

;;; *lisp function - Added by William Swanson (traveler), 4/10/90
;;; Provides simple toggle switch between *LISP and USER packages.
;;; User-interface fluff, but the language was crying out for
;;; something like this.

;;; A non-NIL argument puts you in the *Lisp package, a NIL argument puts you
;;; in the User package, and no argument toggles you between the two.

(defun *lisp::*lisp (&optional (select-*lisp :toggle))
  (in-package
    (if (eq select-*lisp :toggle)
	(if (eq *package* (find-package '*lisp))
	    'user '*lisp)
	(if select-*lisp '*lisp 'user)))
  (format t "Default package is now ~A.~%" (package-name *package*))
  (values))

(defun user::*lisp (&optional (select-*lisp :toggle))
  (*lisp::*lisp select-*lisp))
