;; ** This session was started by executing
;; /cm/bin/starlisp-simulator


;;; Sun Common Lisp, Development Environment 3.0.1, 21-Sep-89
;;; Sun-4 Version for SunOS 4.0 
;;;
;;; Copyright (c) 1985, 1986, 1987, 1988 by Sun Microsystems, Inc., All Rights Reserved
;;; Copyright (c) 1985, 1986, 1987, 1988 by Lucid, Inc., All Rights Reserved
;;;
;;; This software product contains confidential and trade secret
;;; information belonging to Sun Microsystems.  It may not be copied
;;; for any reason other than for archival and backup purposes.

;;;         Lisp World: lcmw
;;;            Created: Thursday, 21 September 1989 at 21:58:51 EDT
;;;    Produced within: SunOS Release 4.0 (CMSUN4) #29: Tue Jun 20 19:49:02 EDT 1989

;;;
;;; User World: starlisp-simulator+patches
;;;    Created: Friday, 22 September 1989 at 21:45:59 EDT

;;; Loading source file "/cm/patch/initializations.lisp"
;;; Loading binary file "/cm/utility/gmacs-macroexpand-all.sbin3"
;;; Loading source file "lisp-init.lisp"

;; ** Get ourselves into the *Lisp package so that we can
;; use all the *Lisp functions and variables.

> (in-package '*lisp)
#<Package "*SIM" 9304B6>

;; ** cold boot (initialize) the (simulated) Connection Machine.
;; ** by default, the *Lisp Simulator postulates a 32
;; ** processor CM in a two dimensional grid, 8x4.

> (*cold-boot)


Thinking Machines Starlisp Simulator.  Version 16.0

1
(8 4)

;; ** We can cold boot to a hypercube if we want...

> (*cold-boot :initial-dimensions '(2 2 2 2))


Thinking Machines Starlisp Simulator.  Version 16.0

1
(2 2 2 2)

;; ** But it's hard to visualize so let's stick to 2d...

> (*cold-boot :initial-dimensions '(8 4))


Thinking Machines Starlisp Simulator.  Version 16.0

1
(8 4)


;; ** Allocating variables on the Connection Machine.
;; ** Use *defvar to allocate global variables.
;; ** Here we define a variable that has a random number
;; ** between 0 inclusive and 10 exclusive in each processor.

> (*defvar rand (random!! (!! 10)))
RAND

;; ** PPP (pretty print pvar) is the basic visualization and
;; ** debugging tool for *Lisp.  It has lots of options but
;; ** for the moment we will just let it default, which means
;; ** print out all the values in all the processors

> (ppp rand)
4 0 4 3 1 0 5 7 5 6 7 0 1 6 3 9 4 6 1 9 3 8 3 9 6 6 6 9 5 8 6 5 
NIL
> (*defvar rand-plus-one)
RAND-PLUS-ONE
> (*set rand-plus-one (+!! rand (!! 1)))
NIL
> (ppp rand-plus-one)
5 1 5 4 2 1 6 8 6 7 8 1 2 7 4 10 5 7 2 10 4 9 4 10 7 7 7 10 6 9 7 6 
NIL

;; ** We can allocate temporary parallel variables by using *LET

> (*let ((y (random!! (!! 20))))
    (ppp y)
    )
15 19 18 7 16 11 13 17 12 1 7 15 16 4 19 3 16 0 0 18 2 7 13 15 17 15 8 0 10 4 2 2 
NIL


;; ** The self-address!! function returns a pvar whose value is the
;; ** processor number.

> (ppp (self-address!!))
0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 
NIL

;; ** *Lisp has all the standard Common Lisp functions.  Just put a !! at the end.
;; ** Here we see the parallel cosine function and an example of how to use PPP
;; ** to make the output readable.


> (ppp (cos!! rand))
-0.6536436208636119 1.0 -0.6536436208636119 -0.9899924966004454 0.5403023058681398 1.0 0.28366218546322625 0.7539022543433046 0.28366218546322625 0.9601702866503661 0.7539022543433046 1.0 0.5403023058681398 0.9601702866503661 -0.9899924966004454 -0.9111302618846769 -0.6536436208636119 0.9601702866503661 0.5403023058681398 -0.9111302618846769 -0.9899924966004454 -0.14550003380861354 -0.9899924966004454 -0.9111302618846769 0.9601702866503661 0.9601702866503661 0.9601702866503661 -0.9111302618846769 0.28366218546322625 -0.14550003380861354 0.9601702866503661 0.28366218546322625 
NIL

> (ppp (cos!! rand) :per-line 8 :format "~7F ")
-.65364     1.0 -.65364 -.98999 .540302     1.0 .283662 .753902 
.283662 0.96017 .753902     1.0 .540302 0.96017 -.98999 -.91113 
-.65364 0.96017 .540302 -.91113 -.98999 -0.1455 -.98999 -.91113 
0.96017 0.96017 0.96017 -.91113 .283662 -0.1455 0.96017 .283662 
NIL

;; ** PPP can print out a selected range of processors.

> (ppp (self-address!!) :start 5 :end 10)
5 6 7 8 9 
NIL


;; ** We can visualize pvars in their two-dimensional arrangement
;; ** as well as in a simple linear ordering.


> (ppp rand :mode :grid)

     DIMENSION 0 (X)  ----->

4 1 5 1 4 3 6 5 
0 0 6 6 6 8 6 8 
4 5 7 3 1 3 6 6 
3 7 0 9 9 9 9 5 
NIL

> (ppp (self-address-grid!! (!! 0)) :mode :grid)

     DIMENSION 0 (X)  ----->

0 1 2 3 4 5 6 7 
0 1 2 3 4 5 6 7 
0 1 2 3 4 5 6 7 
0 1 2 3 4 5 6 7 
NIL

> (ppp (self-address-grid!! (!! 1)) :mode :grid)

     DIMENSION 0 (X)  ----->

0 0 0 0 0 0 0 0 
1 1 1 1 1 1 1 1 
2 2 2 2 2 2 2 2 
3 3 3 3 3 3 3 3 
NIL


;; ** *Lisp has boolean values (True and False) represented by T and NIL.

> (ppp (oddp!! (self-address!!)))
NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL T NIL


;; ** We can define functions which take parallel variables
;; ** just like we can define regular functions.


> (defun my-add!! (x y)
    (declare (type (signed-pvar 32) x y))
    (+!! x y)
    )
MY-ADD!!

> (ppp (my-add!! (self-address!!) (!! 2)))
2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33 
NIL

> (defun hypotenuse!! (x y)
    (declare (type single-float-pvar x y))
    (sqrt!! (+!! (*!! x x) (*!! y y)))
    )
HYPOTENUSE!!
> (ppp (hypotenuse!! (float!! (self-address!!)) (float!! (self-address!!))) :end 5)
0.0 1.4142135623730951 2.8284271247461903 4.242640687119285 5.656854249492381 
NIL

;; ** And we can compile them in exactly the same way too.

> (compile 'hypotenuse!!)
HYPOTENUSE!!
> (ppp (self-address!!))
0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 
NIL


;; ** Let's define a pvar to stick the results of some calculations in.

> (*defvar result)
RESULT

;; ** Here we illustrate the basic *Lisp processor selection primitive *IF.
;; ** Result is given the value 23 in the even numbered processors and 17
;; ** in the odd numbered processors.

> (*if (evenp!! (self-address!!))
       (*set result (!! 23))
       (*set result (!! 17))
       )
> (ppp result)
23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 
NIL

;; ** *IF is executed for side effect.  IF!! returns a pvar.

> (ppp (if!! (evenp!! (self-address!!)) (!! 23) (!! 17)))
23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 23 17 
NIL

> (*set result (!! 0))
NIL
> (ppp result)
0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
NIL

;; ** You can use *WHEN if there is no ELSE clause for a *IF.  *WHEN is very common.
;; ** Here we select those processors whose self address is either greater than 10
;; ** or is an odd number and then put a 1 into the RESULT pvar in those processors.

> (*when (or!! (>!! (self-address!!) (!! 10)) (oddp!! (self-address!!))) (*set result (!! 1)))
NIL
> (ppp result)
0 1 0 1 0 1 0 1 0 1 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 
NIL


;; ** We can find out how many processors are active using the idiom (*SUM (!! 1))

> (*sum (!! 1))
32

> (*when (evenp!! (self-address!!)) (*sum (!! 1)))
16

;; ** It is quite possible to have no selected (active) processors.

> (*when (evenp!! (self-address!!))
    (*when (oddp!! (self-address!!))
      (*sum (!! 1))
      ))
0

;; ** The *ALL primitive can be used to restore all the processors
;; ** to being active.  Notice that when you exit a form that
;; ** alters context context is restored to what it was before
;; ** you entered the form.

> (*when (evenp!! (self-address!!))
    (print (*sum (!! 1)))
    (*when (oddp!! (self-address!!))
      (print (*sum (!! 1)))
      (*all
	(print (*sum (!! 1)))
	)
      (print (*sum (!! 1)))
      )
    (print (*sum (!! 1)))
    )
16
0
32
0
16

;; ** The idiom (*or t!!) is often used to
;; ** determine whether any processors are active.
;; ** This is signficantly faster than (zerop (*sum (!! 1)))

> (*when nil!! (*sum (!! 1)))
0

> (*when (zerop!! (random!! (!! 100)))
    (if (*or t!!) (print "ZERO IS PRESENT") (print "NO ZEROES"))
    nil
    )

"NO ZEROES" 
NIL

> (*when (zerop!! (random!! (!! 100)))
    (if (*or t!!) (print "ZERO IS PRESENT") (print "NO ZEROES"))
    nil
    )


"ZERO IS PRESENT" 
NIL


;; ** A further example of context restriction.
;; ** Here we set values on the main diagonal of
;; ** the CM processors.

> (*set result (!! 0))
NIL
> (ppp result :mode :grid)

     DIMENSION 0 (X)  ----->

0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
0 0 0 0 0 0 0 0 
NIL
> (*when (=!! (self-address-grid!! (!! 0)) (self-address-grid!! (!! 1)))
    (*set result (random!! (!! 20)))
    )
NIL
> (ppp result)
8 0 0 0 0 1 0 0 0 0 16 0 0 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
NIL
> (ppp result :mode :grid)

     DIMENSION 0 (X)  ----->

8 0 0 0 0 0 0 0 
0 1 0 0 0 0 0 0 
0 0 16 0 0 0 0 0 
0 0 0 2 0 0 0 0 
NIL
> (ppp result :mode :grid :format "~4S ")

     DIMENSION 0 (X)  ----->

8    0    0    0    0    0    0    0    
0    1    0    0    0    0    0    0    
0    0    16   0    0    0    0    0    
0    0    0    2    0    0    0    0    
NIL


;; ** A function to determine primeness.
;; ** This is not a terribly efficient algorithm 
;; ** for the CM.  We just loop up to the square
;; ** root of the largest value in the input pvar,
;; ** starting from 2, and if we find any value
;; ** that divides evenly, then the value in that
;; ** processor is not a prime.

> (defun primep!! (x)
    (declare (type (unsigned-byte-pvar 16) x))
    (*let ((result t!!))
      (declare (type boolean-pvar result))
      (*let ((limit (ceiling!! (sqrt!! x))))
	(declare (type (unsigned-byte-pvar 16) limit))
        (let ((n (*max limit)))
	(do ((j 2 (1+ j)))
	    ((> j n))
	  (*when (and!! result (<=!! (!! j) limit) (zerop!! (mod!! x (!! j))))
	       (*set result nil!!)
	       ))))
      result
      ))

PRIMEP!!

> (ppp (+!! (self-address!!) (!! 4)) :format "~4S " :per-line 12)
4    5    6    7    8    9    10   11   12   13   14   15   
16   17   18   19   20   21   22   23   24   25   26   27   
28   29   30   31   32   33   34   35   
NIL

> (ppp (primep!! (+!! (self-address!!) (!! 4))) :format "~4S " :per-line 12)
NIL  T    NIL  T    NIL  NIL  NIL  T    NIL  T    NIL  NIL  
NIL  T    NIL  T    NIL  NIL  NIL  T    NIL  NIL  NIL  NIL  
NIL  T    NIL  T    NIL  NIL  NIL  NIL  
NIL

;; ** Exit the *Lisp Simulator and Lucid Common Lisp.

> (lcl:quit)

Process lisp finished



;; ** Now we will start up *Lisp itself, not the *Lisp Simulator.
;; ** /cm/bin/starlisp

;;; 
;;; Sun Common Lisp, Development Environment 3.0.1,  2-Jun-89
;;; Sun-4 Version for SunOS 4.0 
;;;
;;; Copyright (c) 1985, 1986, 1987, 1988 by Sun Microsystems, Inc., All Rights Reserved
;;; Copyright (c) 1985, 1986, 1987, 1988 by Lucid, Inc., All Rights Reserved
;;;
;;; This software product contains confidential and trade secret
;;; information belonging to Sun Microsystems.  It may not be copied
;;; for any reason other than for archival and backup purposes.


;;; Connection Machine Software, Release 5.2
;;; 
;;; Copyright (C) 1989 by Thinking Machines Corporation.  All rights reserved.
;;; 
;;; Loading source file "/cm/patch/initializations.lisp"
;;; Loading binary file /cm/utilities/f5201/ieee-float.sbin3
;;; Loading source file "lisp-init.lisp"

;; ** Let's see if there is anybody using the CM.

> (cm:finger)
;;; Loading source file "/cm/configuration/configuration.lisp"

Name of CM:  CM2             Physical size = 8k CM2, 4K over 4K.
          nobody         SPIRIT:0                Not attached
          nobody         SPIRIT:1                Not attached
NIL

;; ** No there is not.  Let's grab all 8192 processors.
;; ** We could have grabbed only 4096 but let's be greedy.

> (cm:attach 8192)
8192

;; ** Now it says that I am using the entire machine.

 (cm:finger)

Name of CM:  CM2             Physical size = 8k CM2, 4K over 4K.
          massar         SPIRIT:0                Sequencer Ports (0 1)  <-- Attached to 8192 physical processors
          nobody         SPIRIT:1                Not attached
NIL


;; ** Get into the *Lisp package as with the Simulator.

> (in-package '*lisp)
#<Package "*LISP" 221C6FE>

;; ** Cold boot as with the Simulator.  The default configuration
;; ** for 8192 processors is a grid 128 x 64.

> (*cold-boot)
8192
(128 64)

;; Let's use the virtual processor mechanism of the CM and make
;; it look like there are really 512x512 processors.

> (*cold-boot :initial-dimensions '(512 512))
8192
(512 512)

;; ** Yes, it really appears to think that there are that many processors!

> (*sum (!! 1))
262144


;; ** We can define our hypotenuse!! function in
;; ** exactly the same way and try it out the same way.
;; ** Remember to put a :end value for PPP, otherwise it
;; ** will print out 262144 values!!!!!

> (defun hypotenuse!! (x y)
    (declare (type single-float-pvar x y))
    (sqrt!! (+!! (*!! x x) (*!! y y)))
    )
HYPOTENUSE!!
> (ppp (hypotenuse!! (float!! (self-address!!)) (float!! (self-address!!))) :end 5)
0.0 1.4142134 2.8284268 4.2426405 5.6568537 

;; ** Let's compile the function using the *Lisp compiler.
;; ** We will tell the *Lisp compiler not to generate any
;; ** code to detect any errors, and we will tell the *Lisp
;; ** compiler to show us the Paris code it produces for
;; ** the hypotenuse!! function.

;; ** Our goal here is to eventually time the function and
;; ** see how many gigaflops it runs at.

> (setq *safety* 0)
0
> (setq slc::*show-expanded-code* t)
T
> (compile 'hypotenuse!!)


 expression:

(SQRT!! (+!! (*!! X X) (*!! Y Y)))


 expanded to:

(LET* ((SLC::STACK-FIELD (CMI::NEXT-STACK-FIELD))
       (#:SQRT!!-RESULT-1 SLC::STACK-FIELD)
       (#:SQRT!!-INDEX-2 (+ #:SQRT!!-RESULT-1 32)))
  (DECLARE (TYPE SLC::CM-ADDRESS SLC::STACK-FIELD #:SQRT!!-RESULT-1 #:SQRT!!-INDEX-2))
  (CM:ALLOCATE-STACK-FIELD (- #:SQRT!!-INDEX-2 SLC::STACK-FIELD))
  (CM:F-MULTIPLY-3-1L #:SQRT!!-RESULT-1 (PVAR-LOCATION Y) (PVAR-LOCATION Y) 23 8)
  (CM:F-MULT-ADD-1L #:SQRT!!-RESULT-1 (PVAR-LOCATION X) (PVAR-LOCATION X) #:SQRT!!-RESULT-1 23 8)
  ;;  - sqrt!!.
  (CM:F-SQRT-2-1L #:SQRT!!-RESULT-1 #:SQRT!!-RESULT-1 23 8)
  (SLC::ALLOCATE-TEMP-PVAR
   :TYPE :FLOAT :LENGTH 32 :BASE #:SQRT!!-RESULT-1 :MANTISSA-LENGTH 23 :EXPONENT-LENGTH 8
   ))

HYPOTENUSE!!


;; Now let's time 1000 iterations of the function.  We use the
;; CM:TIME macro to do this.

> (defun time-hypotenuse ()
    (*let ((x (random!! (!! 1.0))) (y (random!! (!! 1.0))) (result (!! 0.0)))
      (declare (type single-float-pvar x y result))
      (cm:time
       (dotimes (j 1000) (*set result (the single-float-pvar (hypotenuse!! x y))))
       )))
TIME-HYPOTENUSE
> (setq slc::*show-expanded-code* nil)
NIL
> (compile 'time-hypotenuse)
TIME-HYPOTENUSE
> (time-hypotenuse)

;; ** The reason the CM is not active 100% of the time is because of the large load
;; ** on the Sun4 front end.  At this Vp Ratio running standalone the CM would always
;; ** be active 99.9% of the time.

Evaluation of (DOTIMES (J 1000) (*SET RESULT (THE SINGLE-FLOAT-PVAR (HYPOTENUSE!! X Y)))) took 11.049999 seconds of elapsed time, 
during which the CM was active for 9.323040 seconds or 84.00% of the total elapsed time.
NIL

;; ** We want to calculate how many flops are being performed.
;; ** There are two multiplies and 1 addition and 1 sqrt.
;; ** Let's assume the SQRT function is done using 6 basic
;; ** flops.  So we have a total of 9 operations, done over
;; ** 512x512 virtual processors, done 1000 times.

> (* 9 512 512 1000)
2359296000

;; ** If we divide this by the time it took we get flops.

> (/ * 9.32)
2.5314334763948497E8

;; ** Since we have 1/8 of a CM, we multiply by 8 to see the
;; ** Gigaflop rate of a full CM.  So this sequence of 
;; ** instructions executes at around 2 Gigaflops.

> (* * 8)
2.0251467811158798E9


;; ** Now we will turn full error checking on and see the degredation
;; ** in performance.

> (setq *safety* 3)
3
> (defun hypotenuse!! (x y)
    (declare (type single-float-pvar x y))
    (sqrt!! (+!! (*!! x x) (*!! y y)))
    )

> (compile 'hypotenuse!!)
HYPOTENUSE!!
> (time-hypotenuse)

;; ** A large degredation!

Evaluation of (DOTIMES (J 1000) (*SET RESULT (THE SINGLE-FLOAT-PVAR (HYPOTENUSE!! X Y)))) took 39.939999 seconds of elapsed time, 
during which the CM was active for 9.775002 seconds or 24.00% of the total elapsed time.
NIL



;; ** This section will demonstrate how to look at CM memory usage
;; ** and how it is allocated.

;; ** The basic function to use is *room.  It shows that right
;; ** now we have not used any CM memory for parallel variables.
;; ** Our Vp Sets and other overhead are taking up 328 bits.

> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 0
*Defvar memory usage : 0
Overhead             : 328
Total                : 328
0
0
0
328

;; ** We are at a vp ratio of 32.  That means every time
;; ** we allocate a 32 bit number, we are actually allocating
;; ** 1024 bits of space on the CM.

> (/ (* 512 512) 8192)
32
> (* 32 32)
1024

;; ** Here we define two variables to be floating point pvars
;; ** and actually allocate one of them.  We see that 1024
;; ** bits of space have been taken.

> (*proclaim '(type single-float-pvar x y))
NIL
> (*defvar x)
X
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 0
*Defvar memory usage : 1024
Overhead             : 328
Total                : 1352
0
0
1024
328



;; ** Now allocate an anonymous floating point variable
;; ** (Like using MALLOC in 'C').
;; ** We see that another 1024 bits has been allocated on
;; ** the heap, plus another 1024 bits for the (!! 3.0)
;; ** expression on the stack.  (This is a bug!)

> (allocate!! (!! 3.0))
#<FLOAT-Pvar-* ALLOCATE!! 68(0)-32 *DEFAULT-VP-SET* (512 512)>
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 1024
Heap memory usage    : 1024
*Defvar memory usage : 1024
Overhead             : 328
Total                : 3400
1024
1024
1024
328

;; ** The *warm-boot function can be used to reset the stack.
;; ** It also resets context to all processors.

 (*warm-boot)
NIL
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 1024
*Defvar memory usage : 1024
Overhead             : 328
Total                : 2376
0
1024
1024
328



;; ** Use *LET to allocate a temporary parallel variable.
;; ** It goes onto the *Lisp stack.
;; ** Once we exit the *LET, the space is reclaimed.

> (*let ((foo (!! 3.0))) (declare (type single-float-pvar foo)) (*room :how :totals))


*Lisp system memory utilization

Stack memory usage   : 1024
Heap memory usage    : 1024
*Defvar memory usage : 1024
Overhead             : 328
Total                : 3400
1024
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 1024
*Defvar memory usage : 1024
Overhead             : 328
Total                : 2376
0
1024
1024
328



;; ** We can deallocate the pvars defined using *DEFVAR.

> (*deallocate-*defvars 'x)
NIL
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 1024
*Defvar memory usage : 0
Overhead             : 328
Total                : 1352
0
1024
0
328

;; ** And *COLD-BOOT will clean up heap space as well as stack space.

> (*cold-boot)
8192
(512 512)
> (*room :how :totals)


*Lisp system memory utilization

Stack memory usage   : 0
Heap memory usage    : 0
*Defvar memory usage : 0
Overhead             : 328
Total                : 328
0
0
0
328
> 





