;;; -*- MODE: LISP; SYNTAX: COMMON-LISP; PACKAGE: *SIM-I; BASE: 10; MUSER: YES; -*-

(in-package '*sim-i :use '(lisp))

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> 
;;;> The Thinking Machines *Lisp Simulator is in the public domain.
;;;> You are free to do whatever you like with it, including but
;;;> not limited to distributing, modifying, and copying.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com.  Other than to Thinking Machines'
;;;> customers, no promise of support is intended or implied.
;;;>
;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+

;;; Author:  JP Massar.


(def-starlisp "pvarp" :function :arglist "(object)" :docptr "M5,12" :info nil)
(def-starlisp "describe-pvar" :function :arglist "(pvar &optional stream)" :docptr "S5,105" :info "N")

(def-starlisp "*funcall" :macro :arglist "(function &rest args)" :docptr "M5,33" :info nil)
(def-starlisp "*apply" :macro :arglist "(function arg &optional args)" :docptr "M5,33" :info nil)
(def-starlisp "if!!" :macro :arglist "(pvar then-pvar &optional else-pvar)" :docptr "M5,31" :info nil)
(def-starlisp "cond!!" :macro :arglist "(list-of-condition-result-lists)" :docptr "M5,32" :info nil)
(def-starlisp "case!!" :macro :arglist nil :docptr nil :info "E")
(def-starlisp "*case" :macro :arglist nil :docptr nil :info "E")
(def-starlisp "ecase!!" :macro :arglist nil :docptr nil :info "E")
(def-starlisp "*ecase" :macro :arglist nil :docptr nil :info "E")

(def-starlisp "!!" :function :arglist "(lisp-expression)" :docptr "M5,28;S5,22,49;CG,16,59" :info "M")
(def-starlisp "+!!" :function :arglist "(&rest numeric-pvars)" :docptr "M5,28;S5,4;CG,21" :info "C")
(def-starlisp "*!!" :function :arglist "(&rest numeric-pvars)" :docptr "M5,28;S5,4;CG,21" :info "C")
(def-starlisp "-!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,28;S5,4;CG,21" :info "C")
(def-starlisp "/!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,28;S5,4;CG,21" :info "C")
(def-starlisp "1+!!" :function :arglist "(numeric-pvar)" :docptr "M5,28;S5,4" :info "C")
(def-starlisp "1-!!" :function :arglist "(numeric-pvar)" :docptr "M5,28;S5,4" :info "C")

(def-starlisp "*sum" :*defun :arglist "(numeric-pvar)" :docptr "M5,50" :info "C")
(def-starlisp "*logior" :*defun :arglist "(integer-pvar)" :docptr "M5,49" :info nil)
(def-starlisp "*logand" :*defun :arglist "(integer-pvar)" :docptr "M5,49" :info nil)
(def-starlisp "*min" :*defun :arglist "(numeric-pvar)" :docptr "M5,49" :info nil)
(def-starlisp "*max" :*defun :arglist "(numeric-pvar)" :docptr "M5,49" :info nil)
(def-starlisp "*and" :*defun :arglist "(pvar)" :docptr "M5,49" :info nil)
(def-starlisp "*or" :*defun :arglist "(pvar)" :docptr "M5,49" :info nil)

(def-starlisp "allocate!!" :macro :arglist "(&optional pvar-initial-value name type)" :docptr "M5,12" :info nil)
(def-starlisp "*deallocate" :function :arglist "(pvar)" :docptr "M5,12" :info nil)
(def-starlisp "*deallocate-*defvars" :function :arglist "(&rest pvar-names)" :docptr "M5,12" :info nil)

(def-starlisp "lognot!!" :function :arglist "(integer-pvar)" :docptr "M5,27;CG,21" :info nil)
(def-starlisp "logand!!" :function :arglist "(&rest integer-pvars)" :docptr "M5,27" :info nil)
(def-starlisp "logior!!" :function :arglist "(&rest integer-pvars)" :docptr "M5,27" :info nil)
(def-starlisp "logxor!!" :function :arglist "(&rest integer-pvars)" :docptr "M5,27" :info nil)
(def-starlisp "logeqv!!" :function :arglist "(&rest integer-pvars)" :docptr "M5,27" :info nil)

(def-starlisp "not!!" :function :arglist "(pvar)" :docptr "M5,26" :info nil)
(def-starlisp "null!!" :function :arglist "(pvar)" :docptr nil :info nil)
(def-starlisp "and!!" :macro :arglist "(&rest pvars)" :docptr "M5,26" :info nil)
(def-starlisp "or!!" :macro :arglist "(&rest pvars)" :docptr "M5,26" :info nil)
(def-starlisp "xor!!" :function :arglist "(&rest pvars)" :docptr "M5,26" :info nil)
(def-starlisp "equal!!" :function :arglist "(pvar1 pvar2)" :docptr "M5,24" :info nil)
(def-starlisp "eql!!" :function :arglist "(pvar1 pvar2)" :docptr "M5,24" :info nil)
(def-starlisp "eq!!" :function :arglist "(pvar1 pvar2)" :docptr "M5,24" :info nil)

(def-starlisp "=!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,24;S5,4" :info "C")
(def-starlisp "<!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,25" :info nil)
(def-starlisp ">!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,25" :info nil)
(def-starlisp "<=!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,25" :info nil)
(def-starlisp ">=!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,25" :info nil)
(def-starlisp "/=!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,25;S5,4" :info "C")

(def-starlisp "numberp!!" :function :arglist "(pvar)" :docptr "M5,24;S5,4":info "C")
(def-starlisp "integerp!!" :function :arglist "(pvar)" :docptr "M5,24" :info nil)
(def-starlisp "floatp!!" :function :arglist "(pvar)" :docptr "M5,24" :info nil)
(def-starlisp "zerop!!" :function :arglist "(numeric-pvar)" :docptr "M5,24;S5,4" :info "C")
(def-starlisp "oddp!!" :function :arglist "(numeric-pvar)" :docptr "M5,23" :info nil)
(def-starlisp "evenp!!" :function :arglist "(numeric-pvar)" :docptr "M5,23" :info nil)
(def-starlisp "plusp!!" :function :arglist "(numeric-pvar)" :doc23tr "M5,23" :info nil)
(def-starlisp "minusp!!" :function :arglist "(numeric-pvar)" :docptr "M5,24" :info nil)

(def-starlisp "signum!!" :function :arglist "(numeric-pvar)" :docptr "M5,30;S5,4" :info "C")
(def-starlisp "random!!" :function :arglist "(limit-pvar)" :docptr "M5,29" :info "M")
(def-starlisp "enumerate!!" :function :arglist nil :docptr "M5,32" :info nil)
(def-starlisp "abs!!" :function :arglist "(numeric-pvar)" :docptr "S5,4" :info "C")
(def-starlisp "rot!!" :function :arglist "(integer-pvar n-pvar word-size-pvar)" :docptr "M5,30" :info nil)
(def-starlisp "sin!!" :function :arglist "(radians)" :docptr "M5,30;S5,4" :info "C")
(def-starlisp "cos!!" :function :arglist "(radians)" :docptr "M5,30;S5,4" :info "C")
(def-starlisp "tan!!" :function :arglist "(radians)" :docptr "M5,30;S5,4" :info "C")
(def-starlisp "log!!" :function :arglist "(number &optional base)" :docptr "M5,30;S5,4,5" :info "CM")
(def-starlisp "exp!!" :function :arglist "(numeric-pvar)" :docptr "S5,4" :info "CM")
(def-starlisp "expt!!" :function :arglist "(base-pvar power-pvar)" :docptr "S5,4,5" :info "CM")

(def-starlisp "rank!!" :function :arglist "(numeric-pvar predicate)" :docptr "M5,32" :info nil)
(def-starlisp "sort!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "scan!!" :function :arglist "(pvar :function &key :direction :dimension :segment-pvar :include-self)" :docptr "M5,45;S5,79,86" :info "M")
(def-starlisp "scan-grid!!" :function :arglist "(pvar :function &key :dimension :direction :segment-pvar :include-self)" :docptr "M5,48" :info "O")
(def-starlisp "copy!!" other :arglist nil :docptr "M5,45,46;S5,38,50,86" :info nil)

(def-starlisp "pvar-to-array" :*defun :arglist "(source-pvar &optional dest-array &key :array-offset :cube-address :cube-address-end)" :docptr "M5,44" :info nil)

(def-starlisp "pvar-to-array-grid" :*defun :arglist "(source-pvar &optional dest-array &key :array-offset :grid-start :grid-end)" :docptr "M5,44;S5,79" :info "D")

(def-starlisp "array-to-pvar" :*defun :arglist "(source-array &optional dest-pvar)" :docptr "M5,44" :info nil)

(def-starlisp "array-to-pvar-grid" :*defun :arglist "(source-array &optional dest-pvar &key :array-offset :grid-start :grid-end)" :docptr "M5,45;S5,78" :info "D")

(def-starlisp "min!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,28" :info nil)
(def-starlisp "max!!" :function :arglist "(numeric-pvar &rest numeric-pvars)" :docptr "M5,28" :info nil)

(def-starlisp "load-byte!!" :function :arglist "(from-pvar position-pvar size-pvar)" :docptr "M5,30" :info nil)
(def-starlisp "ldb!!" :function :arglist "(bytespec-pvar integer-pvar)" :docptr "S5,120" :info nil)
(def-starlisp "deposit-byte!!" :function :arglist "(into-pvar position-pvar size-pvar byte-pvar)" :docptr "M5,31" :info nil)
(def-starlisp "dpb!!" :function :arglist "(newbyte-pvar bytespec-pvar integer-pvar)" :docptr "S5,120" :info nil)
(def-starlisp "byte!!" :function :arglist "(size-pvar position-pvar)" :docptr "S5,119" :info "N")
(def-starlisp "byte-size!!" :function :arglist "(bytespec-pvar)" :docptr "S5,119" :info "N")
(def-starlisp "byte-position!!" :function :arglist "(bytespec-pvar)" :docptr "S5,120" :info "N")
(def-starlisp "ash!!" :function :arglist "(integer-pvar count-pvar)" :docptr "M5,29" :info "M")
(def-starlisp "mod!!" :function :arglist "(numeric-pvar integer-pvar)" :docptr "M5,29" :info nil)
(def-starlisp "rem!!" :function :arglist "(numeric-pvar numeric-divisor-pvar)" :docptr "S5,110" :info nil)
(def-starlisp "float!!" :function :arglist "(number-pvar &optional fp-format-pvar)" :docptr "M5,30;S5,112;CG,22" :info nil)
(def-starlisp "sqrt!!" :function :arglist "(complex-or-non-negative-pvar)" :docptr "M5,29;S5,4;CG,21" :info "CM")
(def-starlisp "isqrt!!" :function :arglist "(non-negative-integer-pvar)" :docptr "M5,29" :info nil)
(def-starlisp "ceiling!!" :function :arglist "(numeric-pvar &optional divisor-numeric-pvar)" :docptr "M5,29" :info nil)
(def-starlisp "floor!!" :function :arglist "(numeric-pvar &optional divisor-numeric-pvar)" :docptr "M5,29" :info nil)
(def-starlisp "truncate!!" :function :arglist "(numeric-pvar &optional divisor-numeric-pvar)" :docptr "M5,29" :info nil)
(def-starlisp "round!!" :function :arglist "(numeric-pvar &optional divisor-numeric-pvar)" :docptr "M5,29" :info nil)

(def-starlisp "pref" :macro :arglist "(pvar address)" :docptr "M5,14;S5,37,94,98,106;CG,5" :info "MV")
(def-starlisp "pref-grid" :macro :arglist "(pvar &rest addresses)" :docptr "M5,3" :info "O")

(def-starlisp "cube-from-grid-address" :function :arglist "(address-pvar &rest address-pvars)" :docptr "M5,50;S5,80" :info "D")
(def-starlisp "grid-from-cube-address" :function :arglist "(cube-address dimensions)" :docptr "M5,50;S5,82" :info "D")

(def-starlisp "dimension-size" :function :arglist "(dimension)" :docptr "M5,56;S5,80" :info "D")
(def-starlisp "self-address!!" :function :arglist nil :docptr "M5,50" :info nil)
(def-starlisp "self-address-grid!!" :function :arglist "(dimension-pvar)" :docptr "M5,50;S5,80" :info "D")

(def-starlisp "cube-from-grid-address!!" :function :arglist "(address-pvar &rest address-pvars)" :docptr "M5,51;S5,80" :info "D")
(def-starlisp "grid-from-cube-address!!" :function :arglist "(cube-address-pvar dimension-pvar)" :docptr "M5,51;S5,81" :info "D")

(def-starlisp "cube-from-vp-grid-address!!" :function :arglist "(vp-set interger-pvar &rest integer-pvars)" :docptr "S5,88,98" :info "N")
(def-starlisp "cube-from-vp-grid-address" :function :arglist "(vp-set integer & rest integers)" :docptr "S5,87,98" :info "N")
(def-starlisp "grid-from-vp-cube-address!!" :function :arglist "(vp-set cube-address-pvar dimension-pvar)" :docptr "S5,90" :info "N")
(def-starlisp "grid-from-vp-cube-address" :function :arglist "(vp-set cube-address dimension)" :docptr "S5,89" :info "N")
;;lauranne stopped adding stuff here for now
(def-starlisp "pref!!" :macro :arglist nil :docptr "M5,6" :info "SMDV")
(def-starlisp "pref-grid!!" :macro :arglist nil :docptr "M5,6" :info "O")
(def-starlisp "pref-grid-relative!!" :macro :arglist nil :docptr "M5,6" :info "O")
(def-starlisp "*pset" :macro :arglist nil :docptr "M5,6;S5" :info "SDV")
(def-starlisp "*pset-grid" :macro :arglist nil :docptr "M5,6" :info "O")
(def-starlisp "*pset-grid-relative" :macro :arglist nil :docptr "M5,6" :info "O")
(def-starlisp "off-grid-border-p!!" :function :arglist nil :docptr "M5,6;S5" :info "D")
(def-starlisp "off-vp-grid-border-p!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "off-grid-border-relative-p!!" :function :arglist nil :docptr "M5,6;S5" :info "D")

(def-starlisp "*cold-boot" :macro :arglist nil :docptr "M5,7;S5" :info "M")
(def-starlisp "*warm-boot" :macro :arglist nil :docptr "M5,7;S5" :info "M")
(def-starlisp "pretty-print-pvar" :macro :arglist nil :docptr nil :info "DV")
(def-starlisp "ppp" :macro :arglist nil :docptr nil :info "DV")
(def-starlisp "ppp!!" :macro :arglist nil :docptr nil :info "NV")
(def-starlisp "pppdbg" :macro :arglist nil :docptr nil :info "NV")
(def-starlisp "ppp-address-object" :function :arglist nil :docptr nil :info "NV")
(def-starlisp "list-of-active-processors" :function :arglist nil :docptr "M5,5" :info nil)
(def-starlisp "loap" :macro :arglist nil :docptr nil :info nil)
(def-starlisp "pretty-print-pvar-in-currently-selected-set" :macro :arglist nil :docptr "M5,5" :info nil)
(def-starlisp "ppp-css" :macro :arglist nil :docptr nil :info nil)
(def-starlisp "test-*lisp" :function :arglist nil :docptr nil :info nil)
(def-starlisp "*proclaim" :macro :arglist nil :docptr "M5,3;CG" :info nil)

(def-starlisp "t!!" variable :arglist nil :docptr "M5,5" :info nil)
(def-starlisp "nil!!" variable :arglist nil :docptr "M5,5" :info nil)
(def-starlisp "*number-of-processors-limit*" variable :arglist nil :docptr "M5,7;S5" :info "D")
(def-starlisp "*log-number-of-processors-limit*" variable :arglist nil :docptr  "M5,7" :info nil)
(def-starlisp "*number-of-dimensions*" variable :arglist nil :docptr  "M5,7;S5" :info "D")
(def-starlisp "*current-cm-configuration*" variable :arglist nil :docptr "M5,7;S5" :info "D")
(def-starlisp "*current-vp-set*" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*default-vp-set*" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*current-grid-address-lengths*" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*current-send-address-length*" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*minimum-size-for-vp-set*" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*before-*cold-boot-initializations*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*before-*warm-boot-initializations*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*after-*cold-boot-initializations*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*after-*warm-boot-initializations*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-format*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-end*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-start*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-title*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-ordering*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-per-line*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-processor-list*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*ppp-default-mode*" variable :arglist nil :docptr nil :info nil)

(def-starlisp "delete-initialization" :function :arglist nil :docptr "M5,7" :info nil)
(def-starlisp "add-initialization" :function :arglist nil :docptr "M5,7" :info nil)

(def-starlisp "boolean-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "field-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "signed-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "character-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "string-char-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "general-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "boolean" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "unsigned-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "defined-float" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "short-float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "single-float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "double-float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "long-float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "extended-float-pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "short-complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "single-complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "double-complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "long-complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "extended-complex-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "array-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "vector-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "bit-vector-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "string-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "signed-byte-pvar" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "unsigned-byte-pvar" deftype :arglist nil :docptr nil :info "N")

(def-starlisp "short-float-mantissa" variable :arglist nil :docptr nil :info nil)
(def-starlisp "single-float-mantissa" variable :arglist nil :docptr nil :info nil)
(def-starlisp "double-float-mantissa" variable :arglist nil :docptr nil :info nil)
(def-starlisp "long-float-mantissa" variable :arglist nil :docptr nil :info nil)
(def-starlisp "extended-float-mantissa" variable :arglist nil :docptr nil :info nil)
(def-starlisp "short-float-exponent" variable :arglist nil :docptr nil :info nil)
(def-starlisp "single-float-exponent" variable :arglist nil :docptr nil :info nil)
(def-starlisp "double-float-exponent" variable :arglist nil :docptr nil :info nil)
(def-starlisp "long-float-exponent" variable :arglist nil :docptr nil :info nil)
(def-starlisp "extended-float-exponent" variable :arglist nil :docptr nil :info nil)

(def-starlisp "with-*lisp-from-paris" :macro :arglist nil :docptr nil :info "O")
(def-starlisp "with-paris-from-*lisp" :macro :arglist nil :docptr nil :info "O")
(def-starlisp "pvar" deftype :arglist nil :docptr nil :info nil)
(def-starlisp "*set" :macro :arglist nil :docptr "M5,3;S5" :info nil)
(def-starlisp "*setf" :macro :arglist nil :docptr "S5,2" :info "N")
(def-starlisp "*defsetf" :macro :arglist nil :docptr nil :info "NE")
(def-starlisp "*undefsetf" :macro :arglist nil :docptr nil :info "NE")
(def-starlisp "alias!!" :macro :arglist nil :docptr "S5" :info "N")
(def-starlisp "*defvar" :macro :arglist nil :docptr "M5,3;S5" :info "MS")
(def-starlisp "*let" :macro :arglist nil :docptr "M5,3" :info nil)
(def-starlisp "*let*" :macro :arglist nil :docptr "M5,3" :info nil)
(def-starlisp "*cond" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "*if" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "*all" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "*when" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "*unless" :macro :arglist nil :docptr nil :info nil)
(def-starlisp "with-css-saved" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "do-for-selected-processors" :macro :arglist nil :docptr "M5,4" :info nil)
(def-starlisp "*defun" :macro :arglist nil :docptr "M5,5" :info nil)

(def-starlisp "*compilep*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*warning-level*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*inconsistency-action*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*safety*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*slc-print-length*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*slc-print-level*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*optimize-bindings*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*optimize-peephole*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*pull-out-subexpressions*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*use-always-instructions*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*machine-type*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*add-declares*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*use-undocumented-paris*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*verify-type-declarations*" compiler-variable :arglist nil :docptr nil :info "N")
(def-starlisp "*constant-fold*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*speed*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*compilation-speed*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*space*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*immediate-error*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*immediate-error-if-location*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*optimize-check-stack*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*generate-comments*" compiler-variable :arglist nil :docptr nil :info nil)

(def-starlisp "*verbose*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*compiling*" compiler-variable :arglist nil :docptr nil :info nil)
(def-starlisp "*check-stack*" compiler-variable :arglist nil :docptr nil :info nil)

(def-starlisp "*optimize" declaration :arglist nil :docptr nil :info nil)
(def-starlisp "*option" declaration :arglist nil :docptr nil :info nil)
(def-starlisp "return-pvar-p" other :arglist nil :docptr nil :info "N")

(def-starlisp "current" :function :arglist nil :docptr nil :info nil)
(def-starlisp "options" :function :arglist nil :docptr nil :info nil)
(def-starlisp "compiler-options" :function :arglist nil :docptr nil :info nil)

(def-starlisp "cspeed<3" other :arglist nil :docptr nil :info nil)

(def-starlisp "*interpreter-safety*" variable :arglist nil :docptr nil :info "N")
(def-starlisp "unproclaim" :function :arglist nil :docptr nil :info "N")

(def-starlisp "pvar-location" :function :arglist nil :docptr nil :info "M")
(def-starlisp "pvar-length" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-type" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-plist" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-name" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-exponent-length" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-mantissa-length" :function :arglist nil :docptr nil :info nil)
(def-starlisp "pvar-vp-set" :function :arglist nil :docptr "S5" :info "N")

(def-starlisp "lognand!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "lognor!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logandc1!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logandc2!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logorc1!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logorc2!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logtest!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logbitp!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "logcount!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "integer-length!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "ldb-test!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "mask-field!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "deposit-field!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "boole!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "ffloor!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "fceiling!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "ftruncate!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "fround!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "gcd!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "lcm!!" :function :arglist nil :docptr nil :info nil)
(def-starlisp "*integer-length" :*defun :arglist nil :docptr nil :info nil)
(def-starlisp "*xor" :*defun :arglist nil :docptr nil :info nil)
(def-starlisp "*logxor" :*defun :arglist nil :docptr nil :info nil)
(def-starlisp "*light" :*defun :arglist nil :docptr nil :info nil)

(def-starlisp "sinh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "cosh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "tanh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "asinh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "acosh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "atanh!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "asin!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "acos!!" :function :arglist nil :docptr "S5" :info "NC")
(def-starlisp "atan!!" :function :arglist nil :docptr "S5" :info "NC")

(def-starlisp "*incf" :macro :arglist nil :docptr nil :info "C")
(def-starlisp "*decf" :macro :arglist nil :docptr nil :info "C")

(def-starlisp "*defstruct" :macro :arglist nil :docptr "S5" :info "N")
(def-starlisp "structurep!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "integer-from-gray-code!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "gray-code-from-integer!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "float-sign!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "scale-float!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "compare!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "integer-reverse!!" :function :arglist nil :docptr nil :info "N")

(def-starlisp "front-end!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "front-end" deftype :arglist nil :docptr nil :info "N")
(def-starlisp "booleanp!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "front-end-p!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "most-positive-float!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "least-positive-float!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "float-epsilon!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "most-negative-float!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "least-negative-float!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "negative-float-epsilon!!" :function :arglist nil :docptr nil :info "N")

(def-starlisp "complexp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "complex!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "realpart!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "imagpart!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "phase!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "conjugate!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "cis!!" :function :arglist nil :docptr "S5" :info "N")

(def-starlisp "coerce!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "typep!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "taken-as!!" :function :arglist nil :docptr nil :info "NE")

(def-starlisp "twinkle-twinkle-little*" :function :arglist nil :docptr nil :info nil)

(def-starlisp "standard-char-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "graphic-char-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "string-char-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "alpha-char-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "upper-case-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "lower-case-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "both-case-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "digit-char-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "alphanumericp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char=!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char/=!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char<!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char>!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char<=!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char>=!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-equal!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-not-equal!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-lessp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-greaterp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-not-greaterp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-not-lessp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-code!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-bits!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-font!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "code-char!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "make-char!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "character!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-upcase!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-downcase!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-flipcase!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "digit-char!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-int!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "int-char!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "char-bit!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "set-char-bit!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "characterp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*char-code-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*char-bits-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*char-font-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*character-limit" variable :arglist nil :docptr nil :info "N")
(def-starlisp "*char-code-length" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*char-bits-length" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*char-font-length" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*character-length" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "initialize-character" :function :arglist nil :docptr "S5" :info "N")

(def-starlisp "make-array!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*map" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-rank-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-dimension-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-total-size-limit" variable :arglist nil :docptr "S5" :info "N")
(def-starlisp "typed-vector!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "aref!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*sideways-array" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sideways-aref!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "*array-element-type" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-rank" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "array-rank!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-dimension" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "array-dimension!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-dimensions" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "*array-total-size" :*defun :arglist nil :docptr "S5" :info "N")
(def-starlisp "array-total-size!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "array-row-major-index!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "array-dimensions!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "array-in-bounds-p!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "sbit!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "equalp!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-and!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-ior!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-xor!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-eqv!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-nand!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-nor!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-andc1!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-andc2!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-orc1!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-orc2!!" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "bit-not!!" :function :arglist nil :docptr "S5" :info "N")

(def-starlisp "def-vp-set" :macro :arglist nil :docptr "S5" :info "N")
(def-starlisp "create-vp-set" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "allocate-vp-set-processors" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "allocate-processors-for-vp-set" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "*with-vp-set" :macro :arglist nil :docptr "S5" :info "N")
(def-starlisp "set-vp-set" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "deallocate-vp-set" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "let-vp-set" :macro :arglist nil :docptr "S5" :info "NE")
(def-starlisp "describe-vp-set" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "vp-set-dimensions" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "set-vp-set-geometry" :function :arglist nil :docptr nil :info "N")

(def-starlisp "grid" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "grid!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "grid-relative!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "address-object" deftype :arglist nil :docptr nil :info "NE")
(def-starlisp "address-nth" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "address-nth!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "address-plus-nth" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "address-plus-nth!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "address-rank" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "address-rank!!" :function :arglist nil :docptr nil :info "NE")

(def-starlisp "news!!" :macro :arglist nil :docptr "S5" :info "N")
(def-starlisp "news-border!!" :macro :arglist nil :docptr nil :info "N")
(def-starlisp "*news" :*defun :arglist nil :docptr nil :info "N")
(def-starlisp "dimension-address-length" :function :arglist nil :docptr "S5" :info "N")
(def-starlisp "self!!" :function :arglist nil :docptr "S5" :info "NE")

(def-starlisp "subseq!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "copy-seq!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "length!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "reverse!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "*nreverse" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "some!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "every!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "notany!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "notevery!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "reduce!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "*fill" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "substitute!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "substitute-if!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "substitute-if-not!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "nsubstitute!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "nsubstitute-if!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "nsubstitute-if-not!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "find!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "find-if!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "find-if-not!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "position!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "position-if!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "position-if-not!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "count!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "count-if!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "count-if-not!!" :function :arglist nil :docptr "S5" :info "NE")

(def-starlisp "v+!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v-!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v*!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v/!!" :function :arglist "(vector-pvar &rest vector-pvars)" :docptr nil :info nil)
(def-starlisp "dot-product!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "cross-product!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vabs!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vabs-squared!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vscale!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vscale-to-unit-vector!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "*vset-components" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "*sf-vset-components" :*defun :arglist nil :docptr "S5" :info "NE")

(def-starlisp "sf-v+-constant!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v--constant!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v*-constant!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v/-constant!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v+-constant!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v--constant!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v*-constant!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v/-constant!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v+!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v-!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-v*!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v+!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v-!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-v*!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-vabs!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-vabs-squared!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-dot-product!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-vscale!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-vscale-to-unit-vector!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-cross-product!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "sf-vector-normal!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-cross-product!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-vscale!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-vscale-to-unit-vector!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "dsf-vector-normal!!" :*defun :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v+-constant" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v--constant" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v*-constant" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v/-constant" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v+" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v-" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v*" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "v/" :function :arglist nil :docptr NIL :info NIL)
(def-starlisp "dot-product" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vabs-squared" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vabs" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "cross-product" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "vscale" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vscale-to-unit-vector" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vector-normal" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vfloor" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vceiling" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vround" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "vtruncate" :function :arglist nil :docptr "S5" :info "NE")

(def-starlisp "spread!!" :function :arglist nil :docptr nil :info "N")
(def-starlisp "reduce-and-spread!!" :function :arglist nil :docptr nil :info "N")

(def-starlisp "power-of-two-p" :function :arglist nil :docptr nil :info "N")
(def-starlisp "next-power-of-two->=" :function :arglist nil :docptr nil :info "N")

(def-starlisp "*locally" :macro :arglist nil :docptr nil :info "NE")

(def-starlisp "allocated-pvar-p" :function :arglist nil :docptr nil :info "N")

(def-starlisp "create-geometry" :function :arglist nil :docptr "S5" :info "N")

(def-starlisp "deallocate-def-vp-sets" :function :arglist nil :docptr nil :info "N")

(def-starlisp "create-segment-set!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "segment-set-scan!!" :function :arglist nil :docptr "S5" :info "NE")
(def-starlisp "segment-set" :deftype :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-start-bits" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-end-bits" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-processor-not-in-any-segment!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-start-address!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-end-address!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-start-bits!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-end-bits!!" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-processor-not-in-any-segment" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-start-address" :function :arglist nil :docptr nil :info "NE")
(def-starlisp "segment-set-end-address" :function :arglist nil :docptr nil :info "NE")

(def-starlisp "sideways-array-p" :function :arglist nil :docptr nil :info "NE")

(def-starlisp "help" :function :arglist "(&optional symbol)" :doctpr nil :info "N")

(def-starlisp "un*defun" :function :arglist "(&rest function-names)" :doctptr nil :info "A")

(def-starlisp "vp-set-deallocated-p" :function :arglist nil :docptr nil :info "A")

(def-starlisp "news-direction!!" :macro :arglist "(pvar dimension distance)" :docptr nil :info "A")
(def-starlisp "*news-direction" :*defun :arglist "(source destination dimension-scalar distance-scalar)" :doctpr nil :info "A")
(def-starlisp "off-grid-border-relative-direction-p!!" :function :arglist "(coordinate-pvar dimension)" :doctpr nil :info "A")

(def-starlisp "deallocate-processors-for-vp-set" :function :arglist "(vp-set)" :docptr nil :info "A")
(def-starlisp "deallocate-vp-set-processors" :function :arglist "(vp-set)" :docptr nil :info "A")
(def-starlisp "with-processors-allocated-for-vp-set"
	      :macro :arglist "(vp-set &key dimensions geometry send-pattern)" :docptr nil :info "A")

(def-starlisp "vector!!" :function :arglist nil :docptr nil :info "AE")
(def-starlisp "array!!" :function :arglist nil :docptr nil :info "AE")
(def-starlisp "amap!!" :function :arglist nil :docptr nil :info "A")
(def-starlisp "row-major-aref!!" :function :arglist nil :docptr nil :info "A")
(def-starlisp "row-major-sideways-aref!!" :function :arglist nil :docptr nil :info "AE")
 
(def-starlisp "*slicewise" :*defun :arglist "(:array-pvar)" :doctpr nil :info "AE")
(def-starlisp "*processorwise" :*defun :arglist "(:array-pvar)" :docptr nil :info "AE")

(def-starlisp "*trace" :macro :arglist "(&rest *defun-function-names)" :docptr nil :info "A")
(def-starlisp "*untrace" :macro :arglist "(&rest *defun-function-names)" :docptr nil :info "A")

(def-starlisp "vp-set-vp-ratio" :function :arglist "(vp-set)" :docptr nil :info "A")
(def-starlisp "vp-set-total-size" :function :arglist "(vp-set)" :doctpr nil :info "A")
(def-starlisp "vp-set-rank" :function :arglist "(vp-set)" :doctpr nil :info "A")
(def-starlisp "*room" :function :arglist "(&key (how :by-vp-set) (print-statistics t) (stream t))" :doctpr nil :info "AE")
(def-starlisp "ppp-struct" :function
  :arglist "(pvar per-line &key (start nil) (end nil) (print-array t) (stream t) (width 8) (title t))"
  :doctpr nil :info "BE"
  )

(def-starlisp "pref-sideways-aref!!" :macro
  :arglist "(vp-set address-pvar an-array-pvar &rest index-pvars)" :docptr nil :info "B"
  )

(def-starlisp "*use-code-walker*" variable :arglist nil :docptr nil :info "B")
(def-starlisp "*rewrite-arithmetic-expressions*" variable :arglist nil :docptr nil :info "B")
(def-starlisp "*expand-wrapper*" variable :arglist nil :docptr nil :info "B")
(def-starlisp "*array-size-inline-limit*" variable :arglist nil :docptr nil :info "B")

(def-starlisp "stable-sort!!" :function :arglist "(pvar predicate &key dimension segment-pvar key)" :docptr nil :info "B")
(def-starlisp "stable-rank!!" :function :arglist "(pvar predicate &key dimension segment-pvar)" :docptr nil :info "B")

(def-starlisp "*lisp" :function :arglist "(&optional (select-*lisp :toggle))" :docptr nil :info "B")

(def-starlisp "vp-set-geometry" :function :arglist "(vp-set)" :docptr nil :info "B")

(def-starlisp "deallocate-geometry" :function :arglist "(geometry)" :docptr nil :info nil)

(def-starlisp "compare!!" :function :arglist "(pvar1 pvar2)" :docptr nil :info nil)

(def-starlisp "v+scalar!!" :function :arglist "(vector-pvar scalar-pvar)" :docptr nil :info nil)
(def-starlisp "v-scalar!!" :function :arglist "(vector-pvar scalar-pvar)" :docptr nil :info nil)
(def-starlisp "v*scalar!!" :function :arglist "(vector-pvar scalar-pvar)" :docptr nil :info nil)
(def-starlisp "v/scalar!!" :function :arglist "(vector-pvar scalar-pvar)" :docptr nil :info nil)

(def-starlisp "vector-normal!!" :function :arglist "(vector-pvar1 vector-pvar2)" :docptr nil :info nil)

(def-starlisp "trace-stack" :function :arglist "(&optional (trace-type (trace-action :trace) (verbose t)))" :docptr nil :info nil)

(def-starlisp "*maximum-stack-function*" variable :arglist nil :docptr nil :info nil)
(def-starlisp "*maximum-stack-level*" variable :arglist nil :docptr nil :info nil)

(def-starlisp "ppme" :macro :arglist "(form)" :docptr nil :info nil)
