;;; -*- Mode: LISP; Syntax: Common-lisp; Package: (*SIM-I COMMON-LISP-GLOBAL); Base: 10 -*-
;;; (c) Copyright 1987, Jim Salem, JP Massar Thinking Machines Corporation, Inc.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+
;;;> Copyright 1986 Thinking Machines Corporation, Inc. of Cambridge, Massachusetts.
;;;> 
;;;> Permission is hereby granted to copy this source onto any machine at a site
;;;> which legitimately has this software, and to execute the resulting object
;;;> code on any machine at a site which legitimately has this software.

;;;> Permission is hereby granted to make such changes as are necessary to port this
;;;> source to a version of Common Lisp running on any machine so long as said changes
;;;> are sent back to Thinking Machines so that they may be incorporated in future
;;;> releases.

;;;> Bugs, comments and revisions due to porting can be sent to:
;;;> bug-starlisp@think.com

;;;> The *Lisp Simulator was written by JP Massar.
;;;> The *Lisp language was designed by Cliff Lasser and Steve Omohundro, with
;;;> help from may others at Thinking Machines Corporation.

;;;> *+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+*+



;;;; *****     WARNING WARNING WARNING WARNING WARNING WARNING      *****
;;;;
;;;; This code is shared between the *Lisp Interpreter and the
;;;; *Lisp Simulator.  DO NOT MAKE CHANGES IN THIS CODE UNLESS
;;;; YOU ARE ABSOLUTELY SURE THE CHANGES APPLY EQUALLY TO BOTH
;;;; SYSTEMS OR YOU ARE VERY CAREFUL TO CONDITIONALLY COMPILE!
;;;; VIOLATE THIS WARNING AT YOUR OWN RISK!
;;;;
;;;; *****     WARNING WARNING WARNING WARNING WARNING WARNING      *****


;;; Author:  JP Massar


(IN-PACKAGE '*SIM-I)


(*defstruct (foo)
   (a 3 :type (unsigned-byte 8))
   (b 0.0 :type single-float)
   )

(*defstruct (baz)
  (a (make-array 3) :type (array (unsigned-byte 8) (3)) :cm-uninitialized-p t)
  (b 0 :type (unsigned-byte 3))
  )

(*defstruct (nested)
  (a nil :type (array baz (3)) :cm-uninitialized-p t)
  (b t :type boolean)
  )

(*defstruct (varlength)
  (a 3 :type t :cm-type (pvar (unsigned-byte *log-number-of-processors-limit*)))
  (b 0.0 :type t :cm-type (pvar (array (unsigned-byte 8) (*log-number-of-processors-limit*))))
  )

(defun-wco first-structure-test ()
  (*let (afoo)
    (declare (type (pvar (structure foo)) afoo))
    (*setf (foo-a!! afoo) (!! 2))
    (pref (foo-a!! afoo) 0)
    ))

(defun-wco test-simple-foo-*defstruct ()

  ;; check that all the documented functions that are supposed to be
  ;; created are created.

  (format t "~%~%Testing simple *defstruct")

  (flet

    ((check-initial-slot-values (a-foo tag)
       (assert (*and (=!! (!! 3) (foo-a!! a-foo))) () "Slot A not initialized properly by ~S" tag)
       (assert (*and (=!! (!! 0.0) (foo-b!! a-foo))) () "Slot B not initialized properly by ~S" tag)
       )

     (check-slot-values (a-foo a-scalar b-scalar tag)
       (assert (*and (=!! (!! a-scalar) (foo-a!! a-foo))) () "~S: Slot A is not everywhere ~S" tag a-scalar)
       (assert (*and (=!! (!! b-scalar) (foo-b!! a-foo))) () "~S: Slot B is not everywhere ~S" tag b-scalar)
       )

     )

    (format t "~%Testing for documented functions' existence")

    (*all

      (mapc
	#'(lambda (function-name)
	    (assert (fboundp function-name) () "The documented function ~S is not defined for *defstruct foo" function-name))
	'(make-foo!! copy-foo!! foo-p!! foo-a!! foo-b!! make-foo copy-foo foo-p foo-a foo-b)
	)

      ;; make sure one can be created, with the proper initial values in
      ;; its slots.  This tests the accessors.

      (format t "~%Testing creation and initialization of structure pvar. ")

      (*let ((a-foo (make-foo!!)))
	(declare (type (pvar (structure foo)) a-foo))
	(check-initial-slot-values a-foo '*let)
	)
      (format t "*let, ")
      
      (let ((a-foo (make-foo!!)))
	(check-initial-slot-values a-foo 'make-foo!!)
	)
      (format t "make-foo!!, ")

      (let ((a-foo (allocate!! (make-foo!!) nil '(pvar (structure foo)))))
	(check-initial-slot-values a-foo 'allocate!!)
	)
      (format t "allocate!!, ")

      (eval '(progn
	       (*proclaim '(type (pvar (structure foo)) a-foo))
	       (*defvar a-foo (make-foo!!))
	       ))

      (check-initial-slot-values (eval 'a-foo) '*proclaim/*defvar)
      (*deallocate-*defvars 'a-foo)
      (format t "*defvar, ")
      
      (let ((a-foo (!! (make-foo))))
	(check-initial-slot-values a-foo '!!)
	)
      (format t "!!.")

      (format t "~%Testing aliasing and *SETF methods")

      (*let (a-foo)
	(declare (type (pvar (structure foo)) a-foo))
	(*setf (foo-a!! a-foo) (!! 4))
	(*setf (foo-b!! a-foo) (!! 1.3))
	(check-slot-values a-foo 4 1.3 '*SETF)
	(let ((a (alias!! (foo-a!! a-foo)))
	      (b (alias!! (foo-b!! a-foo)))
	      )
	  (*set a (!! 0))
	  (*set b (!! 2.0))
	  (check-slot-values a-foo 0 2.0 'ALIAS!!/*SET)
	  ))

      (format t "~%Testing predicates on structure pvar")

      (*let (a-foo)
	(declare (type (pvar (structure foo)) a-foo))
	(assert (*and (foo-p!! a-foo)) () "Predicate foo-p!! not everywhere satisfied"))
	(assert (not (*or (foo-p!! nil!!))) () "Predicate foo-p!! is satisfied of nil!!")
	)

      (format t "~%Testing pref and *setf-pref on structure pvar")

      (*let ((a-foo (make-foo!!)))
	(declare (type (pvar (structure foo)) a-foo))
	(print (list 'a-foo1 a-foo))
	(assert (equalp (make-foo) (pref a-foo 0)))
	(print (list 'a-foo2 a-foo))
	(*setf (pref a-foo 0) (make-foo :a 5 :b 3.14))
	(print (list 'a-foo3 a-foo))
	(assert (equalp (make-foo :a 5 :b 3.14) (pref a-foo 0)))
	(print (list 'a-foo4 a-foo))
	(*when (zerop!! (self-address!!))
	  (check-slot-values a-foo 5 3.14 '*SETF-PREF)
	  ))

      (format t "~%Testing copy function")

      (*let ((a-foo (make-foo!!)))
	(declare (type (pvar (structure foo)) a-foo))
	(let ((a-copy-of-a-foo (copy-foo!! a-foo)))
	  (check-initial-slot-values a-copy-of-a-foo 'copy-foo!!)
	  ))

      (format t "~%Testing *SETF (PREF (<slot-accessor ...")
      (*let (a-foo)
	(declare (type (pvar (structure foo)) a-foo))
	(*setf (pref (foo-a!! a-foo) 0) 23)
	(assert (eql 23 (pref (foo-a!! a-foo) 0)))
	)

      (Format t "~%Done testing simple *defstruct functionality~%")

      ))


(*defstruct (xyzzy
	      (:conc-name plugh-)
	      (:cm-copier duplicate-xyzzy!!)
	      (:copier duplicate-xyzzy)
	      (:cm-constructor create-xyzzy!!)
	      (:constructor create-xyzzy)
	      (:parallel-cm-predicate is-it-an-xyzzy?!!)
	      ;; (:global-cm-predicate *is-it-an-xyzzy?)
	      (:predicate is-it-an-xyzzy?)
	      (:print-function print-the-magic-word)
	      (:include foo)
	      )
  (c 3 :type (member 3 5) :cm-type (pvar (unsigned-byte 12)) :cm-initial-value (!! 4))
  (d nil :type boolean :cm-uninitialized-p t)
  )

(defun-wco print-the-magic-word (s stream depth)
  depth
  (format stream "<A: ~S, B: ~S, C: ~S, D: ~S>" (plugh-a s) (plugh-b s) (plugh-c s) (plugh-d s))
  )



(defun-wco test-complex-xyzzy-*defstruct ()
  
  ;; check that all the documented functions that are supposed to be
  ;; created are created.

  (format t "~%~%Testing complex *defstruct")

  (flet

    ((check-initial-slot-values (a-xyzzy tag)
       (assert (*and (=!! (!! 3) (plugh-a!! a-xyzzy))) () "Slot A not initialized properly by ~S" tag)
       (assert (*and (=!! (!! 0.0) (plugh-b!! a-xyzzy))) () "Slot B not initialized properly by ~S" tag)
       (assert (*and (=!! (!! 4) (plugh-c!! a-xyzzy))) () "Slot C not initialized properly by ~S" tag)
       )

     (check-slot-values (a-xyzzy a-scalar b-scalar c-scalar d-scalar tag)
       (assert (*and (=!! (!! a-scalar) (plugh-a!! a-xyzzy))) () "~S: Slot A is not everywhere ~S" tag a-scalar)
       (assert (*and (=!! (!! b-scalar) (plugh-b!! a-xyzzy))) () "~S: Slot B is not everywhere ~S" tag b-scalar)
       (assert (*and (=!! (!! c-scalar) (plugh-c!! a-xyzzy))) () "~S: Slot C is not everywhere ~S" tag b-scalar)
       (assert (*and (eql!! (!! d-scalar) (plugh-d!! a-xyzzy))) () "~S: Slot D is not everywhere ~S" tag b-scalar)
       )

     )

    (format t "~%Testing for documented functions' existence")

    (*all

      (mapc
	#'(lambda (function-name)
	    (assert (fboundp function-name) () "The documented function ~S is not defined for *defstruct xyzzy" function-name))
	'(
	  create-xyzzy!! duplicate-xyzzy!! is-it-an-xyzzy?!! plugh-a!! plugh-b!! plugh-c!! plugh-d!!
	  create-xyzzy duplicate-xyzzy is-it-an-xyzzy? plugh-a plugh-b plugh-c plugh-d
	  ))

      ;; make sure one can be created, with the proper initial values in
      ;; its slots.  This tests the accessors.

      (format t "~%Testing creation and initialization of structure pvar. ")

      (*let ((a-xyzzy (create-xyzzy!!)))
	(declare (type (pvar (structure xyzzy)) a-xyzzy))
	(check-initial-slot-values a-xyzzy '*let)
	)
      (format t "*let, ")
      
      (let ((a-xyzzy (create-xyzzy!!)))
	(check-initial-slot-values a-xyzzy 'create-xyzzy!!)
	)
      (format t "create-xyzzy!!, ")

      (let ((a-xyzzy (allocate!! (create-xyzzy!!) nil '(pvar (structure xyzzy)))))
	(check-initial-slot-values a-xyzzy 'allocate!!)
	)
      (format t "allocate!!, ")

      (eval '(progn
	       (*proclaim '(type (pvar (structure xyzzy)) a-xyzzy))
	       (*defvar a-xyzzy (create-xyzzy!!))
	       ))
      (check-initial-slot-values (eval 'a-xyzzy) '*proclaim/*defvar)
      (*deallocate-*defvars 'a-xyzzy)
      (format t "*defvar, ")
      
      (let ((a-xyzzy (!! (create-xyzzy))))
	(check-slot-values a-xyzzy 3 0.0 3 nil '!!)
	)
      (format t "!!.")

      (format t "~%Testing aliasing and *SETF methods")

      (*let (a-xyzzy)
	(declare (type (pvar (structure xyzzy)) a-xyzzy))
	(*setf (plugh-a!! a-xyzzy) (!! 4))
	(*setf (plugh-b!! a-xyzzy) (!! 1.3))
	(*setf (plugh-c!! a-xyzzy) (!! 9))
	(*setf (plugh-d!! a-xyzzy) t!!)
	(check-slot-values a-xyzzy 4 1.3 9 t '*SETF)
	(*setf (foo-a!! a-xyzzy) (!! 3))
	(*setf (foo-b!! a-xyzzy) (!! 1.2))
	(*setf (plugh-c!! a-xyzzy) (!! 6))
	(*setf (plugh-d!! a-xyzzy) t!!)
	(check-slot-values a-xyzzy 3 1.2 6 t '*SETF/USING-FOO)
	(let ((a (alias!! (plugh-a!! a-xyzzy)))
	      (b (alias!! (plugh-b!! a-xyzzy)))
	      (c (alias!! (plugh-c!! a-xyzzy)))
	      (d (alias!! (plugh-d!! a-xyzzy)))
	      )
	  (*set a (!! 0))
	  (*set b (!! 2.0))
	  (*set c (!! 0))
	  (*set d nil!!)
	  (check-slot-values a-xyzzy 0 2.0 0 nil 'ALIAS!!/*SET)
	  ))

      (format t "~%Testing predicates on structure pvar")

      (*let (a-xyzzy)
	(declare (type (pvar (structure xyzzy)) a-xyzzy))
	(assert (*and (is-it-an-xyzzy?!! a-xyzzy)) () "Predicate is-it-an-xyzzy?!! not everywhere satisfied")
	(assert (*and (foo-p!! a-xyzzy)) () "Predicate foo-p!! not everywhere satisfied")
	(assert (not (*or (is-it-an-xyzzy?!! nil!!))) () "Predicate is-it-an-xyzzy?!! is satisfied of nil!!")
	(assert (not (*or (is-it-an-xyzzy?!! (make-foo!!)))) () "Predicate is-it-an-xyzzy?!! is satisfied of a FOO pvar")
	)

      (format t "~%Testing pref and *setf-pref on structure pvar")

      (*let ((a-xyzzy (create-xyzzy!! :a (!! 1) :b (!! 1.0) :c (!! 1) :d t!!)))
	(declare (type (pvar (structure xyzzy)) a-xyzzy))
	(assert (equalp (create-xyzzy :a 1 :b 1.0 :c 1 :d t) (pref a-xyzzy 0)))
	(*setf (pref a-xyzzy 0) (create-xyzzy :a 5 :b 3.14 :c 2 :d nil))
	(assert (equalp (create-xyzzy :a 5 :b 3.14 :c 2 :d nil) (pref a-xyzzy 0)))
	(*when (zerop!! (self-address!!))
	  (check-slot-values a-xyzzy 5 3.14 2 nil '*SETF-PREF)
	  ))

      (format t "~%Testing copy function")

      (*let ((a-xyzzy (create-xyzzy!!)))
	(declare (type (pvar (structure xyzzy)) a-xyzzy))
	(let ((a-copy-of-a-xyzzy (duplicate-xyzzy!! a-xyzzy)))
	  (check-initial-slot-values a-copy-of-a-xyzzy 'copy-xyzzy!!)
	  ))

      (format t "~%Done testing complex *defstruct functionality~%")

      )))


(defun-wco test-*defstruct ()
  (test-simple-foo-*defstruct)
  (test-complex-xyzzy-*defstruct)
  )



