
    INSTRUCTIONS FOR BRINGING UP THE *LISP SIMULATOR


1.  Requirements:  You must have a Common Lisp running under some 
    version of Unix to use these instructions.  The

    *Lisp Simulator has been known to run under Vaxlisp on Ultrix,
    KCL under 4.2 and 4.3 BSD, Sun Common Lisp under Sun 3.0 and 3.2 Unix,
    and Franz Extended Common Lisp under 4.3 BSD.

    It is possible that
    the version you are receiving has not been tested against every
    Common Lisp in the above list, and that some minor thing might go
    wrong when compiling the system using some version.  Don't panic!
    The problem is probably trivial.  If you can't figure it out, give
    Thinking Machines a call (617-876-1111), and we will try to help you.  

    If you have a different version of Common Lisp then some
    conditionalization of the code will have to be done.

2.  First, decide on a source directory wherein you will store the
    files you are about to extract, and create the directory.

    suggestion: /usr/src/local/starlisp-simulator/f19/

    Now change to this directory.  The instructions assume will you
    stay in this directory for the duration.

3.  If you have a tar tape, extract the files using

    tar xv

    If you have a shar archive (called, e.g., foo), extract 
    the files following the directions at the beginning of the
    shar file, or try

    unshar foo

    If you are using ftp, just copy all the files in the public
    directory whose name you were provided with over to your
    machine into the directory you just created.

4.  The *Lisp simulator comes with a primitive DEFSYSTEM (i.e.,
    a 'make' facility for Lisp programs).  It assumes that a library 
    directory exists with all the DEFSYSTEM files.  Create this
    directory (suggestion: /usr/local/lib/commonlisp/defsystem).

    One of the files you extracted is called make.lisp.  Edit this
    file and change the second element of the
    *defsystem-search-path* initial value list to reflect your
    choice of library directory.  You may also have to add to or
    change the variable *all-possible-lisp-extensions* if you use
    some extension for lisp files not included on that list.  (If you
    are still using old Sun's or old Sun software you may have to
    change .2bin to .lbin).

    Another of the files you extracted ends in the extension .sys.
    (It is probably called release.sys or f19.sys, I will henceforth
    assume its name is f19.sys).  Edit the file, and change
    the Unix pathnames after the strings "STARLISP" and "VERSION"
    to reflect your choice of source directory.  For instance, it
    might look like

    (define-alias "STARLISP" "/usr/src/local/starlisp-simulator/")
    (define-alias "VERSION" "f19/")

    Finally, move f19.sys into the library directory you just
    created.

5.  If your Common Lisp is not a version of Common Lisp under which
    this code is known to run (see above), then you may have to
    edit the code and make changes.  Use grep and search
    for all occurrances of "#+" and "#-".  This will indicate
    where conditionals might have to be inserted for your version of
    Common Lisp.  Also, scan all of the file port.lisp, which has
    most of the implementation-dependent code in it.
        
    One of the biggest problems is providing an error handler to use in
    rewriting the 'with-all-errors-trapped' macro, since Common Lisp
    provides no standard way of catching errors.

5.  Load up your Common Lisp.  Compile and load in the make.lisp file.
    Then evaluate the form

    (ms "f19") 

    (or whatever the name of the .sys file you got was).
    This should compile and load the entire *Lisp simulator.

    If you run into a problem in some file, you will have to
    edit the file and correct the problem, if possible.  Once you
    have corrected the problem you can start up new Lisp, load
    in make.lisp again, and rerun the command.  Files which have
    already been compiled will not be recompiled.

4.  Evaluate the form

    (in-package '*LISP)

    By default, the *Lisp simulator comes up cold-booted already, with
    a configuration of 32 processors arranged in an 8 by 4 grid.

5.  If you have succeeded so far, congratulations!  If possible,
    you may wish to 'create a suspended system' or 'dump a core
    image' or whatever your version of Common Lisp calls the
    ability to create an executable image with pre-loaded lisp code.
    (For instance, with KCL, the feature is the SAVE function:
    (SAVE "starsim"), while in Lucid (DISKSAVE "starsim") is the
    proper incantation).  You could then install this executable in
    one of your bin directories (perhaps /usr/local).

    If no such feature exists, you will probably want to put the
    make.lisp file and/or its binary in an accessible place so that when
    others want to run the *Lisp Simulator they can be told simply
    to start Common Lisp, load in this file, and then type

    (ms "f19")

6.  There is a small manual page included, starsim.1.  You may want
    to edit it appropriately and install in in your man pages.



7. Documentation for the *Lisp language can be ordered by contacting

 csg@think.com

 or contact Customer Support at Thinking Machines, 617-876-1111.


At the time this was written the price was $100 for the (huge)
two volume set, the *Lisp Reference Manual, and the *Lisp Dictionary.
